/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ui.quickfix.resolver.AbstractSelectOneResolver;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class DWF_DC_12_Resolver
extends AbstractSelectOneResolver {
    @Override
    protected void openSelectionDialog(final EObject semanticElement, final IMarker marker) {
        final ArrayList<Component> allocatingComponents = new ArrayList<Component>();
        for (ComponentFunctionalAllocation cfa : ((AbstractFunction)semanticElement).getComponentFunctionalAllocations()) {
            Component comp = (Component)cfa.getSourceElement();
            allocatingComponents.add(comp);
        }
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SelectElementsDialog dialog = new SelectElementsDialog(activeShell, "Function Allocation", "Please select a single allocating Component\nOther allocations will be removed", (Collection)allocatingComponents);
                if (dialog.open() == 0) {
                    CapellaDeleteCommand command;
                    Component result = (Component)dialog.getResult().get(0);
                    allocatingComponents.remove(result);
                    ArrayList<ComponentFunctionalAllocation> cfaToBeDeleted = new ArrayList<ComponentFunctionalAllocation>();
                    for (Component toBeDeallocated : allocatingComponents) {
                        for (AbstractTrace outgoing : toBeDeallocated.getOutgoingTraces()) {
                            ComponentFunctionalAllocation cfa;
                            if (!(outgoing instanceof ComponentFunctionalAllocation) || (cfa = (ComponentFunctionalAllocation)outgoing).getFunction() != semanticElement) continue;
                            cfaToBeDeleted.add(cfa);
                        }
                    }
                    boolean confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)TransactionHelper.getExecutionManager((EObject)semanticElement), cfaToBeDeleted);
                    if (confirmDeletion && (command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)semanticElement), cfaToBeDeleted, false, false, true)).canExecute()) {
                        command.execute();
                        DWF_DC_12_Resolver.this.deleteMarker(marker);
                    }
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)semanticElement).execute((ICommand)command);
    }

    @Override
    protected boolean isAvailableFor(EObject obj) {
        return obj != null && obj instanceof AbstractFunction;
    }
}

