/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.osgi.framework.Version;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.migration.Activator;
import org.polarsys.capella.core.data.migration.MigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationContributor;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;

public class AssociationCDBMigrationContributor
extends AirdMigrationContributor {
    public static final Version MIGRATION_MAX_VERSION_EXPECTED = new Version(7, 0, 0);

    private boolean isClassDiagramBlank(DDiagram diagram) {
        String diagramName = "Class Diagram Blank";
        return diagram.getDescription().getName().equalsIgnoreCase(diagramName);
    }

    private boolean isAssociation(DDiagram diagram, DEdge edge) {
        String mappingName = "DT_Association";
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        if (mapping == null) {
            return false;
        }
        return DiagramServices.getDiagramServices().isMapping((DDiagramElement)edge, (DiagramElementMapping)mapping);
    }

    private void migrateDEdgeStyle(DEdge dEdge) {
        Session.of((EObject)dEdge).ifPresent(session -> {
            EObject containerVariable;
            EObject eObject = dEdge.eContainer();
            if (eObject instanceof DSemanticDecorator) {
                DSemanticDecorator dEdgeContainer = (DSemanticDecorator)eObject;
                containerVariable = dEdgeContainer.getTarget();
            } else {
                containerVariable = null;
            }
            IInterpreter interpreter = session.getInterpreter();
            interpreter.setVariable("diagram", (Object)dEdge.getParentDiagram());
            interpreter.setVariable("view", (Object)dEdge);
            interpreter.setVariable("sourceView", (Object)dEdge.getSourceNode());
            interpreter.setVariable("targetView", (Object)dEdge.getTargetNode());
            StyleDescription styleDescription = new MappingWithInterpreterHelper(interpreter).getBestStyleDescription(dEdge.getDiagramElementMapping(), dEdge.getTarget(), (EObject)dEdge, containerVariable, dEdge.getParentDiagram());
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("view");
            interpreter.unSetVariable("sourceView");
            interpreter.unSetVariable("targetView");
            dEdge.getOwnedStyle().setDescription(styleDescription);
        });
    }

    private void migrateDEdge(DEdge dEdge) {
        EdgeTarget sourceNode = dEdge.getSourceNode();
        EdgeTarget targetNode = dEdge.getTargetNode();
        String beginLabel = dEdge.getBeginLabel();
        String endLabel = dEdge.getEndLabel();
        EdgeArrows sourceArrow = dEdge.getOwnedStyle().getSourceArrow();
        EdgeArrows targetArrow = dEdge.getOwnedStyle().getTargetArrow();
        EList customFeatures = dEdge.getOwnedStyle().getCustomFeatures();
        EList sourceNodeIncommingEdges = sourceNode.getIncomingEdges();
        EList sourceNodeOutgoingEdges = sourceNode.getOutgoingEdges();
        EList targetNodeIncommingEdges = targetNode.getIncomingEdges();
        EList targetNodeOutgoingEdges = targetNode.getOutgoingEdges();
        dEdge.setSourceNode(targetNode);
        dEdge.setTargetNode(sourceNode);
        dEdge.setBeginLabel(endLabel);
        dEdge.setEndLabel(beginLabel);
        sourceNodeOutgoingEdges.remove(dEdge);
        targetNodeIncommingEdges.remove(dEdge);
        sourceNodeIncommingEdges.add(dEdge);
        targetNodeOutgoingEdges.add(dEdge);
        dEdge.getOwnedStyle().setSourceArrow(targetArrow);
        dEdge.getOwnedStyle().setTargetArrow(sourceArrow);
        String sourceArrowFeatureName = DiagramPackage.eINSTANCE.getEdgeStyle_SourceArrow().getName();
        String targetArrowFeatureName = DiagramPackage.eINSTANCE.getEdgeStyle_TargetArrow().getName();
        boolean containsSourceArrowFeatureName = customFeatures.contains(sourceArrowFeatureName);
        boolean containsTargetArrowFeatureName = customFeatures.contains(targetArrowFeatureName);
        if (containsSourceArrowFeatureName && !containsTargetArrowFeatureName) {
            customFeatures.add(targetArrowFeatureName);
            customFeatures.remove(sourceArrowFeatureName);
        } else if (!containsSourceArrowFeatureName && containsTargetArrowFeatureName) {
            customFeatures.add(sourceArrowFeatureName);
            customFeatures.remove(targetArrowFeatureName);
        }
        this.migrateDEdgeStyle(dEdge);
    }

    private boolean isBeginLabel(Object view) {
        Node node;
        return view instanceof Node && SiriusVisualIDRegistry.getVisualID((String)(node = (Node)view).getType()) == 6002;
    }

    private boolean isMiddleLabel(Object view) {
        Node node;
        return view instanceof Node && SiriusVisualIDRegistry.getVisualID((String)(node = (Node)view).getType()) == 6001;
    }

    private boolean isEndLabel(Object view) {
        Node node;
        return view instanceof Node && SiriusVisualIDRegistry.getVisualID((String)(node = (Node)view).getType()) == 6003;
    }

    private Object migrateBendpoint(Object rawBendpoint) {
        if (rawBendpoint instanceof RelativeBendpoint) {
            RelativeBendpoint bp = (RelativeBendpoint)rawBendpoint;
            return new RelativeBendpoint(bp.getTargetX(), bp.getTargetY(), bp.getSourceX(), bp.getSourceY());
        }
        return rawBendpoint;
    }

    private List<?> getReversedBendpoints(List<?> points) {
        List<Object> newPoints = Arrays.asList(points.stream().map(this::migrateBendpoint).toArray());
        Collections.reverse(newPoints);
        return newPoints;
    }

    private Point getBendpointSourcePosition(Object rawBendpoint) {
        if (rawBendpoint instanceof RelativeBendpoint) {
            RelativeBendpoint bp = (RelativeBendpoint)rawBendpoint;
            return new Point(bp.getSourceX(), bp.getSourceY());
        }
        return null;
    }

    private Point getBendpointTargetPosition(Object rawBendpoint) {
        if (rawBendpoint instanceof RelativeBendpoint) {
            RelativeBendpoint bp = (RelativeBendpoint)rawBendpoint;
            return new Point(bp.getTargetX(), bp.getTargetY());
        }
        return null;
    }

    private Collector<Point, PointList, PointList> pointListCollector() {
        return Collector.of(PointList::new, PointList::addPoint, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, new Collector.Characteristics[0]);
    }

    private int getLabelLocation(Node label) {
        switch (SiriusVisualIDRegistry.getVisualID((View)label)) {
            case 6002: {
                return 15;
            }
            case 6003: {
                return 85;
            }
        }
        return 50;
    }

    private int getLabelReverseLocation(Node label) {
        switch (SiriusVisualIDRegistry.getVisualID((View)label)) {
            case 6002: {
                return 85;
            }
            case 6003: {
                return 15;
            }
        }
        return 50;
    }

    private Point getNewLabelPosition(Node label, Bounds bounds, List<?> bendPoints, List<?> revBendPoints) {
        Point labelOffset = new Point(bounds.getX(), bounds.getY());
        PointList bendPointList = bendPoints.stream().map(this::getBendpointTargetPosition).collect(this.pointListCollector());
        PointList newBendPointList = revBendPoints.stream().map(this::getBendpointSourcePosition).collect(this.pointListCollector());
        int referenceLocation = this.getLabelLocation(label);
        int newReferenceLocation = this.getLabelReverseLocation(label);
        Point referencePoint = PointListUtilities.calculatePointRelativeToLine((PointList)bendPointList, (int)0, (int)referenceLocation, (boolean)true);
        Point newReferencePoint = PointListUtilities.calculatePointRelativeToLine((PointList)newBendPointList, (int)0, (int)newReferenceLocation, (boolean)true);
        Point labelCenter = EdgeLabelQuery.relativeCenterCoordinateFromOffset((PointList)bendPointList, (Point)referencePoint, (Point)labelOffset);
        return EdgeLabelQuery.offsetFromRelativeCoordinate((Point)labelCenter, (PointList)newBendPointList, (Point)newReferencePoint);
    }

    private void migrateLabelPosition(Node label, List<?> bendPoints, List<?> revBendPoints) {
        Bounds bounds = (Bounds)label.getLayoutConstraint();
        Point newPosition = this.getNewLabelPosition(label, bounds, bendPoints, revBendPoints);
        bounds.setX(newPosition.x());
        bounds.setY(newPosition.y());
    }

    private void migrateGMFEdge(Edge gmfEdge) {
        View sourceView = gmfEdge.getSource();
        View targetView = gmfEdge.getTarget();
        EList sourceViewSourceEdges = sourceView.getSourceEdges();
        EList sourceViewTargetEdges = sourceView.getTargetEdges();
        EList targetViewSourceEdges = targetView.getSourceEdges();
        EList targetViewTargetEdges = targetView.getTargetEdges();
        Anchor sourceAnchor = gmfEdge.getSourceAnchor();
        Anchor targetAnchor = gmfEdge.getTargetAnchor();
        RelativeBendpoints bendpoints = (RelativeBendpoints)gmfEdge.getBendpoints();
        List bendpointsList = bendpoints.getPoints();
        List<?> revBendpointsList = this.getReversedBendpoints(bendpointsList);
        EList edgeChildren = gmfEdge.getChildren();
        Optional<Node> beginLabel = edgeChildren.stream().filter(this::isBeginLabel).map(Node.class::cast).findAny();
        Optional<Node> middleLabel = edgeChildren.stream().filter(this::isMiddleLabel).map(Node.class::cast).findAny();
        Optional<Node> endLabel = edgeChildren.stream().filter(this::isEndLabel).map(Node.class::cast).findAny();
        if (!bendpointsList.isEmpty()) {
            beginLabel.ifPresent(label -> this.migrateLabelPosition((Node)label, bendpointsList, revBendpointsList));
            middleLabel.ifPresent(label -> this.migrateLabelPosition((Node)label, bendpointsList, revBendpointsList));
            endLabel.ifPresent(label -> this.migrateLabelPosition((Node)label, bendpointsList, revBendpointsList));
        }
        beginLabel.ifPresent(label -> label.setType(SiriusVisualIDRegistry.getType((int)6003)));
        endLabel.ifPresent(label -> label.setType(SiriusVisualIDRegistry.getType((int)6002)));
        gmfEdge.setSource(targetView);
        gmfEdge.setTarget(sourceView);
        sourceViewTargetEdges.add(gmfEdge);
        targetViewSourceEdges.add(gmfEdge);
        sourceViewSourceEdges.remove(gmfEdge);
        targetViewTargetEdges.remove(gmfEdge);
        gmfEdge.setSourceAnchor(targetAnchor);
        gmfEdge.setTargetAnchor(sourceAnchor);
        bendpoints.setPoints(revBendpointsList);
    }

    private void migrateAssociation(DEdge dEdge) {
        this.migrateDEdge(dEdge);
        this.migrateGMFEdge(SiriusGMFHelper.getGmfEdge((DDiagramElement)dEdge));
    }

    private boolean needMigration(DEdge dEdge) {
        EObject eObject = dEdge.getTarget();
        if (eObject instanceof Association) {
            Association association = (Association)eObject;
            Property sourceProp = InformationServices.getService().getAssociationSource(association);
            Property targetProp = InformationServices.getService().getAssociationTarget(association);
            AbstractType expectedSource = sourceProp.getAbstractType();
            AbstractType expectedTarget = targetProp.getAbstractType();
            EdgeTarget edgeTarget = dEdge.getSourceNode();
            if (edgeTarget instanceof DSemanticDecorator) {
                DSemanticDecorator sourceNode = (DSemanticDecorator)edgeTarget;
                EdgeTarget edgeTarget2 = dEdge.getTargetNode();
                if (edgeTarget2 instanceof DSemanticDecorator) {
                    DSemanticDecorator targetNode = (DSemanticDecorator)edgeTarget2;
                    EObject sourceObject = sourceNode.getTarget();
                    EObject targetObject = targetNode.getTarget();
                    return sourceObject == expectedTarget && targetObject == expectedSource;
                }
            }
            String errorMsg = MessageFormat.format(Messages.MigrationAction_InvalidEdgeExtremityInvalidType, dEdge.getName(), dEdge.getParentDiagram().getName());
            Activator.getDefault().getLog().error(errorMsg, (Throwable)new ClassCastException(errorMsg));
            return false;
        }
        return false;
    }

    private void migrateClassDiagramBlank(DDiagram diagram) {
        diagram.getEdges().stream().filter(edge -> this.isAssociation(diagram, (DEdge)edge)).filter(this::needMigration).forEach(this::migrateAssociation);
    }

    private void migrate(Session session) {
        session.getOwnedViews().stream().flatMap(dView -> dView.getOwnedRepresentationDescriptors().stream()).map(dRepDesc -> dRepDesc.getRepresentation()).filter(DDiagram.class::isInstance).map(DDiagram.class::cast).filter(this::isClassDiagramBlank).forEach(this::migrateClassDiagramBlank);
    }

    @Override
    public MigrationRunnable getRunnable(IFile file) {
        return new AirdMigrationRunnable(file){

            @Override
            public String getName() {
                return Messages.MigrationAction_AssociationCDBMigration;
            }

            @Override
            public IStatus run(MigrationContext context, boolean checkVersion) {
                IFile airdFile = this.getFile();
                if (context.getFileVersion(airdFile).compareTo(MIGRATION_MAX_VERSION_EXPECTED) > 0) {
                    return Status.OK_STATUS;
                }
                URI airdURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
                final Session session = SessionManager.INSTANCE.getSession(airdURI, (IProgressMonitor)new NullProgressMonitor());
                if (session != null) {
                    session.open((IProgressMonitor)new NullProgressMonitor());
                    TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            AssociationCDBMigrationContributor.this.migrate(session);
                        }
                    });
                    session.save((IProgressMonitor)new NullProgressMonitor());
                    session.close((IProgressMonitor)new NullProgressMonitor());
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    public String getKind() {
        return "MIGRATION_KIND__ASSOCIATION_CDB";
    }
}

