/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.migration.Activator;
import org.polarsys.capella.core.data.migration.MigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationContributor;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;

public class AutoSizeSquareStyleMigrationContributor
extends AirdMigrationContributor {
    @Override
    public MigrationRunnable getRunnable(IFile file) {
        return new AirdMigrationRunnable(file){

            @Override
            public String getName() {
                return Messages.MigrationAction_AutoSizeSquareStyleMigration;
            }

            @Override
            public IStatus run(MigrationContext context, boolean checkVersion) {
                IFile airdFile = this.getFile();
                URI airdURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
                final Session session = SessionManager.INSTANCE.getSession(airdURI, (IProgressMonitor)new NullProgressMonitor());
                if (session != null) {
                    session.open((IProgressMonitor)new NullProgressMonitor());
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                        protected void doExecute() {
                            AutoSizeSquareStyleMigrationContributor.this.updateSquareStyle(session);
                        }
                    });
                    session.save((IProgressMonitor)new NullProgressMonitor());
                    session.close((IProgressMonitor)new NullProgressMonitor());
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void updateSquareStyle(Session session) {
        Optional sharedMainDAnalysis = session.getSharedMainDAnalysis();
        if (sharedMainDAnalysis.isPresent()) {
            DAnalysis dAnalysis = (DAnalysis)sharedMainDAnalysis.get();
            List<DNode> allDNodeWithAutoSizedSquareStyle = this.getAllDNodeWithAutoSizeSquareStyle(dAnalysis);
            for (DNode dNode : allDNodeWithAutoSizedSquareStyle) {
                Integer computedSCE;
                NodeStyle nodeStyle = dNode.getOwnedStyle();
                if (!(nodeStyle instanceof Square)) continue;
                Square squareStyle = (Square)nodeStyle;
                NodeStyleDescription nodeStyleDescription = dNode.getActualMapping().getStyle();
                if (!(nodeStyleDescription instanceof SquareDescription)) continue;
                SquareDescription squareDesc = (SquareDescription)nodeStyleDescription;
                if (squareStyle.getWidth() != -1 || squareStyle.getHeight() != -1) {
                    squareStyle.setWidth(Integer.valueOf(-1));
                    squareStyle.setHeight(Integer.valueOf(-1));
                }
                if ((computedSCE = this.getSizeComputationExpressionValue(dNode, session.getInterpreter(), squareDesc.getSizeComputationExpression())) == null) continue;
                dNode.setHeight(computedSCE);
                dNode.setWidth(computedSCE);
            }
        }
    }

    private List<DNode> getAllDNodeWithAutoSizeSquareStyle(DAnalysis dAnalysis) {
        List repdesc = dAnalysis.getOwnedViews().stream().flatMap(dView -> dView.getOwnedRepresentationDescriptors().stream()).toList();
        List<DRepresentation> allRepresentations = repdesc.stream().map(DRepresentationDescriptor::getRepresentation).toList();
        List<DNode> allDNodes = allRepresentations.stream().flatMap(rep -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(rep.eAllContents(), 0), false)).filter(DNode.class::isInstance).map(DNode.class::cast).toList();
        List<DNode> allDNodeWithAutoSizedSquareStyle = allDNodes.stream().filter(dnode -> {
            NodeStyle nodeStyle = dnode.getOwnedStyle();
            if (!(nodeStyle instanceof Square)) return false;
            Square ownedStyle = (Square)nodeStyle;
            NodeStyleDescription nodeStyleDescription = dnode.getActualMapping().getStyle();
            if (!(nodeStyleDescription instanceof SquareDescription)) return false;
            SquareDescription squareDesc = (SquareDescription)nodeStyleDescription;
            if (squareDesc.getWidth() != -1) return false;
            if (squareDesc.getHeight() != -1) return false;
            if (ownedStyle.getLabelPosition().getValue() != 1) return false;
            return true;
        }).toList();
        return allDNodeWithAutoSizedSquareStyle;
    }

    private Integer getSizeComputationExpressionValue(DNode dNode, IInterpreter interpreter, String sizeComputationExpression) {
        Integer result = null;
        if (sizeComputationExpression != null && !sizeComputationExpression.isBlank() && interpreter != null) {
            try {
                result = interpreter.evaluateInteger((EObject)dNode, sizeComputationExpression);
            }
            catch (EvaluationException e) {
                String errorMsg = MessageFormat.format(org.polarsys.capella.core.data.migration.contribution.Messages.MigrationAction_AutoSizeSquareNodes_sizeComputationExpressionEvaluationError, sizeComputationExpression, dNode.getName(), dNode.getParentDiagram().getName(), dNode.getActualMapping().getName());
                Activator.getDefault().getLog().error(errorMsg, (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getKind() {
        return "MIGRATION_KIND__AUTOSIZE_SQUARE_STYLE";
    }
}

