/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.group.renderer;

import java.util.Collection;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class DefaultGroupRenderer
implements IGroupRenderer {
    public static final String PARAMETER_GROUP_INDEX = "PARAMETER_GROUP_INDEX";

    @Override
    public void render(Composite parent, IRendererContext context) {
        IPropertyGroup group = context.getPropertyGroup(this);
        this.renderGroup(parent, group, context.getPropertyContext(), context, context.getLabelProvider());
    }

    protected String getGroupName(IPropertyGroup group) {
        if (group.getName() == null || group.getName().length() == 0) {
            return "";
        }
        return " " + group.getName() + " ";
    }

    protected Composite createGroup(Composite parent, IPropertyGroup group, IPropertyContext context, IRendererContext rendererContext) {
        Composite parentComposite = null;
        parentComposite = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            parentComposite.setLayout((Layout)gridLayout);
            parentComposite.setLayoutData((Object)new GridData(768));
        }
        Group newGroup = new Group(parentComposite, 0);
        newGroup.setText(this.getGroupName(group));
        newGroup.setData((Object)group);
        if (parent.getLayout() instanceof GridLayout) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.marginHeight = 0;
            gridLayout2.marginWidth = 0;
            gridLayout2.numColumns = 2;
            newGroup.setLayout((Layout)gridLayout2);
            newGroup.setLayoutData((Object)new GridData(1808));
        }
        parentComposite = newGroup;
        return parentComposite;
    }

    public Label createPartLabel(Composite parent, IProperty item, boolean required) {
        Label label = new Label(parent, 0);
        if (item.getDescription() != null && !item.getDescription().isEmpty()) {
            label.setToolTipText(item.getDescription());
        }
        if (item.getName() != null && !item.getName().isEmpty()) {
            label.setText(item.getName() + " :   ");
        }
        if (required) {
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        return label;
    }

    protected Composite renderGroup(Composite parent, IPropertyGroup group, IPropertyContext context, IRendererContext rendererContext, ILabelProvider labelProvider) {
        Composite parentComposite = null;
        Collection<IPropertyGroup> childGroups = rendererContext.getRenderers().getGroups(context.getProperties(), group);
        Collection<IProperty> childProperties = rendererContext.getRenderers().getItems(context.getProperties(), group);
        if (childGroups.size() == 0 && childProperties.size() == 0) {
            return parent;
        }
        for (IPropertyGroup item : childGroups) {
            try {
                IGroupRenderer groupRenderer;
                if (parentComposite == null) {
                    parentComposite = this.createParentComposite(parent, group, context, rendererContext);
                }
                if ((groupRenderer = rendererContext.getRenderer(item)) == null) continue;
                groupRenderer.render(parentComposite, rendererContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean displayLabels = this.isDisplayLabel(group);
        for (IProperty item : childProperties) {
            try {
                IPropertyRenderer renderer = rendererContext.getRenderer(item);
                if (renderer == null) continue;
                if (parentComposite == null) {
                    parentComposite = this.createParentComposite(parent, group, context, rendererContext);
                }
                if (displayLabels) {
                    Label label = this.createPartLabel(parentComposite, item, false);
                    GridData data = new GridData();
                    label.setLayoutData((Object)data);
                }
                rendererContext.putParameter("PARAMETER_RENDER_LABEL", !displayLabels);
                renderer.render(parentComposite, rendererContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return parentComposite;
    }

    private Composite createParentComposite(Composite parent, IPropertyGroup group, IPropertyContext context, IRendererContext rendererContext) {
        Composite parentComposite = this.createGroup(parent, group, context, rendererContext);
        parentComposite.setLayout(this.createGroupLayout(group, rendererContext));
        parentComposite.setLayoutData(this.createGroupLayoutData(group, rendererContext));
        if (parentComposite.getLayout() instanceof GridLayout) {
            ((GridLayout)parentComposite.getLayout()).numColumns = (this.isDisplayLabel(group) ? 1 : 0) + 1;
        }
        return parentComposite;
    }

    protected boolean isDisplayLabel(IPropertyGroup group) {
        return false;
    }

    protected Object createGroupLayoutData(IPropertyGroup group, IRendererContext rendererContext) {
        return new GridData(4, 4, true, true);
    }

    protected Layout createGroupLayout(IPropertyGroup group, IRendererContext rendererContext) {
        return new GridLayout(1, false);
    }

    protected int getGridColumn(IPropertyGroup item, IRendererContext rendererContext) {
        return 1;
    }

    @Override
    public void dispose(IRendererContext context) {
    }

    @Override
    public void updatedValue(IPropertyGroup propertyGroup, IRendererContext context) {
    }
}

