/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;

public class AbstractFunctionExt {
    public static Set<AbstractFunction> getRecursiveAllocatedFunctions(Set<AbstractFunction> allocatedFunctions, Set<AbstractFunction> functionsToCheck) {
        HashSet<AbstractFunction> newfunctionsToCheck = new HashSet<AbstractFunction>();
        HashSet<AbstractFunction> returnedAllocatedFunctions = new HashSet<AbstractFunction>(allocatedFunctions);
        for (AbstractFunction aFunction : functionsToCheck) {
            EObject container = aFunction.eContainer();
            if (!(container instanceof AbstractFunction)) continue;
            boolean toAdd = true;
            for (AbstractFunction aSubFunction : ((AbstractFunction)container).getSubFunctions()) {
                if (allocatedFunctions.contains(aSubFunction)) continue;
                toAdd = false;
                newfunctionsToCheck.add(aFunction);
                break;
            }
            if (!toAdd) continue;
            returnedAllocatedFunctions.add((AbstractFunction)container);
            newfunctionsToCheck.add((AbstractFunction)container);
        }
        boolean checkParents = false;
        for (AbstractFunction aFunction : returnedAllocatedFunctions) {
            if (allocatedFunctions.contains(aFunction)) continue;
            checkParents = true;
            break;
        }
        if (checkParents) {
            return AbstractFunctionExt.getRecursiveAllocatedFunctions(returnedAllocatedFunctions, newfunctionsToCheck);
        }
        return returnedAllocatedFunctions;
    }

    public static List<AbstractFunction> getAllocatedFunctions(Component component) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        HashSet<AbstractFunction> allocatedFunctions = new HashSet<AbstractFunction>();
        allocatedFunctions.addAll((Collection<AbstractFunction>)component.getAllocatedFunctions());
        returnedList.addAll(AbstractFunctionExt.getRecursiveAllocatedFunctions(allocatedFunctions, allocatedFunctions));
        return returnedList;
    }

    public static List<AbstractFunction> getAllocatedOperationalActivities(Role role) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        HashSet<AbstractFunction> allocatedFunctions = new HashSet<AbstractFunction>();
        for (ActivityAllocation anAllocation : role.getOwnedActivityAllocations()) {
            if (anAllocation.getTargetElement() == null || !(anAllocation.getTargetElement() instanceof OperationalActivity)) continue;
            allocatedFunctions.add((AbstractFunction)((OperationalActivity)anAllocation.getTargetElement()));
        }
        returnedList.addAll(AbstractFunctionExt.getRecursiveAllocatedFunctions(allocatedFunctions, allocatedFunctions));
        return returnedList;
    }

    public static List<CapellaElement> getAllAllocatedFunctionalExchangeFiltered(AbstractFunctionalBlock sourceBlock, AbstractFunctionalBlock targetBlock) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        ArrayList srcAllocatedFuns = new ArrayList(1);
        ArrayList tarAllocatedFuns = new ArrayList(1);
        if (sourceBlock instanceof Component && targetBlock instanceof Component) {
            srcAllocatedFuns.addAll(sourceBlock.getAllocatedFunctions());
            tarAllocatedFuns.addAll(targetBlock.getAllocatedFunctions());
            Collection<Component> allSourceRelatedEles = ComponentExt.getAllSubUsedComponents((Component)sourceBlock);
            Collection<Component> allTargetRelatedEles = ComponentExt.getAllSubUsedComponents((Component)targetBlock);
            if (sourceBlock instanceof GeneralizableElement) {
                AbstractFunctionExt.getSuperGElesFilterAsComponent(sourceBlock, allSourceRelatedEles);
                AbstractFunctionExt.getSuperGElesFilterAsComponent(targetBlock, allTargetRelatedEles);
            }
            allSourceRelatedEles.addAll(PartExt.getAllDeployableComponents((Component)sourceBlock));
            allTargetRelatedEles.addAll(PartExt.getAllDeployableComponents((Component)targetBlock));
            for (Component partitionableElement : allSourceRelatedEles) {
                srcAllocatedFuns.addAll(partitionableElement.getAllocatedFunctions());
            }
            for (Component partitionableElement : allTargetRelatedEles) {
                tarAllocatedFuns.addAll(partitionableElement.getAllocatedFunctions());
            }
            for (AbstractFunction abstractFunction : srcAllocatedFuns) {
                List outGoingExchange = FunctionExt.getOutGoingExchange((AbstractFunction)abstractFunction);
                for (FunctionalExchange functionalExchange : outGoingExchange) {
                    AbstractFunction outGoingAbstractFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)functionalExchange);
                    if (outGoingAbstractFunction == null || !tarAllocatedFuns.contains(outGoingAbstractFunction)) continue;
                    list.add((CapellaElement)functionalExchange);
                }
            }
        }
        return list;
    }

    private static void getSuperGElesFilterAsComponent(AbstractFunctionalBlock sourceBlock, Collection<Component> allSourceRelatedEles) {
        List allSuperGEs = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)((GeneralizableElement)sourceBlock));
        for (GeneralizableElement generalizableElement : allSuperGEs) {
            if (!(generalizableElement instanceof Component)) continue;
            allSourceRelatedEles.add((Component)generalizableElement);
        }
    }

    public static List<Object> getAllocationBlocks(Object object) {
        OperationalActivity operationActivity;
        EList allocatingRoles;
        AbstractFunction abstractFunction;
        EList allocationBlocks;
        if (object == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (object instanceof AbstractFunction && (allocationBlocks = (abstractFunction = (AbstractFunction)object).getAllocationBlocks()) != null) {
            result.addAll((Collection<Object>)allocationBlocks);
        }
        if (object instanceof OperationalActivity && (allocatingRoles = (operationActivity = (OperationalActivity)object).getAllocatingRoles()) != null) {
            result.addAll((Collection<Object>)allocatingRoles);
        }
        return result;
    }

    public static final boolean isLeaf(AbstractFunction function) {
        if (function == null) {
            return false;
        }
        return FunctionExt.isLeaf((AbstractFunction)function);
    }

    public static boolean isAbstractFunctionAvailableForAllocation(EObject element) {
        boolean isAllocated = false;
        if (element == null || !(element instanceof AbstractFunction)) {
            return false;
        }
        AbstractFunction fun = (AbstractFunction)element;
        EList incomingTraces = fun.getIncomingTraces();
        for (AbstractTrace abstractTrace : incomingTraces) {
            if (!(abstractTrace instanceof ComponentFunctionalAllocation) && !(abstractTrace instanceof ActivityAllocation)) continue;
            isAllocated = true;
            break;
        }
        return !isAllocated && AbstractFunctionExt.isLeaf(fun);
    }

    public static boolean isFunctionExchangeAvailableForAllocation(EObject element) {
        if (element == null || !(element instanceof FunctionalExchange)) {
            return false;
        }
        FunctionalExchange funExc = (FunctionalExchange)element;
        return funExc.getAllocatingComponentExchanges().size() == 0;
    }

    public static boolean isComponentExchangeAvailableForAllocation(EObject element) {
        if (element == null || !(element instanceof ComponentExchange)) {
            return false;
        }
        ComponentExchange compExc = (ComponentExchange)element;
        EList incomingTraces = compExc.getIncomingTraces();
        if (incomingTraces.isEmpty()) {
            return true;
        }
        for (AbstractTrace abstractTrace : incomingTraces) {
            ComponentExchangeAllocation allocation;
            ComponentExchangeAllocator allocator;
            if (!(abstractTrace instanceof ComponentExchangeAllocation) || (allocator = (allocation = (ComponentExchangeAllocation)abstractTrace).getComponentExchangeAllocator()) == null || !(allocator instanceof PhysicalLink)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPCPartAvailableForDeployment(EObject object) {
        Part part;
        return object != null && object instanceof Part && (part = (Part)object).getDeployingLinks().size() == 0;
    }

    public static List<CapellaElement> getExchangeSourceAndTargetPorts(FunctionalExchange exchange) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(0);
        if (exchange != null) {
            ActivityNode target;
            ActivityNode source = exchange.getSource();
            if (source != null && source instanceof FunctionPort) {
                result.add((CapellaElement)source);
            }
            if ((target = exchange.getTarget()) != null && target instanceof FunctionPort) {
                result.add((CapellaElement)target);
            }
        }
        return result;
    }

    public static Collection<AbstractExchangeItem> getAllExchangeItems(AbstractFunction abstractFunction) {
        EList exchangeItems;
        HashSet<AbstractExchangeItem> returnedItems = new HashSet<AbstractExchangeItem>();
        EList inputs = abstractFunction.getInputs();
        EList outputs = abstractFunction.getOutputs();
        for (FunctionInputPort inputPin : inputs) {
            exchangeItems = inputPin.getIncomingExchangeItems();
            returnedItems.addAll((Collection<AbstractExchangeItem>)exchangeItems);
        }
        for (FunctionOutputPort outputPin : outputs) {
            exchangeItems = outputPin.getOutgoingExchangeItems();
            returnedItems.addAll((Collection<AbstractExchangeItem>)exchangeItems);
        }
        return returnedItems;
    }

    public static List<Component> getAllocatingComponents(AbstractFunction function) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (function.getAllocationBlocks() != null) {
            for (AbstractFunctionalBlock block : function.getAllocationBlocks()) {
                if (!(block instanceof Component)) continue;
                result.add((Component)block);
            }
        }
        return result;
    }

    protected static Collection<Role> getAllocatingRoles(OperationalActivity activity) {
        ArrayList<Role> result = new ArrayList<Role>();
        EList roles = activity.getAllocatingRoles();
        if (roles != null && !roles.isEmpty()) {
            result.addAll((Collection<Role>)roles);
        }
        return result;
    }

    public static List<Component> getMotherFunctionAllocation(AbstractFunction motherFunction) {
        List<Component> motherFunctionAllocatingComponents = AbstractFunctionExt.getAllocatingComponents(motherFunction);
        if (!motherFunctionAllocatingComponents.isEmpty()) {
            return motherFunctionAllocatingComponents;
        }
        List leaves = (List)ModelCache.getCache(FunctionExt::getAllLeafAbstractFunctions, (Object)motherFunction);
        if (leaves == null || leaves.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> allAllocatingComponents = new ArrayList<Component>();
        for (AbstractFunction leaf : leaves) {
            List<Component> allocatingComponents = AbstractFunctionExt.getAllocatingComponents(leaf);
            if (allocatingComponents.isEmpty()) {
                return Collections.emptyList();
            }
            allAllocatingComponents.addAll(allocatingComponents);
        }
        Component commonAncestor = ComponentExt.getFirstCommonComponentAncestor(allAllocatingComponents);
        if (commonAncestor == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(commonAncestor);
    }

    public static List<Component> getMotherAllFunctionAllocation(AbstractFunction motherFunction) {
        List<Component> motherFunctionAllocatingComponents = AbstractFunctionExt.getAllocatingComponents(motherFunction);
        if (!motherFunctionAllocatingComponents.isEmpty()) {
            return motherFunctionAllocatingComponents;
        }
        List owned = (List)ModelCache.getCache(FunctionExt::getAllAbstractFunctions, (Object)motherFunction);
        if (owned == null || owned.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> allAllocatingComponents = new ArrayList<Component>();
        for (AbstractFunction func : owned) {
            List<Component> allocatingComponents = AbstractFunctionExt.getAllocatingComponents(func);
            if (allocatingComponents.isEmpty()) continue;
            allAllocatingComponents.addAll(allocatingComponents);
        }
        return allAllocatingComponents;
    }

    public static List<Role> getMotherActivityRoleAllocation(AbstractFunction motherFunction) {
        ArrayList<Role> result = new ArrayList<Role>();
        if (motherFunction instanceof OperationalActivity) {
            OperationalActivity motherActivity = (OperationalActivity)motherFunction;
            Collection<Role> roles = AbstractFunctionExt.getAllocatingRoles(motherActivity);
            if (!roles.isEmpty()) {
                result.addAll(roles);
            } else {
                List<OperationalActivity> leaves = AbstractFunctionExt.getAllLeafOperationalActivities(motherActivity);
                if (leaves != null && !leaves.isEmpty()) {
                    Iterator<OperationalActivity> it = leaves.iterator();
                    result.addAll(AbstractFunctionExt.getAllocatingRoles(it.next()));
                    while (it.hasNext()) {
                        result.retainAll(AbstractFunctionExt.getAllocatingRoles(it.next()));
                    }
                }
            }
        }
        return result;
    }

    public static List<OperationalActivity> getAllLeafOperationalActivities(OperationalActivity activity) {
        ArrayList<OperationalActivity> result = new ArrayList<OperationalActivity>();
        for (AbstractFunction abstractFunction : (List)ModelCache.getCache(FunctionExt::getAllAbstractFunctions, (Object)activity)) {
            if (!FunctionExt.isLeaf((AbstractFunction)abstractFunction) || !(abstractFunction instanceof OperationalActivity)) continue;
            result.add((OperationalActivity)abstractFunction);
        }
        return result;
    }
}

