/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.AssociationPkg;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;

public class AssociationExt {
    public static Collection<Classifier> getLinkedClassifiers(Association association) {
        HashSet<Classifier> returnedClassifiers = new HashSet<Classifier>();
        for (Property aProperty : AssociationExt.getProperties(association)) {
            if (!(aProperty.getType() instanceof Classifier)) continue;
            returnedClassifiers.add((Classifier)aProperty.getType());
        }
        return returnedClassifiers;
    }

    public static Set<Classifier> getOwnedMembersClassifiers(Association association) {
        HashSet<Classifier> returnedClassifiers = new HashSet<Classifier>();
        for (Property aProperty : AssociationExt.getOwnedMembersProperties(association)) {
            if (!(aProperty.getType() instanceof Classifier)) continue;
            returnedClassifiers.add((Classifier)aProperty.getType());
        }
        return returnedClassifiers;
    }

    public static Set<Classifier> getNavigableMembersClassifiers(Association association) {
        HashSet<Classifier> returnedClassifiers = new HashSet<Classifier>();
        for (Property aProperty : AssociationExt.getNavigableMembersProperties(association)) {
            if (!(aProperty.getType() instanceof Classifier)) continue;
            returnedClassifiers.add((Classifier)aProperty.getType());
        }
        return returnedClassifiers;
    }

    public static Class getSourceClass(Association association) {
        Classifier classifier;
        Set<Classifier> ownedMembersClassifiers = AssociationExt.getOwnedMembersClassifiers(association);
        if (!ownedMembersClassifiers.isEmpty() && (classifier = ownedMembersClassifiers.iterator().next()) instanceof Class) {
            return (Class)classifier;
        }
        return null;
    }

    public static Collection<Property> getProperties(Association association) {
        HashSet<Property> returnedProperties = new HashSet<Property>();
        returnedProperties.addAll((Collection<Property>)association.getNavigableMembers());
        returnedProperties.addAll((Collection<Property>)association.getOwnedMembers());
        return returnedProperties;
    }

    public static Collection<Property> getOwnedMembersProperties(Association association) {
        HashSet<Property> returnedProperties = new HashSet<Property>();
        returnedProperties.addAll((Collection<Property>)association.getOwnedMembers());
        return returnedProperties;
    }

    public static Collection<Property> getNavigableMembersProperties(Association association) {
        HashSet<Property> returnedProperties = new HashSet<Property>();
        returnedProperties.addAll((Collection<Property>)association.getNavigableMembers());
        return returnedProperties;
    }

    public static void moveToCorrectContainer(Association assoc) {
        if (AssociationExt.isUnidirectional((EObject)assoc)) {
            EObject eContainer;
            Set<Classifier> ownedMembers = AssociationExt.getOwnedMembersClassifiers(assoc);
            Classifier sourceClassifier = null;
            if (ownedMembers.iterator().hasNext()) {
                sourceClassifier = ownedMembers.iterator().next();
            }
            if (sourceClassifier != null && (eContainer = sourceClassifier.eContainer()) instanceof DataPkg) {
                AssociationExt.moveToPackage(Arrays.asList(assoc), (DataPkg)eContainer);
            }
        }
        if (AssociationExt.isBidirectional((EObject)assoc) || AssociationExt.isNondirectional((EObject)assoc)) {
            AssociationExt.moveToBestContainer(assoc);
        }
    }

    public static void moveToBestContainer(Association association) {
        EObject bestAncestor = AssociationExt.getLinkedClassifiersCommonAncestor(association);
        if (bestAncestor instanceof AssociationPkg && !association.eContainer().equals(bestAncestor)) {
            ((AssociationPkg)bestAncestor).getOwnedAssociations().add((Object)association);
        }
    }

    public static EObject getLinkedClassifiersCommonAncestor(Association association) {
        return EcoreUtil2.getCommonAncestor(AssociationExt.getLinkedClassifiers(association));
    }

    public static EObject getLinkedClassifiersCommonAncestorOtherwiseSelfContainer(Association association) {
        EObject commonAncestor;
        Collection<Classifier> linkedClassifiers = AssociationExt.getLinkedClassifiers(association);
        if (linkedClassifiers.contains(commonAncestor = EcoreUtil2.getCommonAncestor(linkedClassifiers)) && linkedClassifiers.size() == 1) {
            return commonAncestor != null ? commonAncestor.eContainer() : null;
        }
        return commonAncestor;
    }

    public static boolean isInCommonAncestorOf(Association asso, Collection<Classifier> linkedClassifiers) {
        Classifier next;
        Iterator<Classifier> iterator;
        EObject commonAncestor = EcoreUtil2.getCommonAncestor(linkedClassifiers);
        if (commonAncestor == null || asso.eContainer() == null) {
            return false;
        }
        if (linkedClassifiers != null && linkedClassifiers.size() == 1 && (iterator = linkedClassifiers.iterator()).hasNext() && (next = iterator.next()).eContainer() instanceof DataPkg) {
            commonAncestor = next.eContainer();
        }
        return asso.eContainer().equals(commonAncestor);
    }

    public static void moveToPackage(List<Association> assocs, DataPkg dataPkg) {
        for (Association assoc : assocs) {
            dataPkg.getOwnedAssociations().add((Object)assoc);
        }
    }

    public static boolean isComposition(Association ass) {
        if (ass != null) {
            for (Property property : AssociationExt.getProperties(ass)) {
                AggregationKind aggregationKind = property.getAggregationKind();
                if (aggregationKind == null || aggregationKind != AggregationKind.COMPOSITION) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOfKindAssocation(Association ass) {
        if (ass != null) {
            for (Property property : AssociationExt.getProperties(ass)) {
                AggregationKind aggregationKind = property.getAggregationKind();
                if (aggregationKind == null || aggregationKind != AggregationKind.ASSOCIATION) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUnidirectional(EObject association) {
        if (association instanceof Association) {
            Association assoc = (Association)association;
            return assoc.getNavigableMembers() != null && assoc.getOwnedMembers() != null && assoc.getNavigableMembers().size() == 1 && assoc.getOwnedMembers().size() == 1;
        }
        return false;
    }

    public static boolean isBidirectional(EObject association) {
        if (association instanceof Association) {
            Association assoc = (Association)association;
            return assoc.getNavigableMembers() != null && assoc.getNavigableMembers().size() == 2 && AssociationExt.isNullOrEmpty((EList<Property>)assoc.getOwnedMembers());
        }
        return false;
    }

    public static boolean isNondirectional(EObject association) {
        if (association instanceof Association) {
            Association assoc = (Association)association;
            return assoc.getOwnedMembers() != null && assoc.getOwnedMembers().size() == 2 && AssociationExt.isNullOrEmpty((EList<Property>)assoc.getNavigableMembers());
        }
        return false;
    }

    private static boolean isNullOrEmpty(EList<Property> ownedMembers) {
        return ownedMembers == null || ownedMembers.isEmpty();
    }

    public static boolean isInCorrectLocation(Association ass) {
        boolean assoIsInLinkedClassifiersCommonAcestor;
        EObject sourceClassContainer;
        Class sourceClass;
        return AssociationExt.isUnidirectional((EObject)ass) ? (sourceClass = AssociationExt.getSourceClass(ass)) != null && (sourceClassContainer = sourceClass.eContainer()).equals(ass.eContainer()) : (AssociationExt.isBidirectional((EObject)ass) || AssociationExt.isNondirectional((EObject)ass)) && (assoIsInLinkedClassifiersCommonAcestor = AssociationExt.isInCommonAncestorOf(ass, AssociationExt.getLinkedClassifiers(ass)));
    }
}

