/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class SequenceMessageExt {
    public static SequenceMessage getOppositeSequenceMessage(SequenceMessage sequenceMessage1) {
        Scenario sc;
        boolean flag = false;
        List<SequenceMessage> setPortionMessage = new ArrayList<SequenceMessage>();
        Stack<SequenceMessage> stack = new Stack<SequenceMessage>();
        if (!(sequenceMessage1 == null || sequenceMessage1.getKind().equals((Object)MessageKind.CREATE) || sequenceMessage1.getKind().equals((Object)MessageKind.DELETE) || sequenceMessage1.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL) || (sc = (Scenario)sequenceMessage1.eContainer()) == null)) {
            if (sequenceMessage1.getKind().equals((Object)MessageKind.REPLY)) {
                flag = false;
                Iterator<MessageEnd> it = ScenarioExt.getOwnedMessagesEnds(sc).iterator();
                while (it.hasNext() && !flag) {
                    MessageEnd msgEnd = it.next();
                    if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                    if (!msg.equals(sequenceMessage1)) {
                        setPortionMessage.add(msg);
                        continue;
                    }
                    flag = true;
                }
                setPortionMessage = ListExt.reverse(setPortionMessage);
            } else {
                flag = false;
                for (MessageEnd msgEnd : ScenarioExt.getOwnedMessagesEnds(sc)) {
                    if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                    if (flag) {
                        setPortionMessage.add(msg);
                        continue;
                    }
                    if (!msg.equals(sequenceMessage1)) continue;
                    flag = true;
                }
            }
            for (SequenceMessage msg : setPortionMessage) {
                if (msg.getKind().equals((Object)MessageKind.CREATE) || msg.getKind().equals((Object)MessageKind.DELETE) || msg.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL)) continue;
                if (sequenceMessage1.getKind().equals((Object)MessageKind.REPLY)) {
                    if (msg.getKind().equals((Object)MessageKind.REPLY)) {
                        stack.push(msg);
                        continue;
                    }
                    if (stack.isEmpty()) {
                        return msg;
                    }
                    stack.pop();
                    continue;
                }
                if (msg.getKind().equals((Object)MessageKind.REPLY)) {
                    if (stack.isEmpty()) {
                        return msg;
                    }
                    stack.pop();
                    continue;
                }
                stack.push(msg);
            }
        }
        return null;
    }

    public static List<Interface> getOwnedInterfacesImplementedByReceiverOfSequenceMessage(SequenceMessage currentSequenceMessage) {
        NamedElement component;
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (currentSequenceMessage != null && (component = SequenceMessageExt.getReceiver(currentSequenceMessage)) != null && component instanceof Component) {
            list.addAll(ComponentExt.getImplementedInterfaces((Component)component));
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesUsedBySenderOfSequenceMessage(SequenceMessage currentSequenceMessage) {
        NamedElement component;
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (currentSequenceMessage != null && (component = SequenceMessageExt.getSender(currentSequenceMessage)) != null && component instanceof Component) {
            list.addAll(ComponentExt.getUsedInterfaces((Component)component));
        }
        return list;
    }

    public static NamedElement getSender(SequenceMessage currentSequenceMessage) {
        if (currentSequenceMessage != null) {
            MessageEnd messageEnd = currentSequenceMessage.getSendingEnd();
            return AbstractEndExt.getComponent((AbstractEnd)messageEnd);
        }
        return null;
    }

    public static NamedElement getReceiver(SequenceMessage currentSequenceMessage) {
        if (currentSequenceMessage != null) {
            MessageEnd messageEnd = currentSequenceMessage.getReceivingEnd();
            return AbstractEndExt.getComponent((AbstractEnd)messageEnd);
        }
        return null;
    }

    private static boolean isSDWriteAccessMessage(Component componentSide, ExchangeItem eiSide) {
        for (Interface interf : componentSide.getUsedInterfaces()) {
            for (ExchangeItemAllocation alloc : interf.getOwnedExchangeItemAllocations()) {
                if (alloc.getAllocatedItem() != eiSide) continue;
                return true;
            }
        }
        return false;
    }

    public static String getMessageNameForSharedDataAccess(SequenceMessage message) {
        if (message.getKind() == MessageKind.DELETE) {
            return "";
        }
        if (message.getKind() == MessageKind.REPLY) {
            return "";
        }
        InstanceRole src = message.getSendingEnd().getCovered();
        InstanceRole tgt = message.getReceivingEnd().getCovered();
        if (message.getSendingEnd().getEvent() instanceof EventSentOperation) {
            Component component;
            ExchangeItem ei;
            EventSentOperation eso = (EventSentOperation)message.getSendingEnd().getEvent();
            ExchangeItemAllocation eia = (ExchangeItemAllocation)eso.getOperation();
            if (eia == null) {
                return "";
            }
            CommunicationLinkProtocol protocol = eia.getReceiveProtocol();
            CommunicationLinkProtocol sendProtocol = eia.getSendProtocol();
            if (src.getRepresentedInstance() instanceof ExchangeItemInstance) {
                ei = (ExchangeItem)src.getRepresentedInstance().getAbstractType();
                component = (Component)tgt.getRepresentedInstance().getAbstractType();
            } else {
                component = (Component)src.getRepresentedInstance().getAbstractType();
                ei = (ExchangeItem)tgt.getRepresentedInstance().getAbstractType();
            }
            if (ei == null) {
                return "";
            }
            if (message.getKind() == MessageKind.CREATE) {
                if (ei.getExchangeMechanism() == ExchangeMechanism.SHARED_DATA) {
                    return "CREATE";
                }
                if (ei.getExchangeMechanism() == ExchangeMechanism.EVENT) {
                    if (sendProtocol != CommunicationLinkProtocol.UNSET) {
                        return sendProtocol.toString();
                    }
                    for (CommunicationLink cl : component.getOwnedCommunicationLinks()) {
                        if (cl.getExchangeItem() != ei) continue;
                        return cl.getProtocol().toString();
                    }
                }
            }
            if (SequenceMessageExt.isSDWriteAccessMessage(component, ei)) {
                if (ei.getExchangeMechanism() == ExchangeMechanism.EVENT) {
                    return "SEND";
                }
                return "WRITE";
            }
            if (ei.getExchangeMechanism() == ExchangeMechanism.SHARED_DATA && eia.getReceiveProtocol() != CommunicationLinkProtocol.UNSET) {
                return eia.getReceiveProtocol().toString();
            }
            for (CommunicationLink cl : component.getOwnedCommunicationLinks()) {
                if (cl.getExchangeItem() != ei) continue;
                if (cl.getProtocol() != CommunicationLinkProtocol.UNSET) {
                    return cl.getProtocol().toString();
                }
                return cl.getKind().toString();
            }
            if (ei.getExchangeMechanism() == ExchangeMechanism.EVENT) {
                return CommunicationLinkKind.RECEIVE.toString();
            }
            return protocol.toString();
        }
        return "";
    }

    public static List<Execution> getExecutionFromExecution(Execution execution) {
        ArrayList<Execution> result = new ArrayList<Execution>();
        Scenario scenario = (Scenario)execution.eContainer();
        if (scenario != null) {
            InstanceRole currentIR = execution.getCovered();
            ArrayList<Execution> executionStack = new ArrayList<Execution>();
            for (InteractionFragment ifgt : scenario.getOwnedInteractionFragments()) {
                AbstractEnd ae;
                if (!(ifgt instanceof AbstractEnd) || (ae = (AbstractEnd)ifgt).getCovered() != currentIR) continue;
                for (TimeLapse laptime : scenario.getOwnedTimeLapses()) {
                    Execution exec2;
                    if (!(laptime instanceof Execution) || (exec2 = (Execution)laptime).getCovered() != currentIR) continue;
                    if (exec2.getStart() == ae) {
                        if (SequenceMessageExt.top(executionStack) == execution) {
                            result.add(exec2);
                        }
                        executionStack.add(exec2);
                    }
                    if (exec2.getFinish() != ae) continue;
                    executionStack.remove(exec2);
                }
            }
        }
        return result;
    }

    private static Execution top(List<Execution> stack) {
        if (stack.size() == 0) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    public static Execution getStartedExecution(SequenceMessage seqMsg) {
        MessageEnd re = seqMsg.getReceivingEnd();
        Scenario scenario = (Scenario)seqMsg.eContainer();
        for (TimeLapse tl : scenario.getOwnedTimeLapses()) {
            Execution exec;
            if (!(tl instanceof Execution) || !(exec = (Execution)tl).getStart().equals(re)) continue;
            return exec;
        }
        return null;
    }

    public static Collection<AbstractExchangeItem> getInvalidExchangeItems(SequenceMessage message) {
        EList exchangedItemsFromSequenceMessage = message.getExchangedItems();
        Collection<AbstractExchangeItem> exchangeItemsFromInvokedOperation = SequenceMessageExt.getExchangeItemsFromOperation(message);
        ArrayList<AbstractExchangeItem> invalidExchangeItems = new ArrayList<AbstractExchangeItem>((Collection<AbstractExchangeItem>)exchangedItemsFromSequenceMessage);
        invalidExchangeItems.removeAll(exchangeItemsFromInvokedOperation);
        return invalidExchangeItems;
    }

    public static Collection<AbstractExchangeItem> getExchangeItemsFromOperation(SequenceMessage message) {
        AbstractEventOperation invokedOperation = message.getInvokedOperation();
        Object result = Collections.emptyList();
        if (invokedOperation instanceof FunctionalExchange) {
            FunctionalExchange exchange = (FunctionalExchange)invokedOperation;
            result = exchange.getExchangedItems();
        } else if (invokedOperation instanceof ComponentExchange) {
            ComponentExchange exchange = (ComponentExchange)invokedOperation;
            result = exchange.getConvoyedInformations();
        } else if (invokedOperation instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation exchange = (ExchangeItemAllocation)invokedOperation;
            result = Collections.singletonList(exchange.getAllocatedItem());
        }
        return result;
    }
}

