/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecturePkg;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellacore.ReuseableStructure;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSArchitecturePkg;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecturePkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecturePkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.AbstractPhysicalInstance;
import org.polarsys.capella.core.data.pa.deployment.DeploymentPackage;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.CollectionExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class SystemEngineeringExt {
    public static ModellingArchitecture findArchitecture(EObject ownedElement) {
        ModellingArchitecture result = null;
        EObject current = ownedElement;
        while (result == null && current != null) {
            if (CapellacorePackage.eINSTANCE.getModellingArchitecture().isInstance((Object)current)) {
                result = (ModellingArchitecture)current;
            }
            current = current.eContainer();
        }
        return result;
    }

    public static List<LogicalComponent> getAllAbstractLogicalComponents(CapellaElement currentElement) {
        Set lcSet;
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
        if (la != null) {
            lcSet = EObjectExt.getAll((EObject)la, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        } else {
            LogicalArchitecturePkg laPkg = SystemEngineeringExt.getOwnedLogicalArchitecturePkg(sysEng);
            lcSet = EObjectExt.getAll((EObject)laPkg, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        }
        ArrayList<LogicalComponent> lcList = new ArrayList<LogicalComponent>();
        for (EObject obj : lcSet) {
            lcList.add((LogicalComponent)obj);
        }
        return lcList;
    }

    public static List<DataValue> getAllAvailableDataValues(BlockArchitecture arch) {
        ArrayList<DataValue> availableElements = new ArrayList<DataValue>();
        if (arch != null) {
            PhysicalArchitecture physArch;
            LogicalArchitecture logArch;
            SystemAnalysis ctxArch;
            DataPkg ownedDataPkg;
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)arch);
            OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis(sysEng);
            if (oa != null) {
                DataPkg ownedDataPkg2 = oa.getOwnedDataPkg();
                if (ownedDataPkg2 != null) {
                    availableElements.addAll(DataPkgExt.getAllDataValues(ownedDataPkg2));
                }
            } else {
                SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng);
                ownedDataPkg = ca.getOwnedDataPkg();
                if (ownedDataPkg != null) {
                    availableElements.addAll(DataPkgExt.getAllDataValues(ownedDataPkg));
                }
            }
            if ((oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) && (ownedDataPkg = (ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng)).getOwnedDataPkg()) != null) {
                availableElements.addAll(DataPkgExt.getAllDataValues(ownedDataPkg));
            }
            if ((arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) && (ownedDataPkg = (logArch = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng)).getOwnedDataPkg()) != null) {
                availableElements.addAll(DataPkgExt.getAllDataValues(ownedDataPkg));
            }
            if (arch instanceof EPBSArchitecture && (ownedDataPkg = (physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng)).getOwnedDataPkg()) != null) {
                availableElements.addAll(DataPkgExt.getAllDataValues(ownedDataPkg));
            }
        }
        return availableElements;
    }

    public static List<CapabilityRealization> getAllCapabilityRealization(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        Set capabilityRealizationsSet = EObjectExt.getAll((EObject)sysEng, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        ArrayList<CapabilityRealization> capabilityRealizationsList = new ArrayList<CapabilityRealization>();
        for (EObject obj : capabilityRealizationsSet) {
            capabilityRealizationsList.add((CapabilityRealization)obj);
        }
        return capabilityRealizationsList;
    }

    public static List<CapabilityRealization> getAllCapabilityRealizations(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        Set capabilityRealizationsSet = EObjectExt.getAll((EObject)sysEng, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        ArrayList<CapabilityRealization> capabilityRealizationsList = new ArrayList<CapabilityRealization>();
        for (EObject obj : capabilityRealizationsSet) {
            capabilityRealizationsList.add((CapabilityRealization)obj);
        }
        return capabilityRealizationsList;
    }

    public static List<ConfigurationItem> getAllConfigurationItems(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        EPBSArchitecture epbsArch = SystemEngineeringExt.getEPBSArchitecture(sysEng);
        Set epbsSet = EObjectExt.getAll((EObject)epbsArch, (EClass)EpbsPackage.Literals.CONFIGURATION_ITEM);
        ArrayList<ConfigurationItem> epbsList = new ArrayList<ConfigurationItem>();
        for (EObject obj : epbsSet) {
            epbsList.add((ConfigurationItem)obj);
        }
        return epbsList;
    }

    public static List<InterfacePkg> getAllInterfacePkgs(InterfacePkg pkg) {
        LinkedHashSet<InterfacePkg> result = new LinkedHashSet<InterfacePkg>();
        if (pkg.getOwnedInterfacePkgs() != null) {
            result.addAll((Collection<InterfacePkg>)pkg.getOwnedInterfacePkgs());
            for (InterfacePkg itf : pkg.getOwnedInterfacePkgs()) {
                result.addAll(SystemEngineeringExt.getAllInterfacePkgs(itf));
            }
        }
        return new ArrayList<InterfacePkg>(result);
    }

    public static List<Interface> getAllInterfaces(ModellingArchitecture architecture) {
        EObject object;
        TreeIterator allContents;
        LinkedHashSet<Interface> result = new LinkedHashSet<Interface>();
        LinkedHashSet<InterfacePkg> itfPkgs = new LinkedHashSet<InterfacePkg>();
        if (architecture == null) {
            return new ArrayList<Interface>();
        }
        if (architecture instanceof SystemAnalysis && ((SystemAnalysis)architecture).getOwnedInterfacePkg() != null) {
            itfPkgs.add(((SystemAnalysis)architecture).getOwnedInterfacePkg());
            itfPkgs.addAll(SystemEngineeringExt.getAllInterfacePkgs(((SystemAnalysis)architecture).getOwnedInterfacePkg()));
            allContents = ((SystemAnalysis)architecture).eAllContents();
            while (allContents.hasNext()) {
                object = (EObject)allContents.next();
                if (!(object instanceof Interface)) continue;
                result.add((Interface)object);
            }
        }
        if (architecture instanceof LogicalArchitecture && ((LogicalArchitecture)architecture).getOwnedInterfacePkg() != null) {
            itfPkgs.add(((LogicalArchitecture)architecture).getOwnedInterfacePkg());
            itfPkgs.addAll(SystemEngineeringExt.getAllInterfacePkgs(((LogicalArchitecture)architecture).getOwnedInterfacePkg()));
            allContents = ((LogicalArchitecture)architecture).eAllContents();
            while (allContents.hasNext()) {
                object = (EObject)allContents.next();
                if (!(object instanceof Interface)) continue;
                result.add((Interface)object);
            }
        }
        if (architecture instanceof PhysicalArchitecture && ((PhysicalArchitecture)architecture).getOwnedInterfacePkg() != null) {
            itfPkgs.add(((PhysicalArchitecture)architecture).getOwnedInterfacePkg());
            itfPkgs.addAll(SystemEngineeringExt.getAllInterfacePkgs(((PhysicalArchitecture)architecture).getOwnedInterfacePkg()));
            allContents = ((PhysicalArchitecture)architecture).eAllContents();
            while (allContents.hasNext()) {
                object = (EObject)allContents.next();
                if (!(object instanceof Interface)) continue;
                result.add((Interface)object);
            }
        }
        return new ArrayList<Interface>(result);
    }

    public static List<LogicalArchitecture> getAllLogicalArchitecture(CapellaElement currentElement) {
        ArrayList<LogicalArchitecture> archSet = new ArrayList<LogicalArchitecture>();
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        if (sysEng != null) {
            LogicalArchitecturePkg archPkg;
            LogicalArchitecture arch = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
            if (arch != null) {
                archSet.add(arch);
            }
            if ((archPkg = SystemEngineeringExt.getOwnedLogicalArchitecturePkg(sysEng)) != null) {
                for (LogicalArchitecture la : archPkg.getOwnedLogicalArchitectures()) {
                    archSet.add(la);
                }
            }
        }
        return archSet;
    }

    public static List<LogicalComponent> getAllLogicalComponents(CapellaElement currentElement) {
        Set lcSet;
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
        if (la != null) {
            lcSet = EObjectExt.getAll((EObject)la, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        } else {
            LogicalArchitecturePkg laPkg = SystemEngineeringExt.getOwnedLogicalArchitecturePkg(sysEng);
            lcSet = EObjectExt.getAll((EObject)laPkg, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        }
        ArrayList<LogicalComponent> lcList = new ArrayList<LogicalComponent>();
        for (EObject obj : lcSet) {
            lcList.add((LogicalComponent)obj);
        }
        return lcList;
    }

    public static List<PhysicalArchitecture> getAllPhysicalArchitectures(SystemEngineering systemEngineering) {
        ArrayList<PhysicalArchitecture> list = new ArrayList<PhysicalArchitecture>(1);
        if (systemEngineering != null) {
            PhysicalArchitecturePkg pkg;
            if (SystemEngineeringExt.getOwnedPhysicalArchitecture(systemEngineering) != null) {
                list.add(SystemEngineeringExt.getOwnedPhysicalArchitecture(systemEngineering));
            }
            if ((pkg = SystemEngineeringExt.getOwnedPhysicalArchitecturePkg(systemEngineering)) != null) {
                for (PhysicalArchitecture arch : pkg.getOwnedPhysicalArchitectures()) {
                    if (arch == null) continue;
                    list.add(arch);
                }
            }
        }
        return list;
    }

    public static List<PhysicalComponent> getAllPhysicalComponents(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng);
        Set pcSet = EObjectExt.getAll((EObject)physArch, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
        ArrayList<PhysicalComponent> pcList = new ArrayList<PhysicalComponent>();
        for (EObject obj : pcSet) {
            pcList.add((PhysicalComponent)obj);
        }
        return pcList;
    }

    public static List<PhysicalComponent> getAllPhysicalComponentsByNature(CapellaElement currentElement, PhysicalComponentNature nature) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng);
        Set pcSet = EObjectExt.getAll((EObject)physArch, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
        ArrayList<PhysicalComponent> pcList = new ArrayList<PhysicalComponent>();
        for (EObject obj : pcSet) {
            PhysicalComponent comp = (PhysicalComponent)obj;
            if (nature != null) {
                if (comp.getNature() != nature) continue;
                pcList.add(comp);
                continue;
            }
            pcList.add(comp);
        }
        return pcList;
    }

    public static List<AbstractPhysicalInstance> getAllPhysicalObject(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng);
        Set poSet = EObjectExt.getAll((EObject)physArch, (EClass)DeploymentPackage.Literals.ABSTRACT_PHYSICAL_INSTANCE);
        ArrayList<AbstractPhysicalInstance> poList = new ArrayList<AbstractPhysicalInstance>();
        for (EObject obj : poSet) {
            poList.add((AbstractPhysicalInstance)obj);
        }
        return poList;
    }

    public static EPBSArchitecture getEPBSArchitecture(CapellaElement currentElement) {
        EPBSArchitecture arch = null;
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        if (sysEng != null) {
            arch = SystemEngineeringExt.getEPBSArchitecture(sysEng);
        }
        return arch;
    }

    public static EPBSArchitecture getEPBSArchitecture(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof EPBSArchitecture)) continue;
                return (EPBSArchitecture)block;
            }
        }
        return null;
    }

    public static PhysicalArchitecture getPhysicalArchitecture(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof PhysicalArchitecture)) continue;
                return (PhysicalArchitecture)block;
            }
        }
        return null;
    }

    public static LogicalArchitecture getLogicalArchitecture(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof LogicalArchitecture)) continue;
                return (LogicalArchitecture)block;
            }
        }
        return null;
    }

    public static SystemAnalysis getSystemAnalysis(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof SystemAnalysis)) continue;
                return (SystemAnalysis)block;
            }
        }
        return null;
    }

    public static OperationalAnalysis getOperationalAnalysis(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof OperationalAnalysis)) continue;
                return (OperationalAnalysis)block;
            }
        }
        return null;
    }

    public static EPBSArchitecturePkg getEPBSArchitecturePkg(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecturePkg block : currentElement.getOwnedArchitecturePkgs()) {
                if (!(block instanceof EPBSArchitecturePkg)) continue;
                return (EPBSArchitecturePkg)block;
            }
        }
        return null;
    }

    public static List<Interface> getInterfaces(LogicalArchitecture architecture) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (architecture != null) {
            for (SystemAnalysis ctxArchitecture : CollectionExt.filter(((SystemEngineering)architecture.eContainer()).getOwnedArchitectures(), SystemAnalysis.class)) {
                result.addAll(SystemEngineeringExt.getInterfaces(ctxArchitecture));
            }
            result.addAll(architecture.getOwnedInterfacePkg() != null ? SystemEngineeringExt.getAllInterfaces((ModellingArchitecture)architecture) : Collections.emptyList());
        }
        return new ArrayList<Interface>(result);
    }

    public static List<Interface> getInterfaces(ModellingArchitecture architecture) {
        if (architecture instanceof SystemAnalysis) {
            return SystemEngineeringExt.getInterfaces((SystemAnalysis)architecture);
        }
        if (architecture instanceof LogicalArchitecture) {
            return SystemEngineeringExt.getInterfaces((LogicalArchitecture)architecture);
        }
        if (architecture instanceof PhysicalArchitecture) {
            return SystemEngineeringExt.getInterfaces((PhysicalArchitecture)architecture);
        }
        return Collections.emptyList();
    }

    public static List<Interface> getInterfaces(PhysicalArchitecture architecture) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (architecture != null) {
            for (LogicalArchitecture logArchitecture : CollectionExt.filter(((SystemEngineering)architecture.eContainer()).getOwnedArchitectures(), LogicalArchitecture.class)) {
                result.addAll(SystemEngineeringExt.getInterfaces(logArchitecture));
            }
            result.addAll(architecture.getOwnedInterfacePkg() != null ? SystemEngineeringExt.getAllInterfaces((ModellingArchitecture)architecture) : Collections.emptyList());
        }
        return new ArrayList<Interface>(result);
    }

    public static List<Interface> getInterfaces(SystemAnalysis architecture) {
        return architecture != null && architecture.getOwnedInterfacePkg() != null ? SystemEngineeringExt.getAllInterfaces((ModellingArchitecture)architecture) : Collections.emptyList();
    }

    public static List<LogicalArchitecture> getLogicalArchitecturesFiltered(SystemEngineering systemEngineering, PhysicalArchitecture physicalArchitecture) {
        ArrayList<LogicalArchitecture> list = new ArrayList<LogicalArchitecture>(1);
        if (systemEngineering != null && physicalArchitecture != null) {
            LogicalArchitecturePkg laPkg;
            LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture(systemEngineering);
            if (la != null) {
                list.add(la);
            }
            if ((laPkg = SystemEngineeringExt.getOwnedLogicalArchitecturePkg(systemEngineering)) != null) {
                for (LogicalArchitecture arch : laPkg.getOwnedLogicalArchitectures()) {
                    if (arch == null) continue;
                    list.add(arch);
                }
            }
        }
        return list;
    }

    public static FunctionPkg getOwnedFunctionalAnalysis(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof FunctionPkg)) continue;
                return (FunctionPkg)block;
            }
        }
        return null;
    }

    public static LogicalArchitecture getOwnedLogicalArchitecture(CapellaElement currentElement) {
        LogicalArchitecture arch = null;
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        if (sysEng != null) {
            arch = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
        }
        return arch;
    }

    public static LogicalArchitecture getOwnedLogicalArchitecture(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof LogicalArchitecture)) continue;
                return (LogicalArchitecture)block;
            }
        }
        return null;
    }

    public static LogicalArchitecturePkg getOwnedLogicalArchitecturePkg(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecturePkg block : currentElement.getOwnedArchitecturePkgs()) {
                if (!(block instanceof LogicalArchitecturePkg)) continue;
                return (LogicalArchitecturePkg)block;
            }
        }
        return null;
    }

    public static OperationalAnalysis getOwnedOperationalAnalysis(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof OperationalAnalysis)) continue;
                return (OperationalAnalysis)block;
            }
        }
        return null;
    }

    public static PhysicalArchitecture getOwnedPhysicalArchitecture(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof PhysicalArchitecture)) continue;
                return (PhysicalArchitecture)block;
            }
        }
        return null;
    }

    public static PhysicalArchitecturePkg getOwnedPhysicalArchitecturePkg(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecturePkg block : currentElement.getOwnedArchitecturePkgs()) {
                if (!(block instanceof PhysicalArchitecturePkg)) continue;
                return (PhysicalArchitecturePkg)block;
            }
        }
        return null;
    }

    public static SystemAnalysis getOwnedSystemAnalysis(SystemEngineering currentElement) {
        if (currentElement != null) {
            for (ModellingArchitecture block : currentElement.getOwnedArchitectures()) {
                if (!(block instanceof SystemAnalysis)) continue;
                return (SystemAnalysis)block;
            }
        }
        return null;
    }

    public static PhysicalArchitecture getPhysicalArchitecture(CapellaElement currentElement) {
        PhysicalArchitecture arch = null;
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        if (sysEng != null) {
            arch = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng);
        }
        return arch;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)modelElement);
    }

    public static List<DataPkg> getAllDataPkgs(SystemEngineering systemEn) {
        ArrayList<DataPkg> allPackages = new ArrayList<DataPkg>();
        EList allArchitectures = systemEn.getOwnedArchitectures();
        for (ModellingArchitecture anArchitecture : allArchitectures) {
            for (EObject aDataPkg : EObjectExt.getAll((EObject)anArchitecture, (EClass)InformationPackage.Literals.DATA_PKG)) {
                allPackages.add((DataPkg)aDataPkg);
            }
        }
        return allPackages;
    }

    public static SharedPkg getSharedPkg(CapellaElement modelElement) {
        return (SharedPkg)SystemEngineeringExt.getSharedPkgRecursively((ModelElement)modelElement);
    }

    private static ModelElement getSharedPkgRecursively(ModelElement modelElement) {
        ModelElement result;
        if (modelElement == null) {
            result = null;
        } else if (modelElement instanceof SharedPkg) {
            result = modelElement;
        } else {
            ModelElement container = (ModelElement)modelElement.eContainer();
            result = SystemEngineeringExt.getSharedPkgRecursively(container);
        }
        return result;
    }

    public static List<SharedPkg> getSharedPkgs(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        return SystemEngineeringExt.getSharedPkgs(sysEng);
    }

    public static List<SharedPkg> getSharedPkgs(SystemEngineering sysEng) {
        ArrayList<SharedPkg> sharedPkgs = new ArrayList<SharedPkg>();
        for (ReuseLink lnk : sysEng.getReuseLinks()) {
            ReuseableStructure struct = lnk.getReused();
            if (!(struct instanceof SharedPkg)) continue;
            sharedPkgs.add((SharedPkg)struct);
        }
        return sharedPkgs;
    }

    public static Component getSystem(CapellaElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentElement);
        if (sysEng != null) {
            return SystemEngineeringExt.getSystem(sysEng);
        }
        return null;
    }

    public static Component getSystem(SystemEngineering currentElement) {
        SystemAnalysis ca;
        if (currentElement != null && (ca = SystemEngineeringExt.getOwnedSystemAnalysis(currentElement)) != null) {
            return ca.getSystem();
        }
        return null;
    }

    public static SystemEngineering getSystemEngineering(ExtensibleElement currentElement) {
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering(currentElement);
        return sysEng;
    }

    public static SystemEngineering getSystemEngineering(Project project) {
        for (ModelRoot root : project.getOwnedModelRoots()) {
            if (!(root instanceof SystemEngineering)) continue;
            return (SystemEngineering)root;
        }
        return null;
    }

    public static void setEPBSArchitecturePkg(SystemEngineering currentElement, EPBSArchitecturePkg epbsArchitecturePkg) {
        currentElement.getOwnedArchitecturePkgs().add((Object)epbsArchitecturePkg);
    }
}

