/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;

public class InvolvementHierarchyGraph {
    private static final Logger LOGGER = Logger.getLogger(InvolvementHierarchyGraph.class);
    protected FunctionalChain rootFunctionalChain;
    protected Map<VertexKey, Vertex> vertices;

    public InvolvementHierarchyGraph(FunctionalChain rootFunctionalChain) {
        this.rootFunctionalChain = rootFunctionalChain;
        this.vertices = new HashMap<VertexKey, Vertex>();
        this.constructGraph();
    }

    protected void constructGraph() {
        LinkedList<FunctionalChainReference> referenceHierarchy = new LinkedList<FunctionalChainReference>();
        EList childrenFunctionalChainInvolvements = this.rootFunctionalChain.getOwnedFunctionalChainInvolvements();
        for (FunctionalChainInvolvement childInvolvement : childrenFunctionalChainInvolvements) {
            this.extractAllVertices(childInvolvement, referenceHierarchy);
        }
        for (FunctionalChainInvolvement childInvolvement : childrenFunctionalChainInvolvements) {
            this.extractAllEdges(childInvolvement, referenceHierarchy);
        }
    }

    public Map<VertexKey, Vertex> getVertices() {
        return this.vertices;
    }

    protected void extractAllVertices(FunctionalChainInvolvement current, LinkedList<FunctionalChainReference> currentReferenceHierarchy) {
        if (current instanceof FunctionalChainInvolvementFunction) {
            FunctionalChainInvolvementFunction function = (FunctionalChainInvolvementFunction)current;
            boolean created = this.createVertex(function, currentReferenceHierarchy);
            if (!created) {
                LOGGER.warn((Object)("Vertex already exists: [" + String.valueOf(function) + " " + String.valueOf(currentReferenceHierarchy) + "]"));
            }
        } else if (current instanceof FunctionalChainReference) {
            FunctionalChainReference reference = (FunctionalChainReference)current;
            FunctionalChain chain = reference.getReferencedFunctionalChain();
            EList childrenFunctionalChainInvolvements = chain.getOwnedFunctionalChainInvolvements();
            currentReferenceHierarchy.addFirst(reference);
            for (FunctionalChainInvolvement childInvolvement : childrenFunctionalChainInvolvements) {
                this.extractAllVertices(childInvolvement, currentReferenceHierarchy);
            }
            currentReferenceHierarchy.removeFirst();
        }
    }

    protected void extractAllEdges(FunctionalChainInvolvement current, LinkedList<FunctionalChainReference> currentReferenceHierarchy) {
        if (current instanceof FunctionalChainInvolvementLink) {
            FunctionalChainInvolvementLink link = (FunctionalChainInvolvementLink)current;
            Vertex sourceVertex = this.getSourceVertex(currentReferenceHierarchy, link);
            Vertex targetVertex = this.getTargetVertex(currentReferenceHierarchy, link);
            if (sourceVertex != null && targetVertex != null) {
                this.createEdge(link, sourceVertex, targetVertex);
            } else {
                LOGGER.warn((Object)("Either source or target vertices are null: [" + String.valueOf(link) + " " + String.valueOf(sourceVertex) + " " + String.valueOf(targetVertex) + "]"));
            }
        } else if (current instanceof FunctionalChainReference) {
            FunctionalChainReference reference = (FunctionalChainReference)current;
            FunctionalChain chain = reference.getReferencedFunctionalChain();
            EList childrenFunctionalChainInvolvements = chain.getOwnedFunctionalChainInvolvements();
            currentReferenceHierarchy.addFirst(reference);
            for (FunctionalChainInvolvement childInvolvement : childrenFunctionalChainInvolvements) {
                this.extractAllEdges(childInvolvement, currentReferenceHierarchy);
            }
            currentReferenceHierarchy.removeFirst();
        }
    }

    protected boolean createVertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
        ArrayList<FunctionalChainReference> functionHierarchy = new ArrayList<FunctionalChainReference>(referenceHierarchy);
        VertexKey vertexKey = new VertexKey(function, functionHierarchy);
        if (this.vertices.containsKey(vertexKey)) {
            return false;
        }
        Vertex vertex = new Vertex(function, functionHierarchy);
        this.vertices.put(vertexKey, vertex);
        return true;
    }

    protected Vertex getVertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> functionReferenceHierarchy) {
        VertexKey vertexKey = new VertexKey(function, functionReferenceHierarchy);
        return this.vertices.get(vertexKey);
    }

    protected void createEdge(FunctionalChainInvolvementLink link, Vertex sourceVertex, Vertex targetVertex) {
        Edge edge = new Edge(link, sourceVertex, targetVertex);
        sourceVertex.outgoingEdges.add(edge);
        targetVertex.incomingEdges.add(edge);
    }

    protected Vertex getTargetVertex(LinkedList<FunctionalChainReference> currentReferenceHierarchy, FunctionalChainInvolvementLink link) {
        EList linkTargetReferenceHierarchy = link.getTargetReferenceHierarchy();
        FunctionalChainInvolvementFunction targetFunction = link.getTarget();
        List<FunctionalChainReference> targetFunctionReferenceHierarchy = this.combineHierarchies((List<FunctionalChainReference>)linkTargetReferenceHierarchy, currentReferenceHierarchy);
        return this.getVertex(targetFunction, targetFunctionReferenceHierarchy);
    }

    protected Vertex getSourceVertex(LinkedList<FunctionalChainReference> currentReferenceHierarchy, FunctionalChainInvolvementLink link) {
        EList linkSourceReferenceHierarchy = link.getSourceReferenceHierarchy();
        FunctionalChainInvolvementFunction sourceFunction = link.getSource();
        List<FunctionalChainReference> sourceFunctionReferenceHierarchy = this.combineHierarchies((List<FunctionalChainReference>)linkSourceReferenceHierarchy, currentReferenceHierarchy);
        return this.getVertex(sourceFunction, sourceFunctionReferenceHierarchy);
    }

    protected List<FunctionalChainReference> combineHierarchies(List<FunctionalChainReference> linkReferenceHierarchy, List<FunctionalChainReference> contextReferenceHierarchy) {
        ArrayList<FunctionalChainReference> resultHierarchy = new ArrayList<FunctionalChainReference>(linkReferenceHierarchy);
        resultHierarchy.addAll(contextReferenceHierarchy);
        return resultHierarchy;
    }

    public boolean hasCycle() {
        HashSet<Vertex> visited = new HashSet<Vertex>();
        HashSet<Vertex> path = new HashSet<Vertex>();
        for (Vertex vertex : this.vertices.values()) {
            if (!this.hasCycle(vertex, visited, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCycle(Vertex current, Set<Vertex> visited, Set<Vertex> path) {
        if (path.contains(current)) {
            return true;
        }
        if (visited.contains(current)) {
            return false;
        }
        visited.add(current);
        path.add(current);
        for (Edge edge : current.outgoingEdges) {
            Vertex target = edge.target;
            if (!this.hasCycle(target, visited, path)) continue;
            return true;
        }
        path.remove(current);
        return false;
    }

    public static class Edge
    implements Element {
        protected FunctionalChainInvolvementLink link;
        protected Vertex source;
        protected Vertex target;

        public FunctionalChainInvolvementLink getLink() {
            return this.link;
        }

        public Vertex getSource() {
            return this.source;
        }

        public Vertex getTarget() {
            return this.target;
        }

        public Edge(FunctionalChainInvolvementLink link, Vertex source, Vertex target) {
            this.link = link;
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return "Edge [link=" + String.valueOf(this.link) + ", source=" + String.valueOf(this.source) + ", target=" + String.valueOf(this.target) + "]";
        }
    }

    public static interface Element {
    }

    public static class Vertex
    extends VertexKey
    implements Element {
        protected List<Edge> outgoingEdges = new ArrayList<Edge>();
        protected List<Edge> incomingEdges = new ArrayList<Edge>();

        public Vertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
            super(function, referenceHierarchy);
        }

        public List<Edge> getOutgoingEdges() {
            return this.outgoingEdges;
        }

        public List<Edge> getIncomingEdges() {
            return this.incomingEdges;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.outgoingEdges);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return Objects.equals(this.outgoingEdges, other.outgoingEdges);
        }

        @Override
        public String toString() {
            return "Vertex [function=" + String.valueOf(this.function) + ", referenceHierarchy=" + String.valueOf(this.referenceHierarchy) + "]";
        }
    }

    public static class VertexKey {
        protected FunctionalChainInvolvementFunction function;
        protected List<FunctionalChainReference> referenceHierarchy;

        public VertexKey(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
            this.function = function;
            this.referenceHierarchy = referenceHierarchy;
        }

        public FunctionalChainInvolvementFunction getFunction() {
            return this.function;
        }

        public int hashCode() {
            return Objects.hash(this.function, this.referenceHierarchy);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VertexKey)) {
                return false;
            }
            VertexKey other = (VertexKey)obj;
            return Objects.equals(this.function, other.function) && Objects.equals(this.referenceHierarchy, other.referenceHierarchy);
        }

        public String toString() {
            return "VertexKey [function=" + String.valueOf(this.function) + ", referenceHierarchy=" + String.valueOf(this.referenceHierarchy) + "]";
        }
    }
}

