/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.StateExt;
import org.polarsys.capella.core.model.helpers.StateMachineExt;
import org.polarsys.capella.core.model.helpers.move.IMoveHelper;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.kitalpha.emde.model.edit.provider.ExtensibleElementItemProvider;

public class MoveHelper
implements IMoveHelper {
    static String PLUGIN_ID = "org.polarsys.capella.core.model.helpers";
    static String EP_MOVE_HELPER_ID = "moveHelper";
    private List<IMoveHelper> moveHelpers;
    private static MoveHelper instance;

    public static MoveHelper getInstance() {
        if (instance == null) {
            instance = new MoveHelper();
        }
        return instance;
    }

    @Override
    public IStatus checkSemanticRules(List<EObject> selectedElements, EObject targetObject) {
        IStatus status = this.doCheckSemanticRules(selectedElements, targetObject);
        if (status != null && status.isOK()) {
            for (IMoveHelper helper : this.getMoveHelpers()) {
                status = helper.checkSemanticRules(selectedElements, targetObject);
                if (status == null || status.isOK()) continue;
                return status;
            }
            return Status.OK_STATUS;
        }
        return status;
    }

    protected IStatus doCheckSemanticRules(List<EObject> selectedElements, EObject targetObject) {
        boolean isOK = true;
        if (!(targetObject instanceof ModelElement)) {
            return Status.OK_STATUS;
        }
        ModelElement target = (ModelElement)targetObject;
        for (EObject selectedElement : selectedElements) {
            if (!(selectedElement instanceof ModelElement)) continue;
            ModelElement source = (ModelElement)selectedElement;
            if (source instanceof AbstractFunction) {
                if (target instanceof FunctionPkg) {
                    isOK = !(target.eContainer() instanceof BlockArchitecture) && this.areInSameLayer(source, target);
                } else if (target instanceof AbstractFunction) {
                    isOK = this.areInSameLayer(source, target);
                }
            } else if (source instanceof FunctionPkg) {
                if (target instanceof FunctionPkg) {
                    isOK = !(target.eContainer() instanceof BlockArchitecture) && this.areInSameLayer(source, target);
                } else if (target instanceof EPBSArchitecture) {
                    isOK = false;
                }
            } else if (source instanceof Component) {
                isOK = this.areInSameLayer(source, target) && ComponentExt.canMoveInto((Component)source, target);
            } else if (source instanceof Part) {
                isOK = this.areInSameLayer(source, target) && PartExt.canMoveInto((Part)source, target);
            } else if (source instanceof ComponentPkg) {
                isOK = this.areInSameLayer(source, target) && ComponentPkgExt.canMoveInto((ComponentPkg)source, target);
            } else if (source instanceof AbstractCapabilityPkg || source instanceof AbstractCapability) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
                if (source instanceof OperationalCapabilityPkg || source instanceof OperationalCapability) {
                    isOK = architecture instanceof OperationalAnalysis;
                } else if (source instanceof CapabilityPkg || source instanceof Capability) {
                    isOK = architecture instanceof SystemAnalysis;
                } else if (source instanceof CapabilityRealizationPkg || source instanceof CapabilityRealization) {
                    isOK = architecture instanceof LogicalArchitecture || architecture instanceof PhysicalArchitecture || architecture instanceof EPBSArchitecture;
                }
            } else if (source instanceof Interface && (target instanceof InterfacePkg || target instanceof Interface)) {
                isOK = this.isLegalInterfaceMode((Interface)source, (EObject)target);
            } else if (source instanceof InterfacePkg) {
                isOK = !(target instanceof EPBSArchitecture);
            } else if (source instanceof EnumerationLiteral) {
                isOK = target instanceof Enumeration;
            } else if (source instanceof State) {
                isOK = !(target instanceof Region) ? false : this.canMoveModeState((State)source, (Region)target);
            } else if (source instanceof Region) {
                if (target instanceof AbstractState) {
                    isOK = this.canMoveRegion((Region)source, (AbstractState)target);
                } else if (target instanceof StateMachine) {
                    isOK = this.canMoveRegion((Region)source, (StateMachine)target);
                }
            } else if (source instanceof LiteralBooleanValue) {
                isOK = target instanceof BooleanType;
            } else if (source instanceof FunctionalChainInvolvement) {
                isOK = false;
            } else if (source instanceof FunctionalChain) {
                isOK = ((FunctionalChain)source).getInvolvedElements().stream().noneMatch(x -> !this.areInSameLayer((ModelElement)x, target));
            } else if (source instanceof FunctionPort && target instanceof AbstractFunction && FunctionExt.isFlowPortInAnyFunctionalExchange((FunctionPort)((FunctionPort)source), (AbstractFunction)((AbstractFunction)target))) {
                isOK = false;
            }
            if (isOK) continue;
            return new Status(4, "model.helpers", "Semantic rules failed.");
        }
        return Status.OK_STATUS;
    }

    protected boolean isLegalInterfaceMode(Interface interf, EObject targetElement) {
        BlockArchitecture cArchi;
        BlockArchitecture iArchi = BlockArchitectureExt.getRootBlockArchitecture(targetElement);
        for (Component component : interf.getUserComponents()) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : interf.getImplementorComponents()) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : InterfaceExt.getRequireComponent(interf)) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : InterfaceExt.getProviderComponent(interf)) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        ArrayList traces = new ArrayList();
        traces.addAll(interf.getIncomingTraces());
        traces.addAll(interf.getOutgoingTraces());
        for (AbstractTrace abstractTrace : traces) {
            if (!(abstractTrace instanceof InterfaceAllocation)) continue;
            return false;
        }
        return true;
    }

    protected boolean areInSameLayer(ModelElement element1, ModelElement element2) {
        EPackage pkg;
        BlockArchitecture arch2;
        BlockArchitecture arch1 = BlockArchitectureExt.getRootBlockArchitecture((EObject)element1);
        if (arch1 == (arch2 = BlockArchitectureExt.getRootBlockArchitecture((EObject)element2))) {
            return true;
        }
        return arch1 == null && ((pkg = element1.eClass().getEPackage()).equals(OaPackage.eINSTANCE) && arch2 instanceof OperationalAnalysis || pkg.equals(CtxPackage.eINSTANCE) && arch2 instanceof SystemAnalysis || pkg.equals(LaPackage.eINSTANCE) && arch2 instanceof LogicalArchitecture || pkg.equals(PaPackage.eINSTANCE) && arch2 instanceof PhysicalArchitecture || pkg.equals(EpbsPackage.eINSTANCE) && arch2 instanceof EPBSArchitecture);
    }

    @Override
    public IStatus checkEMFRules(List<EObject> selectedModelElements, EObject targetElement) {
        IStatus status = this.doCheckEMFRules(selectedModelElements, targetElement);
        if (status != null && status.isOK()) {
            for (IMoveHelper helper : this.getMoveHelpers()) {
                status = helper.checkEMFRules(selectedModelElements, targetElement);
                if (status == null || status.isOK()) continue;
                return status;
            }
            return Status.OK_STATUS;
        }
        return status;
    }

    protected IStatus doCheckEMFRules(List<EObject> selectedModelElements, EObject targetElement) {
        Collection<? extends EStructuralFeature> childFeatures;
        IStatus result = Status.OK_STATUS;
        TransactionalEditingDomain targetDomain = TransactionUtil.getEditingDomain((EObject)targetElement);
        if (targetDomain == null) {
            result = Status.CANCEL_STATUS;
        } else {
            for (EObject e : selectedModelElements) {
                TransactionalEditingDomain sourceDomain = TransactionUtil.getEditingDomain((EObject)e);
                if (sourceDomain == null || sourceDomain == targetDomain) continue;
                result = Status.CANCEL_STATUS;
            }
        }
        if (result.isOK() && !this.checkCompatibility(selectedModelElements, childFeatures = this.getChildrenFeatures(targetElement), targetElement)) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    private Collection<? extends EStructuralFeature> getChildrenFeatures(EObject targetElement) {
        Object childFeatures = targetElement.eClass().getEAllContainments();
        ItemProviderAdapter provider = EObjectLabelProviderHelper.getItemProvider((EObject)targetElement);
        if (provider instanceof ExtensibleElementItemProvider) {
            childFeatures = ((ExtensibleElementItemProvider)provider).getChildrenFeatures((Object)targetElement);
        }
        return childFeatures;
    }

    protected boolean checkCompatibility(List<EObject> modelElements, Collection<? extends EStructuralFeature> childrenFeatures, EObject target) {
        boolean areCompatible = true;
        Iterator<EObject> elementsIterator = modelElements.iterator();
        while (elementsIterator.hasNext() && areCompatible) {
            EObject modelElement = elementsIterator.next();
            boolean isElementCompatible = false;
            Iterator<? extends EStructuralFeature> it = childrenFeatures.iterator();
            while (it.hasNext() && !isElementCompatible) {
                EList contList;
                EStructuralFeature childrenFeature = it.next();
                if (childrenFeature.getEType() == null || !childrenFeature.getEType().isInstance((Object)modelElement) || childrenFeature == modelElement) continue;
                Integer upperBound = childrenFeature.getUpperBound();
                if (upperBound == -1 || upperBound == 1 && target.eGet(childrenFeature) == null && modelElements.size() <= upperBound) {
                    isElementCompatible = true;
                    continue;
                }
                if (upperBound <= 1 || (contList = (EList)target.eGet(childrenFeature)).size() >= upperBound) continue;
                isElementCompatible = true;
            }
            areCompatible &= isElementCompatible;
        }
        return areCompatible;
    }

    public boolean canMoveRegion(Region sourceRegion, StateMachine stateMachine) {
        if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
            List<State> regionStates = MoveHelper.getAllModeState(sourceRegion);
            EList machineRegions = stateMachine.getOwnedRegions();
            for (Region machineRegion : machineRegions) {
                if (this.canMoveStatesInRegion(regionStates, machineRegion)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canMoveRegion(Region sourceRegion, AbstractState targetState) {
        if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
            List<State> sourceRegionStates = MoveHelper.getAllModeState(sourceRegion);
            return this.canMoveStatesInState(sourceRegionStates, targetState);
        }
        return true;
    }

    public boolean canMoveRegion(Region sourceRegion, Region targetRegion) {
        if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
            List<State> sourceRegionStates = MoveHelper.getAllModeState(sourceRegion);
            return this.canMoveStatesInRegion(sourceRegionStates, targetRegion);
        }
        return true;
    }

    private boolean canMoveStatesInState(List<State> states, AbstractState state) {
        Region rootRegion = StateMachineExt.getRootRegion((EObject)state);
        return this.canMoveStatesInRegion(states, rootRegion);
    }

    private boolean canMoveStatesInRegion(List<State> states, Region region) {
        for (State state : states) {
            if (this.canMoveModeState(state, region)) continue;
            return false;
        }
        return true;
    }

    public boolean canMoveModeState(State source, Region targetElement) {
        boolean result = true;
        if (targetElement.eContainer() != null && !(source instanceof FinalState)) {
            EObject targetContainer = targetElement.eContainer();
            if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
                boolean isSameType = true;
                if (targetContainer instanceof State) {
                    isSameType = targetContainer.eClass() == source.eClass();
                } else if (targetContainer instanceof StateMachine) {
                    List<State> states = MoveHelper.getAllModeState((Region)((StateMachine)targetContainer).getOwnedRegions().get(0));
                    boolean bl = !states.isEmpty() ? states.get(0).eClass() == source.eClass() : (isSameType = true);
                }
                return isSameType && !MoveHelper.isDownwardModeStateHierarchyMixed(source) && !MoveHelper.isModeStateHierarchyMixed(targetContainer);
            }
        }
        return result;
    }

    public static boolean isModeStateHierarchyMixed(EObject container) {
        List<State> stateModeLst = MoveHelper.getModeStateHierarchy(container);
        if (stateModeLst.size() <= 1) {
            return false;
        }
        int i = 0;
        while (i < stateModeLst.size() - 1) {
            if (stateModeLst.get(i).eClass() != stateModeLst.get(i + 1).eClass()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDownwardModeStateHierarchyMixed(State inputState) {
        List<State> stateModeLst = MoveHelper.getDownwardModeStateHierarchy(inputState);
        for (State state : stateModeLst) {
            if (state.eClass() == inputState.eClass()) continue;
            return true;
        }
        return false;
    }

    public static List<State> getModeStateHierarchy(EObject container) {
        ArrayList<State> stateModeLst;
        block4: {
            block3: {
                stateModeLst = new ArrayList<State>();
                if (!(container instanceof State)) break block3;
                TreeIterator iter = EcoreUtil.getAllContents((EObject)container, (boolean)true);
                while (iter.hasNext()) {
                    EObject eObj = (EObject)iter.next();
                    if (!StateExt.isStrictModeState(eObj)) continue;
                    stateModeLst.add((State)eObj);
                }
                stateModeLst.add((State)container);
                EObject parentState = EcoreUtil2.getFirstContainer((EObject)container, (EClass)CapellacommonPackage.eINSTANCE.getState());
                while (parentState != null) {
                    stateModeLst.add((State)parentState);
                    parentState = EcoreUtil2.getFirstContainer((EObject)parentState, (EClass)CapellacommonPackage.eINSTANCE.getState());
                }
                break block4;
            }
            if (!(container instanceof StateMachine)) break block4;
            TreeIterator iter = EcoreUtil.getAllContents((EObject)container, (boolean)true);
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                if (!StateExt.isStrictModeState(eObj)) continue;
                stateModeLst.add((State)eObj);
            }
        }
        return stateModeLst;
    }

    public static List<State> getDownwardModeStateHierarchy(State state) {
        ArrayList<State> stateModeLst = new ArrayList<State>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)state, (boolean)true);
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!StateExt.isStrictModeState(eObj)) continue;
            stateModeLst.add((State)eObj);
        }
        stateModeLst.add(state);
        return stateModeLst;
    }

    public static List<State> getAllModeState(Region region) {
        ArrayList<State> stateModeLst = new ArrayList<State>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)region, (boolean)true);
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!StateExt.isStrictModeState(eObj)) continue;
            stateModeLst.add((State)eObj);
        }
        return stateModeLst;
    }

    protected Collection<IMoveHelper> getMoveHelpers() {
        if (this.moveHelpers == null) {
            this.moveHelpers = new ArrayList<IMoveHelper>();
            IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)PLUGIN_ID, (String)EP_MOVE_HELPER_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IMoveHelper helper = (IMoveHelper)element.createExecutableExtension("class");
                    if (helper != null) {
                        this.moveHelpers.add(helper);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger((String)"Model Management").error((Object)exception.getMessage(), (Throwable)exception);
                }
                ++n2;
            }
        }
        return this.moveHelpers;
    }
}

