/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.IRuleTransformation;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;
import org.polarsys.capella.core.tiger.impl.TransfoRule;

public abstract class CommonRule
extends TransfoRule
implements IRuleTransformation {
    protected ITransfo _transfo;

    protected ITransfo getTransfo() {
        return this._transfo;
    }

    public CommonRule(EClass sourceType_p, EClass targetType_p) {
        super(sourceType_p, targetType_p);
        this._updatedAttributes.remove(ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName());
        this._updatedAttributes.remove(CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION.getName());
        this._updatedAttributes.remove(CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY.getName());
    }

    public CommonRule(EClass sourceType_p, EClass targetType_p, EClass _eSpecificLinkKind_p) {
        super(sourceType_p, targetType_p, _eSpecificLinkKind_p);
        this._updatedAttributes.remove(ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName());
        this._updatedAttributes.remove(CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION.getName());
        this._updatedAttributes.remove(CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY.getName());
    }

    public void update_(EObject element_p, ITransfo transfo_p) {
        for (EObject target : Query.retrieveTransformedElements((EObject)element_p, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            TigerRelationshipHelper.updateElementByAttributeIfEmpty((EObject)element_p, (EObject)target, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (ITransfo)transfo_p);
            TigerRelationshipHelper.updateElementByAttributeIfEmpty((EObject)element_p, (EObject)target, (EAttribute)CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION, (ITransfo)transfo_p);
            TigerRelationshipHelper.updateElementByAttributeIfEmpty((EObject)element_p, (EObject)target, (EAttribute)CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY, (ITransfo)transfo_p);
        }
        TigerRelationshipHelper.updateElementByProperty((EObject)element_p, (List)this._updatedAttributes, (ITransfo)transfo_p);
    }

    public String getDescription() {
        return super.getDescription() + __br + " - Required parameter: transfoSource" + __br + " - The target " + this.getTargetType().getName() + " is named with the source name";
    }

    public List<EObject> retrieveRelatedElements_(EObject element_p, ITransfo transfo_p) {
        this._transfo = transfo_p;
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        this.doAddContainer(element_p, result);
        this.doGoDeep(element_p, result);
        ArrayList<EObject> affectedMessages = new ArrayList<EObject>();
        affectedMessages.add(element_p);
        affectedMessages.addAll(result);
        this.notifyMessage(NLS.bind((String)ProjectionMessages.RetrieveElement, (Object)EObjectLabelProviderHelper.getText((Object)element_p), (Object)EObjectLabelProviderHelper.getText(result)), affectedMessages, "DEBUG", transfo_p);
        if (result.contains(null)) {
            this.notifyMessage(NLS.bind((String)ProjectionMessages.RetrieveElementNullElement, (Object)EObjectLabelProviderHelper.getText((Object)element_p)), affectedMessages, "DEBUG", transfo_p);
            while (result.contains(null)) {
                result.remove(null);
            }
        }
        return result;
    }

    public final void attach_(EObject element_p, ITransfo transfo_p) throws TransfoException {
        if (Query.isElementTransformed((EObject)element_p, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            if (this.isFirstAttach(element_p, transfo_p)) {
                String tfm;
                this.runSubTransition(element_p, transfo_p);
                this.firstAttach(element_p, transfo_p);
                List newRoot = Query.retrieveTransformedElements((EObject)element_p, (ITransfo)transfo_p);
                if (newRoot.size() == 0 && (tfm = this.getTransformFailedMessage(element_p, transfo_p)) != null) {
                    this.notifyMessage(tfm, element_p, "WARN", transfo_p);
                }
            } else if (this.reAttachIsNeeded(element_p, transfo_p)) {
                this.runSubTransition(element_p, transfo_p);
                this.reAttach(element_p, transfo_p);
                for (EObject newRootObject : Query.retrieveTransformedElements((EObject)element_p, (ITransfo)transfo_p)) {
                    EObject previousContainer = newRootObject.eContainer();
                    if (previousContainer == newRootObject.eContainer()) continue;
                    String sourceName = EObjectLabelProviderHelper.getText((Object)newRootObject);
                    String targetName = EObjectLabelProviderHelper.getText((Object)newRootObject.eContainer());
                    this.notifyMessage(NLS.bind((String)ProjectionMessages.ElementMoved, (Object)sourceName, (Object)targetName), new Object[]{newRootObject, newRootObject.eContainer()}, "INFO", transfo_p);
                }
            }
        }
    }

    protected void runSubTransition(EObject element_p, ITransfo transfo_p) {
    }

    protected void runSubTransitionBeforeTransform(EObject element_p, ITransfo transfo_p) {
    }

    protected boolean isFirstAttach(EObject sourceElement_p, ITransfo transfo_p) {
        Object targetElement = Query.retrieveTransformedElement((EObject)sourceElement_p, (ITransfo)transfo_p, (EClass)this.getTargetType());
        if (targetElement instanceof EObject) {
            return ((EObject)targetElement).eContainer() == null;
        }
        return true;
    }

    protected boolean reAttachIsNeeded(EObject sourceElement_p, ITransfo transfo_p) {
        return true;
    }

    protected abstract void firstAttach(EObject var1, ITransfo var2) throws TransfoException;

    protected void reAttach(EObject sourceElement_p, ITransfo transfo_p) {
    }

    public final Object transform_(EObject element_p, ITransfo transfo_p) {
        this.runSubTransitionBeforeTransform(element_p, transfo_p);
        if (this.transformIsRequired(element_p, transfo_p)) {
            Object result = this.retrieveTransformedElements(element_p, transfo_p);
            if (result instanceof EObject) {
                EObject transformed = (EObject)result;
                String sourceText = EObjectLabelProviderHelper.getText((Object)element_p);
                String targetText = EObjectLabelProviderHelper.getText((Object)transformed);
                String targetName = CapellaElementExt.getName((EObject)transformed);
                String sourceEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)element_p, (boolean)true);
                String targetEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)transformed, (boolean)true);
                if ((targetName == null || targetName.length() == 0) && result instanceof AbstractNamedElement) {
                    targetText = sourceText;
                }
                this.notifyMessage(NLS.bind((String)ProjectionMessages.ElementTransitioned, (Object[])new Object[]{sourceText, sourceEClassName, targetText, targetEClassName}), new Object[]{element_p, transformed}, "INFO", transfo_p);
            } else if (result instanceof List) {
                for (Object res : (List)result) {
                    if (!(res instanceof EObject)) continue;
                    EObject transformed = (EObject)res;
                    String sourceText = EObjectLabelProviderHelper.getText((Object)element_p);
                    String targetText = EObjectLabelProviderHelper.getText((Object)transformed);
                    String targetName = CapellaElementExt.getName((EObject)transformed);
                    String sourceEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)element_p, (boolean)true);
                    String targetEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)transformed, (boolean)true);
                    if ((targetName == null || targetName.length() == 0) && result instanceof AbstractNamedElement) {
                        targetText = sourceText;
                    }
                    this.notifyMessage(NLS.bind((String)ProjectionMessages.ElementTransitioned, (Object[])new Object[]{sourceText, sourceEClassName, targetText, targetEClassName}), new Object[]{element_p, transformed}, "INFO", transfo_p);
                }
            }
            return result;
        }
        String tfm = this.getTransformFailedMessage(element_p, transfo_p);
        if (tfm != null) {
            this.notifyMessage(tfm, element_p, "WARN", transfo_p);
        }
        return null;
    }

    @Override
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        if (this.transformIsRequired(element_p, context_p.getTransfo())) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected boolean transformIsRequired(EObject element_p, ITransfo transfo_p) {
        return true;
    }

    protected String reasonTransformFailed(EObject element_p, ITransfo transfo_p) {
        return "";
    }

    protected Object retrieveTransformedElements(EObject element_p, ITransfo transfo_p) {
        return this.transformElement(element_p, transfo_p);
    }

    protected Object transformElement(EObject element_p, ITransfo transfo_p) {
        EPackage pkg = (EPackage)this.getTargetType().eContainer();
        return pkg.getEFactoryInstance().create(this.getTargetType());
    }

    protected void doGoDeep(EObject element_p, List<EObject> result) {
    }

    protected void doAddContainer(EObject element_p, List<EObject> result_p) {
        if (!Query.isElementTransformed((EObject)element_p, (ITransfo)this._transfo)) {
            result_p.add(element_p.eContainer());
        }
    }

    protected boolean isOrWillBeTransformed(EObject element_p, ITransfo transfo_p) {
        IContext context = IContext.getContext(transfo_p);
        return TransformationHandlerHelper.getInstance(context).isOrWillBeTransformed(element_p, context).isOK();
    }

    protected boolean isOrWillBeTranformedTo(EObject element_p, ITransfo transfo_p, EClass target) {
        IContext context = IContext.getContext(transfo_p);
        return TransformationHandlerHelper.getInstance(context).isOrWillBeTransformedTo(element_p, context, target).isOK();
    }

    @Deprecated
    protected void notifyMessage(String message, Object affectedObject, String priority, ITransfo transfo_p) {
        if (this._logger.isEnabledFor((Priority)Level.toLevel((String)priority))) {
            EmbeddedMessage mess = new EmbeddedMessage(message, this._logger.getName(), affectedObject);
            mess.setSource(this.getClass().getSimpleName());
            this._logger.log((Priority)Level.toLevel((String)priority), (Object)mess);
        }
    }

    protected String getTransformFailedMessage(EObject element, ITransfo transfo) {
        String reason = this.reasonTransformFailed(element, transfo);
        String sourceEClassName = element != null ? element.eClass().getName() : "";
        return NLS.bind((String)ProjectionMessages.ElementNotTransitioned, (Object)EObjectLabelProviderHelper.getText((Object)element), (Object)sourceEClassName) + (reason == null || reason.length() == 0 ? "" : reason);
    }
}

