/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.OperationalAnalysisRealization;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class LayersCreation {
    public static List<LogicalArchitecture> getOrCreateLaLayers(SystemAnalysis ctx) {
        ArrayList<LogicalArchitecture> lst = new ArrayList<LogicalArchitecture>();
        for (AbstractTrace trace : ctx.getIncomingTraces()) {
            if (!(trace instanceof SystemAnalysisRealization) || !(trace.getSourceElement() instanceof LogicalArchitecture)) continue;
            lst.add((LogicalArchitecture)trace.getSourceElement());
        }
        if (lst.isEmpty()) {
            LogicalArchitecture la = LaFactory.eINSTANCE.createLogicalArchitecture("Logical Architecture");
            SystemEngineering se = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)ctx);
            se.getOwnedArchitectures().add((Object)la);
            SystemAnalysisRealization realisationLink = LaFactory.eINSTANCE.createSystemAnalysisRealization();
            realisationLink.setTargetElement((TraceableElement)ctx);
            realisationLink.setSourceElement((TraceableElement)la);
            la.getOwnedSystemAnalysisRealizations().add((Object)realisationLink);
            lst.add(la);
        }
        return lst;
    }

    public static List<SystemAnalysis> getOrCreateSaLayers(OperationalAnalysis oa) {
        ArrayList<SystemAnalysis> lst = new ArrayList<SystemAnalysis>();
        for (AbstractTrace trace : oa.getIncomingTraces()) {
            if (!(trace instanceof OperationalAnalysisRealization) || !(trace.getSourceElement() instanceof SystemAnalysis)) continue;
            lst.add((SystemAnalysis)trace.getSourceElement());
        }
        if (lst.isEmpty()) {
            SystemAnalysis sa = CtxFactory.eINSTANCE.createSystemAnalysis("System Analysis");
            SystemEngineering se = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)oa);
            se.getOwnedArchitectures().add((Object)sa);
            OperationalAnalysisRealization realisationLink = CtxFactory.eINSTANCE.createOperationalAnalysisRealization();
            realisationLink.setTargetElement((TraceableElement)oa);
            realisationLink.setSourceElement((TraceableElement)se);
            sa.getOwnedOperationalAnalysisRealizations().add((Object)realisationLink);
            lst.add(sa);
        }
        return lst;
    }

    public static List<PhysicalArchitecture> getOrCreatePaLayers(LogicalArchitecture la) {
        ArrayList<PhysicalArchitecture> lst = new ArrayList<PhysicalArchitecture>();
        for (AbstractTrace trace : la.getIncomingTraces()) {
            if (!(trace instanceof LogicalArchitectureRealization) || !(trace.getSourceElement() instanceof PhysicalArchitecture)) continue;
            lst.add((PhysicalArchitecture)trace.getSourceElement());
        }
        if (lst.isEmpty()) {
            PhysicalArchitecture pa = PaFactory.eINSTANCE.createPhysicalArchitecture("Physical Architecture");
            SystemEngineering se = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)la);
            se.getOwnedArchitectures().add((Object)pa);
            LogicalArchitectureRealization realisationLink = PaFactory.eINSTANCE.createLogicalArchitectureRealization();
            realisationLink.setTargetElement((TraceableElement)la);
            realisationLink.setSourceElement((TraceableElement)pa);
            pa.getOwnedLogicalArchitectureRealizations().add((Object)realisationLink);
            lst.add(pa);
        }
        return lst;
    }

    public static List<EPBSArchitecture> getOrCreateEpbsLayers(PhysicalArchitecture pa) {
        ArrayList<EPBSArchitecture> lst = new ArrayList<EPBSArchitecture>();
        for (AbstractTrace trace : pa.getIncomingTraces()) {
            if (!(trace instanceof PhysicalArchitectureRealization) || !(trace.getSourceElement() instanceof EPBSArchitecture)) continue;
            lst.add((EPBSArchitecture)trace.getSourceElement());
        }
        if (lst.isEmpty()) {
            EPBSArchitecture epbs = EpbsFactory.eINSTANCE.createEPBSArchitecture("Epbs Architecture");
            SystemEngineering se = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)pa);
            se.getOwnedArchitectures().add((Object)epbs);
            PhysicalArchitectureRealization realisationLink = EpbsFactory.eINSTANCE.createPhysicalArchitectureRealization();
            realisationLink.setTargetElement((TraceableElement)pa);
            realisationLink.setSourceElement((TraceableElement)epbs);
            epbs.getOwnedPhysicalArchitectureRealizations().add((Object)realisationLink);
            lst.add(epbs);
        }
        return lst;
    }
}

