/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.traceability.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.handlers.traceability.LibraryTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeTargetConfiguration
extends ExtendedTraceabilityConfiguration {
    protected String getExtensionIdentifier(IContext context) {
        return "targetTraceabilityConfiguration";
    }

    public EObject getTargetEngineering(IContext context) {
        return ContextHelper.getSourceEngineering((IContext)context);
    }

    protected void initHandlers(IContext context) {
        this.addHandler(context, (ITraceabilityHandler)new TopDownReconciliationTraceabilityHandler(this.getIdentifier(context)));
        this.addHandler(context, (ITraceabilityHandler)new TopDownRealizationTraceabilityHandler(this.getIdentifier(context)));
        this.addHandler(context, (ITraceabilityHandler)new LibraryTraceabilityHandler());
    }

    public Collection<EObject> retrieveTracedElementsByRealization(EObject object, IContext context) {
        ITraceabilityHandler handler = this.getDefinedHandler(context, RealizationLinkTraceabilityHandler.class);
        if (handler != null) {
            return handler.retrieveTracedElements(object, context);
        }
        return Collections.emptyList();
    }

    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForTracedElements(source, handler, context);
        if (result && handler instanceof RealizationLinkTraceabilityHandler) {
            boolean bl = result = !(source instanceof Project) && !(source instanceof SystemEngineering) && !(source instanceof BlockArchitecture);
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForSourceElements(source, handler, context);
        if (result) {
            if (handler instanceof RealizationLinkTraceabilityHandler) {
                boolean bl = result = !(source instanceof Project) && !(source instanceof SystemEngineering) && !(source instanceof BlockArchitecture);
            }
            if (handler instanceof ReconciliationTraceabilityHandler) {
                boolean bl = result = !(source instanceof StateMachine) && !(source instanceof Region);
            }
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    public boolean useHandlerForAttachment(EObject source, EObject target, ITraceabilityHandler handler, IContext context) {
        if (handler instanceof ReconciliationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForAttachment(source, target, handler, context);
    }

    public BlockArchitecture getTargetArchitecture(EObject target, IContext context) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (!selection.isEmpty()) {
            EObject source = (EObject)selection.toArray()[0];
            architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        }
        EClass clazz = TransformationHandlerHelper.getInstance((IContext)context).getTargetType((EObject)architecture, context);
        for (BlockArchitecture archi : architecture.getAllocatingArchitectures()) {
            if (!clazz.isInstance((Object)archi)) continue;
            return archi;
        }
        return architecture;
    }

    protected class TopDownRealizationTraceabilityHandler
    extends RealizationLinkTraceabilityHandler {
        public TopDownRealizationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected boolean initTraceabilityMapping(EObject source, EObject object, IContext context) {
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
            return architecture == null || MergeTargetConfiguration.this.getTargetArchitecture(source, context) == architecture;
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            this.initializeMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTargetProject((IContext)context), context);
        }
    }

    protected class TopDownReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public TopDownReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeDataPkg(DataPkg source, DataPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            if (source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)source, (EObject)target, context);
            }
        }

        protected void initializeComponent(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeComponent(source, target, context, map);
            if (source != null && target != null && !source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getDataPkg((Component)source, (boolean)false), (EObject)ComponentExt.getDataPkg((Component)target, (boolean)false), context);
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getInterfacePkg((Component)source, (boolean)false), (EObject)ComponentExt.getInterfacePkg((Component)target, (boolean)false), context);
            }
            this.addInterfaceUseReconciliation(source, target, context, map);
            this.addInterfaceImplementationReconciliation(source, target, context, map);
            this.addCommunicationLinkReconciliation(source, target, context, map);
        }

        protected void addCommunicationLinkReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            ArrayList<CommunicationLink> unmatchedLinks = new ArrayList<CommunicationLink>(1);
            for (CommunicationLink sLink : source.getOwnedCommunicationLinks()) {
                boolean match = false;
                if (sLink.getExchangeItem() == null || !MergeTargetConfiguration.this.retrieveTracedElementsByRealization((EObject)sLink, context).isEmpty()) continue;
                for (CommunicationLink tLink : target.getOwnedCommunicationLinks()) {
                    if (tLink.getExchangeItem() == null || !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink, context).isEmpty() || !sLink.getExchangeItem().equals(tLink.getExchangeItem()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getExchangeItem(), context).contains(sLink.getExchangeItem()) || tLink.getKind() != sLink.getKind()) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    match = true;
                    break;
                }
                if (match) continue;
                unmatchedLinks.add(sLink);
            }
            block2: for (CommunicationLink sLink : unmatchedLinks) {
                if (sLink.getExchangeItem() == null) continue;
                for (CommunicationLink tLink : target.getOwnedCommunicationLinks()) {
                    if (tLink.getExchangeItem() == null || !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink, context).isEmpty() || !sLink.getExchangeItem().equals(tLink.getExchangeItem()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getExchangeItem(), context).contains(sLink.getExchangeItem())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block2;
                }
            }
        }

        protected void addInterfaceUseReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            block0: for (InterfaceUse sLink : source.getUsedInterfaceLinks()) {
                if (sLink.getUsedInterface() == null) continue;
                for (InterfaceUse tLink : target.getUsedInterfaceLinks()) {
                    if (tLink.getUsedInterface() == null || !sLink.getUsedInterface().equals(tLink.getUsedInterface()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getUsedInterface(), context).contains(sLink.getUsedInterface())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block0;
                }
            }
        }

        protected void addInterfaceImplementationReconciliation(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            block0: for (InterfaceImplementation sLink : source.getImplementedInterfaceLinks()) {
                if (sLink.getImplementedInterface() == null) continue;
                for (InterfaceImplementation tLink : target.getImplementedInterfaceLinks()) {
                    if (tLink.getImplementedInterface() == null || !sLink.getImplementedInterface().equals(tLink.getImplementedInterface()) && !TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements((EObject)tLink.getImplementedInterface(), context).contains(sLink.getImplementedInterface())) continue;
                    this.addMapping((MappingTraceability)map, (EObject)sLink, (EObject)tLink, context);
                    continue block0;
                }
            }
        }

        protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)target, (boolean)false), context);
            if (!(target instanceof PhysicalArchitecture) || source instanceof PhysicalArchitecture) {
                this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)target, (boolean)false), context);
            }
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)source.getSystem(), (EObject)target.getSystem(), context);
        }

        protected void initializeMappings(EObject source, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeMappings(source, context, map);
            if (source instanceof ComponentFunctionalAllocation) {
                this.addComponentFunctionalReconciliation((ComponentFunctionalAllocation)source, context, map);
            }
        }

        protected void addComponentFunctionalReconciliation(ComponentFunctionalAllocation source, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            AbstractFunction function = source.getFunction();
            if (function != null) {
                EList allocations;
                EObject sFunction;
                Collection sFunctions;
                ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context);
                Collection collection = sFunctions = this.isBackward(map.key) ? handler.retrieveSourceElements((EObject)function, context) : handler.retrieveTracedElements((EObject)function, context);
                if (sFunctions.size() == 1 && (sFunction = (EObject)sFunctions.iterator().next()) instanceof AbstractFunction && (allocations = ((AbstractFunction)sFunction).getComponentFunctionalAllocations()).size() == 1) {
                    this.addMapping((MappingTraceability)map, (EObject)allocations.get(0), (EObject)source, context);
                }
            }
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            this.addMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTargetProject((IContext)context), context);
            this.addMappings((EObject)ContextHelper.getSourceEngineering((IContext)context), MergeTargetConfiguration.this.getTargetEngineering(context), context);
        }
    }
}

