/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.rules.cs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.options.IOptionsHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.EClassSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.constants.ITopDownConstants;
import org.polarsys.capella.core.transition.system.topdown.handlers.transformation.TopDownTransformationHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentRule
extends org.polarsys.capella.core.transition.system.rules.cs.ComponentRule {
    protected void retrieveComponentAllocations(EObject source_p, List<EObject> result_p, IContext context_p) {
        if (!(source_p instanceof SystemComponent) || !BlockArchitectureExt.isRootComponent((Component)((SystemComponent)source_p))) {
            super.retrieveComponentAllocations(source_p, result_p, context_p);
        } else {
            String transitionKind = (String)context_p.get((Object)"TRANSITION_KIND");
            boolean transition = "capella.core.transition.system.topdown.system".equals(transitionKind);
            if (transition) {
                super.retrieveComponentAllocations(source_p, result_p, context_p);
            }
        }
    }

    protected void retrieveRepresentingPartitions(EObject source_p, List<EObject> result_p, IContext context_p) {
        Component element = (Component)source_p;
        for (Part partition : element.getRepresentingParts()) {
            if (CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)partition))) {
                result_p.add((EObject)partition);
                continue;
            }
            if (!(partition instanceof Part) || partition.getType() == null) continue;
            if (partition.eContainer() != null && ComponentPkgExt.isRootComponentPkg((EObject)partition.eContainer())) {
                result_p.add((EObject)partition);
            }
            if (!(partition.getType() instanceof Component) || ((Component)partition.getType()).getRepresentingParts().size() != 1) continue;
            result_p.add((EObject)partition);
        }
    }

    protected void retrieveComponentGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveComponentGoDeep(source_p, result_p, context_p);
        Component element = (Component)source_p;
        IContextScopeHandler handler = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        this.retrieveRepresentingPartitions(source_p, result_p, context_p);
        IOptionsHandler options = OptionsHandlerHelper.getInstance((IContext)context_p);
        boolean transitionStateMachine = options.getBooleanValue(context_p, "capella.core.transition.system.topdown", "projection.component.stateMachine", ITopDownConstants.OPTIONS_TRANSITION__STATE_MACHINE_DEFAULT.booleanValue());
        boolean transitionInterface = options.getBooleanValue(context_p, "capella.core.transition.system.topdown", "interface.mode", ITopDownConstants.OPTIONS_TRANSITION__INTERFACE_DEFAULT.booleanValue());
        boolean transitionData = options.getBooleanValue(context_p, "capella.core.transition.system.topdown", "projection.dataType", ITopDownConstants.OPTIONS_TRANSITION__DATATYPE_DEFAULT.booleanValue());
        if (transitionStateMachine && handler.contains("SOURCE_SCOPE", (EObject)element, context_p)) {
            handler.addAll("SOURCE_SCOPE", (Collection)element.getOwnedStateMachines(), context_p);
            result_p.addAll((Collection<EObject>)element.getOwnedStateMachines());
        }
        if (handler.contains("SOURCE_SCOPE", (EObject)element, context_p)) {
            result_p.addAll((Collection<EObject>)element.getOwnedCommunicationLinks());
            handler.addAll("SOURCE_SCOPE", (Collection)element.getOwnedCommunicationLinks(), context_p);
            if (!(element instanceof Entity)) {
                result_p.addAll(ComponentExt.getSubParts((Component)element, (boolean)true));
                handler.addAll("SOURCE_SCOPE", (Collection)ComponentExt.getSubParts((Component)element, (boolean)true), context_p);
            }
            if (transitionInterface && element.getOwnedInterfacePkg() != null) {
                result_p.add((EObject)element.getOwnedInterfacePkg());
                handler.add("SOURCE_SCOPE", (EObject)element.getOwnedInterfacePkg(), context_p);
            }
            if (transitionData && element.getOwnedDataPkg() != null) {
                result_p.add((EObject)element.getOwnedDataPkg());
                handler.add("SOURCE_SCOPE", (EObject)element.getOwnedDataPkg(), context_p);
            }
        }
    }

    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject container = element_p.eContainer();
        if (container != null) {
            EObject parent = container;
            EObject targetContainer = null;
            while (parent != null && targetContainer == null) {
                ISelectionContext sContext = SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, "SC__T", element_p, result_p);
                targetContainer = TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(parent, context_p, (ISelectionContext)new EClassSelectionContext(sContext, CsPackage.Literals.COMPONENT));
                if (targetContainer == null) {
                    targetContainer = TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(parent, context_p, sContext);
                }
                parent = parent.eContainer();
            }
            if (targetContainer != null) {
                if (targetContainer.eContainer() instanceof BlockArchitecture && !this.transformAsRootComponent(element_p, context_p)) {
                    return null;
                }
                return targetContainer;
            }
        }
        return super.getBestContainer(element_p, result_p, context_p);
    }

    public IStatus transformRequired(EObject element_p, IContext context_p) {
        Collection selection = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        for (EObject source : selection) {
            if (source == element_p) {
                return Status.OK_STATUS;
            }
            if (source instanceof Component && ComponentExt.isComponentAncestor((Component)((Component)source), (Component)((Component)element_p))) {
                return Status.OK_STATUS;
            }
            if (source instanceof Structure) {
                return Status.OK_STATUS;
            }
            if (!(source instanceof ComponentExchange) && !(source instanceof PhysicalLink)) continue;
            return Status.OK_STATUS;
        }
        if (TopDownTransformationHelper.getInstance(context_p).isTracedInTarget(element_p, context_p)) {
            return Status.OK_STATUS;
        }
        if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", element_p, context_p)) {
            return Status.OK_STATUS;
        }
        return new Status(2, Messages.Activity_Transition, "Component already transitioned");
    }
}

