/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.physicalArtifact;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class PhysicalArtifactAllocated
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (eObj instanceof AbstractPhysicalArtifact && this.isInPhysicalLayer(eObj)) {
            AbstractPhysicalArtifact artifact = (AbstractPhysicalArtifact)eObj;
            List crossReferenceList = EObjectExt.getReferencers((EObject)artifact, (EClass)EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION, (EReference)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT);
            if (!crossReferenceList.isEmpty()) {
                return ctx.createSuccessStatus();
            }
            String name = null;
            Object className = "(" + artifact.eClass().getName() + ")";
            if (artifact instanceof PhysicalLink) {
                name = ((PhysicalLink)artifact).getName();
            } else if (artifact instanceof PhysicalComponent) {
                name = ((PhysicalComponent)artifact).getName();
                className = NamingHelper.getTitleLabel((EObject)artifact);
            } else if (artifact instanceof PhysicalPort) {
                name = ((PhysicalPort)artifact).getName();
            }
            return ctx.createFailureStatus(new Object[]{name, className});
        }
        return null;
    }

    private boolean isInPhysicalLayer(EObject eObj) {
        EObject container = eObj.eContainer();
        boolean hasContainer = container != null;
        boolean containerIsPhysicalComponent = container instanceof PhysicalComponent;
        return hasContainer && containerIsPhysicalComponent;
    }
}

