/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.content.provider.impl;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.common.ui.toolkit.browser.BrowserActivator;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.IBrowserContentProvider;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.PrimitiveWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.TechnicalCategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;
import org.polarsys.capella.common.ui.toolkit.browser.query.QueryAdapter;
import org.polarsys.capella.common.ui.toolkit.provider.GroupedAdapterFactoryContentProvider;

public abstract class AbstractContentProvider
extends GroupedAdapterFactoryContentProvider
implements IBrowserContentProvider {
    protected EObject rootElement;
    protected boolean inputHasChanged;
    protected HashMap<BrowserElementWrapper, BrowserElementWrapper> semanticParentHashMap;
    protected HashMap<EObject, HashMap<ICategory, Set<Object>>> categoryChildrenCache;
    protected HashMap<EObject, Set<ICategory>> directCategoriesCache;
    protected HashMap<EObject, HashMap<ICategory, Set<Object>>> itemQueriesCache;
    protected boolean isRefreshRequired = false;
    protected ISemanticBrowserModel model;

    public AbstractContentProvider(AdapterFactory adapterFactory, ISemanticBrowserModel model) {
        super(adapterFactory);
        this.model = model;
        this.semanticParentHashMap = new HashMap(0);
        this.categoryChildrenCache = new HashMap(0);
        this.directCategoriesCache = new HashMap(0);
        this.itemQueriesCache = new HashMap(0);
    }

    public void dispose() {
        this.semanticParentHashMap.clear();
        this.clearCaches();
        super.dispose();
    }

    protected void getCategoryChildren(ICategory category, BrowserElementWrapper wrapper, LinkedHashSet<Object> gatheredElements) {
        Set<Object> categoryChildren;
        EObject elementToQuery = this.lookUpModelElement(wrapper);
        HashMap<ICategory, Set<Object>> modelElementCategoryChildren = this.categoryChildrenCache.get(elementToQuery);
        if (modelElementCategoryChildren == null) {
            modelElementCategoryChildren = new HashMap();
            this.categoryChildrenCache.put(elementToQuery, modelElementCategoryChildren);
        }
        if ((categoryChildren = modelElementCategoryChildren.get(category)) == null) {
            categoryChildren = new LinkedHashSet<Object>();
            categoryChildren.addAll(category.compute(elementToQuery));
            categoryChildren.addAll(CategoryRegistry.getInstance().gatherSubCategories(this.getBrowserId(), elementToQuery, category));
            modelElementCategoryChildren.put(category, categoryChildren);
        }
        gatheredElements.addAll(categoryChildren);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        try {
            if (parentElement instanceof BrowserElementWrapper) {
                BrowserElementWrapper wrapper = (BrowserElementWrapper)parentElement;
                Object element = ((BrowserElementWrapper)parentElement).getElement();
                LinkedHashSet<Object> gatheredElements = new LinkedHashSet<Object>(0);
                if (wrapper instanceof EObjectWrapper) {
                    if (element == this.rootElement && this.inputHasChanged) {
                        this.semanticParentHashMap.put(wrapper, null);
                        this.inputHasChanged = false;
                        if (this.getBrowserId().equalsIgnoreCase("CurrentElementBrowser")) {
                            return new Object[]{wrapper};
                        }
                    }
                    this.getElementChildren((EObject)element, wrapper, gatheredElements);
                } else if (wrapper instanceof CategoryWrapper) {
                    this.getCategoryChildren((ICategory)element, wrapper, gatheredElements);
                }
                LinkedHashSet<BrowserElementWrapper> wrappers = new LinkedHashSet<BrowserElementWrapper>(0);
                for (Object e : gatheredElements) {
                    if (e == null) continue;
                    BrowserElementWrapper elementWrapper = this.wrapElement(e);
                    wrappers.add(elementWrapper);
                    this.semanticParentHashMap.put(elementWrapper, wrapper);
                    boolean shouldRemovedEmptyCategoryWrapper = false;
                    if (e instanceof ICategory) {
                        if (!this.model.doesShowCategory((ICategory)e)) {
                            shouldRemovedEmptyCategoryWrapper = true;
                        } else {
                            LinkedHashSet<Object> categoryChildren = new LinkedHashSet<Object>(0);
                            this.getCategoryChildren((ICategory)e, elementWrapper, categoryChildren);
                            if (categoryChildren.isEmpty()) {
                                shouldRemovedEmptyCategoryWrapper = true;
                            }
                        }
                    }
                    if (!shouldRemovedEmptyCategoryWrapper) continue;
                    wrappers.remove(elementWrapper);
                    this.semanticParentHashMap.remove(elementWrapper);
                }
                result = wrappers.toArray();
            } else {
                result = this.getChildren(new EObjectWrapper((EObject)parentElement));
            }
        }
        catch (Exception exception) {
            BrowserActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.ui.toolkit.browser", "Error while getting children for " + String.valueOf(parentElement), (Throwable)exception));
            result = new Object[]{};
        }
        return result;
    }

    protected void getElementChildren(EObject modelElement, BrowserElementWrapper wrapper, Set<Object> gatheredElements) {
        BrowserElementWrapper parentWrapper;
        Object semanticParent;
        BrowserElementWrapper semanticParentWrapper;
        if (modelElement != this.rootElement && (semanticParentWrapper = this.semanticParentHashMap.get(wrapper)) != null && (semanticParent = semanticParentWrapper.getElement()) instanceof ICategory) {
            Set<Object> itemQueries;
            ICategory category = (ICategory)semanticParent;
            HashMap<ICategory, Set<Object>> modelElementItemQueries = this.itemQueriesCache.get(modelElement);
            if (modelElementItemQueries == null) {
                modelElementItemQueries = new HashMap();
                this.itemQueriesCache.put(modelElement, modelElementItemQueries);
            }
            if ((itemQueries = modelElementItemQueries.get(category)) == null) {
                itemQueries = new LinkedHashSet<Object>();
                for (Object query : category.getItemQueries()) {
                    itemQueries.addAll(QueryAdapter.getInstance().compute(modelElement, query));
                }
                modelElementItemQueries.put(category, itemQueries);
            }
            gatheredElements.addAll(itemQueries);
        }
        if (this.semanticParentHashMap.get(parentWrapper = this.semanticParentHashMap.get(wrapper)) == null) {
            Set<ICategory> categories = this.directCategoriesCache.get(modelElement);
            if (categories == null) {
                categories = new LinkedHashSet<ICategory>();
                categories.addAll(CategoryRegistry.getInstance().gatherCategories(this.getBrowserId(), modelElement));
                this.directCategoriesCache.put(modelElement, categories);
            }
            gatheredElements.addAll(categories);
        }
    }

    public Object[] getElements(Object rootElement) {
        return this.getChildren(rootElement);
    }

    public Object getParent(Object element) {
        return this.semanticParentHashMap.get(element);
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer == null) {
            this.viewer = viewer;
        }
        if (newInput instanceof BrowserElementWrapper) {
            if (oldInput == null) {
                this.inputChanged(viewer, new EObjectWrapper(null), ((BrowserElementWrapper)newInput).getElement());
            } else if (oldInput instanceof BrowserElementWrapper) {
                this.inputChanged(viewer, ((BrowserElementWrapper)oldInput).getElement(), ((BrowserElementWrapper)newInput).getElement());
            } else if (oldInput instanceof EObject) {
                this.inputChanged(viewer, oldInput, ((BrowserElementWrapper)newInput).getElement());
            }
        } else if (newInput instanceof EObject) {
            this.semanticParentHashMap.clear();
            this.clearCaches();
            this.inputHasChanged = true;
            this.rootElement = (EObject)newInput;
        } else if (newInput == null) {
            this.inputHasChanged = false;
            this.rootElement = null;
            this.semanticParentHashMap.clear();
            this.clearCaches();
        }
    }

    private EObject lookUpModelElement(BrowserElementWrapper wrapper) {
        BrowserElementWrapper parentWrapper = this.semanticParentHashMap.get(wrapper);
        if (parentWrapper instanceof CategoryWrapper) {
            return this.lookUpModelElement(parentWrapper);
        }
        return (EObject)parentWrapper.getElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshRequired(ResourceSetChangeEvent event) {
        boolean result = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            if (this.isRefreshRequired) {
                result = true;
            }
        }
        return result || super.refreshRequired(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged(Notification notification) {
        if (notification instanceof IViewerNotification) {
            IViewerNotification viewerNotification = (IViewerNotification)notification;
            if (!viewerNotification.isContentRefresh()) {
                Object element = viewerNotification.getElement();
                BrowserElementWrapper wrappedElement = this.wrapElement(element);
                if (wrappedElement != null) {
                    super.notifyChanged(ViewerNotification.wrapNotification((Notification)viewerNotification, (Object)wrappedElement));
                }
            } else {
                AbstractContentProvider abstractContentProvider = this;
                synchronized (abstractContentProvider) {
                    if (!this.isRefreshRequired) {
                        this.isRefreshRequired = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRefresh() {
        boolean refresh = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            refresh = this.isRefreshRequired;
            this.isRefreshRequired = false;
            if (refresh) {
                this.notifications = null;
                this.toRefresh = null;
            }
        }
        if (!refresh) {
            super.processRefresh();
        } else if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            ViewerHelper.run((StructuredViewer)((StructuredViewer)this.viewer), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Object input = AbstractContentProvider.this.viewer.getInput();
                    AbstractContentProvider.this.viewer.setInput(input);
                }
            });
        }
    }

    private BrowserElementWrapper wrapElement(Object gatherElement) {
        BrowserElementWrapper wrapper = null;
        if (gatherElement instanceof EObject) {
            wrapper = new EObjectWrapper((EObject)gatherElement);
        } else if (gatherElement instanceof ICategory) {
            wrapper = ((ICategory)gatherElement).isTechnical() ? new TechnicalCategoryWrapper((ICategory)gatherElement) : new CategoryWrapper((ICategory)gatherElement);
        } else if (gatherElement instanceof Object) {
            wrapper = new PrimitiveWrapper(gatherElement);
        }
        return wrapper;
    }

    public EObject getRootElement() {
        return this.rootElement;
    }

    protected void clearCaches() {
        this.categoryChildrenCache.clear();
        this.directCategoriesCache.clear();
        this.itemQueriesCache.clear();
    }
}

