/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.internal;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.emf.ecore.EObject;

public class TypeHelper {
    protected static TypeHelper typeHelper = null;

    private TypeHelper() {
    }

    public static TypeHelper getInstance() {
        if (typeHelper == null) {
            typeHelper = new TypeHelper();
        }
        return typeHelper;
    }

    public boolean isInstanceOf(Object element, String type) {
        if (element == null) {
            return false;
        }
        return this.isSubtype(element.getClass(), type);
    }

    private boolean isSubtype(Class clazz, String type) {
        if (clazz.getName().equals(type)) {
            return true;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && this.isSubtype(superClass, type)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (this.isSubtype(interfaces[i], type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSubtype(String classFQN1, String classFQN2, EObject current) {
        Class<?> clazz = current.getClass();
        Map<String, Object> name2Interface = ClassUtils.getAllInterfaces(clazz).stream().collect(Collectors.toMap(i -> ((Class)i).getName(), i -> i));
        if (name2Interface.containsKey(classFQN1) && name2Interface.containsKey(classFQN2)) {
            return ((Class)name2Interface.get(classFQN2)).isAssignableFrom((Class)name2Interface.get(classFQN1));
        }
        return false;
    }
}

