/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractData {
    public static final Object[] NO_CHILD = new Object[0];
    public static final Object UNDEFINED_CONTEXT = new Object();
    private Object context;
    private Runnable notifiedForValidElementsChanges;
    Collection<Object> rootElements;
    Collection<Object> validElements;

    protected AbstractData(Collection<? extends Object> displayedElements, Object context) {
        this.context = context;
        this.rootElements = this.initializeRootElementCollection();
        this.validElements = this.initializeValidElementCollection(displayedElements);
        for (Object object : displayedElements) {
            this.addElement(object);
        }
    }

    public void addAllElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.addElement(element);
            this.addValidElement(element);
            ++n2;
        }
    }

    public void addElement(Object element) {
        this.rootElements.add(element);
    }

    protected void addValidElement(Object element) {
        this.validElements.add(element);
    }

    public void clearData() {
        this.rootElements.clear();
    }

    public abstract Object[] getChildren(Object var1);

    public Object getContext() {
        return this.context;
    }

    public Object[] getElements() {
        return this.rootElements.toArray(new Object[this.rootElements.size()]);
    }

    public Runnable getNotifiedForValidElementsChanges() {
        return this.notifiedForValidElementsChanges;
    }

    public abstract Object getParent(Object var1);

    public List<Object> getValidElements() {
        return new ArrayList<Object>(this.validElements);
    }

    protected Collection<Object> initializeRootElementCollection() {
        return new LinkedHashSet<Object>(0);
    }

    protected Collection<Object> initializeValidElementCollection(Collection<? extends Object> displayedElements) {
        return new LinkedHashSet<Object>(displayedElements);
    }

    public boolean isValid(Object elment) {
        return this.validElements.contains(elment);
    }

    protected void notifyValidElementsChanges() {
        if (this.notifiedForValidElementsChanges != null) {
            this.notifiedForValidElementsChanges.run();
        }
    }

    public void removeAllElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.removeElement(element);
            this.removeValidElement(element);
            ++n2;
        }
    }

    public void removeElement(Object element) {
        this.rootElements.remove(element);
    }

    public void removeValidElement(Object element) {
        this.validElements.remove(element);
    }

    public void setNotifiedForValidElementsChanges(Runnable notifiedForValidElementsChanges) {
        this.notifiedForValidElementsChanges = notifiedForValidElementsChanges;
    }
}

