/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.mdsofa.common.helper.MiscHelper;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.data.IMoveableData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.MultipleValidElementsListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.MultipleValidElementsTreeData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.TransferTreeListViewer;
import org.polarsys.capella.common.ui.toolkit.widgets.handler.SelectionChangedHandler;

public class OrderedTransferTreeListViewer
extends TransferTreeListViewer {
    public static final int UP_BUTTON = 1024;
    public static final int DOWN_BUTTON = 2048;
    private Button _upButton;
    private Button _downButton;

    public OrderedTransferTreeListViewer(Composite parent, int style, int leftViewerStyleBits, int rightViewerStyleBits) {
        super(parent, style, leftViewerStyleBits, rightViewerStyleBits);
    }

    @Override
    protected void createButtonArea(Composite parent) {
        super.createButtonArea(parent);
        this._upButton = this.createButton(this.getButtonsContainer(), Messages.OrderedTransferTreeListViewer_Up_Title, Messages.OrderedTransferTreeListViewer_Up_Tooltip);
        this._downButton = this.createButton(this.getButtonsContainer(), Messages.OrderedTransferTreeListViewer_Down_Title, Messages.OrderedTransferTreeListViewer_Down_Tooltip);
    }

    @Override
    protected boolean doHandleAddSelectedButton() {
        boolean changed = false;
        ISelection leftSelection = this.getLeftViewer().getSelection();
        if (!leftSelection.isEmpty()) {
            changed = true;
            IStructuredSelection structuredSelection = (IStructuredSelection)leftSelection;
            Object[] elements = structuredSelection.toArray();
            TreeViewer rightViewer = this.getRightViewer();
            if (this.shouldChangeLeftViewer()) {
                this.getLeftViewer().getContentProvider().inputChanged((Viewer)this.getLeftViewer(), (Object)elements, null);
            }
            rightViewer.getContentProvider().inputChanged((Viewer)rightViewer, null, (Object)elements);
        }
        return changed;
    }

    protected boolean shouldChangeLeftViewer() {
        return false;
    }

    protected boolean doHandleDownButton() {
        Tree tree = this.getRightViewer().getTree();
        List treeItems = MiscHelper.asList((Object[])tree.getSelection());
        Collections.reverse(treeItems);
        this.swapElements(treeItems, false);
        return true;
    }

    protected boolean doHandleUpButton() {
        Tree tree = this.getRightViewer().getTree();
        this.swapElements(MiscHelper.asList((Object[])tree.getSelection()), true);
        return true;
    }

    protected void swapElements(List<TreeItem> treeItems, boolean isMovingUp) {
        TreeViewer rightViewer = this.getRightViewer();
        Tree tree = rightViewer.getTree();
        ArrayList<TreeItem> newlySelectedElements = new ArrayList<TreeItem>(treeItems.size());
        for (TreeItem treeItem : treeItems) {
            TreeItem parentItem = treeItem.getParentItem();
            int index = parentItem != null ? parentItem.indexOf(treeItem) : tree.indexOf(treeItem);
            int newIndex = index + (isMovingUp ? -1 : 1);
            ((IMoveableData)((Object)this.getRightInput())).swap(treeItem.getData(), index, newIndex);
            TreeItem selectedItem = parentItem != null ? parentItem.getItem(newIndex) : tree.getItem(newIndex);
            newlySelectedElements.add(selectedItem);
        }
        ViewerHelper.refresh((StructuredViewer)rightViewer);
        tree.setSelection(newlySelectedElements.toArray(new TreeItem[newlySelectedElements.size()]));
        this.updateButtons(rightViewer.getSelection(), (ISelectionProvider)rightViewer);
    }

    @Override
    protected void handleButtonClicked(Widget button) {
        if (button == this._upButton) {
            this.doHandleUpButton();
        } else if (button == this._downButton) {
            this.doHandleDownButton();
        } else {
            super.handleButtonClicked(button);
        }
    }

    protected ListData createListDataWhenTreeViewModeClicked(TreeViewer viewer, List<? extends Object> displayedElements, Object context) {
        if (viewer == this.getRightViewer()) {
            return new MultipleValidElementsListData(displayedElements, context);
        }
        return super.createListDataWhenTreeViewModeClicked(viewer, displayedElements, context);
    }

    protected TreeData createTreeDataWhenTreeViewModeClicked(TreeViewer viewer, List<? extends Object> displayedElements, Object context) {
        if (viewer == this.getRightViewer()) {
            return new MultipleValidElementsTreeData(displayedElements, context);
        }
        return super.createTreeDataWhenTreeViewModeClicked(viewer, displayedElements, context);
    }

    @Override
    public void setSelectionChangedHandler(SelectionChangedHandler handler, int buttonStyleConstant) {
        super.setSelectionChangedHandler(handler, buttonStyleConstant);
        if (this._upButton != null && (0x400 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._upButton);
            this.getSelectionChangedHandlersForRightViewer().add(handler);
        }
        if (this._downButton != null && (0x800 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._downButton);
            this.getSelectionChangedHandlersForRightViewer().add(handler);
        }
    }
}

