/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;

public final class ReportManagerLogViewAppender
extends WriterAppender {
    private static final String UNKNOWN = "Unknown";
    private final IResource workspaceRoot;

    public ReportManagerLogViewAppender() {
        this.setName("Information");
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void append(LoggingEvent event) {
        Level level = event.getLevel();
        Object message = event.getMessage();
        if (message instanceof EmbeddedMessage) {
            this.report((EmbeddedMessage)message, level);
        } else if (message instanceof Diagnostic) {
            this.report((Diagnostic)message);
        } else if (message != null) {
            this.report(event.getRenderedMessage(), level);
        } else {
            ThrowableInformation information = event.getThrowableInformation();
            if (information != null) {
                Throwable thr = information.getThrowable();
                String throwableMessage = thr.getMessage();
                if (throwableMessage != null) {
                    this.report(throwableMessage, level);
                } else {
                    this.report(thr.getClass().getName(), level);
                }
            }
        }
    }

    private IResource getMarkerResource(List<?> objects) {
        if (objects != null && !objects.isEmpty()) {
            return ReportManagerLogViewAppender.getSessionResource(objects.get(0));
        }
        return this.workspaceRoot;
    }

    private void report(EmbeddedMessage message, Level level) {
        int severity = this.log4jToDiagnostics(level);
        IResource markerResource = this.getMarkerResource(message.getCapellaElements());
        LightMarkerRegistry.getInstance().createMarker(markerResource, (Diagnostic)new BasicDiagnostic(severity, message.getSource(), 0, message.getLabel(), message.getCapellaElements().toArray()));
    }

    private void report(Diagnostic message) {
        IResource markerResource = this.getMarkerResource(message.getData());
        LightMarkerRegistry.getInstance().createMarker(markerResource, message);
    }

    public static IFile getSessionResource(Object obj) {
        Session session = null;
        if (obj instanceof EObject) {
            session = SessionManager.INSTANCE.getSession((EObject)obj);
        } else if (obj instanceof Resource) {
            session = SessionManager.INSTANCE.getSession((Resource)obj);
        }
        if (session != null) {
            return WorkspaceSynchronizer.getFile((Resource)session.getSessionResource());
        }
        return null;
    }

    protected void report(final LoggingEvent event) {
        Session session;
        final EmbeddedMessage em = (EmbeddedMessage)event.getMessage();
        int severity = this.log4jToDiagnostics(event.getLevel());
        IResource resource = this.workspaceRoot;
        if (em.getCapellaElements() != null && em.getCapellaElements().size() > 0 && (session = SessionManager.INSTANCE.getSession((EObject)em.getCapellaElements().iterator().next())) != null) {
            resource = EcoreUtil2.getFile((Resource)session.getSessionResource());
        }
        BasicDiagnostic diag = new BasicDiagnostic(severity, em.getComponentName(), 0, em.getLabel(), em.getCapellaElements().toArray());
        LightMarkerRegistry.getInstance().createMarker(resource, (Diagnostic)diag, "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview", new LightMarkerRegistry.IMarkerModification(){

            @Override
            public void modify(IMarker marker) {
                try {
                    marker.setAttribute("message", (Object)em.getLabel());
                    marker.setAttribute("severity", (Object)event.getLevel());
                    marker.setAttribute("priority", 2);
                    marker.setAttribute("location", (Object)em.getComponentName());
                    marker.setAttribute("org.eclipse.ui.views.markers.name", (Object)event.getLoggerName());
                    if (em.getCapellaElements() != null && em.getCapellaElements().size() > 0) {
                        Object element_o = em.getCapellaElements().get(0);
                        if (element_o instanceof ModelElement) {
                            ModelElement element = (ModelElement)element_o;
                            marker.setAttribute("org.eclipse.ui.views.markers.path", (Object)element.getFullLabel());
                        } else {
                            marker.setAttribute("org.eclipse.ui.views.markers.path", (Object)ReportManagerLogViewAppender.UNKNOWN);
                        }
                    }
                }
                catch (CoreException e) {
                    MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
                }
            }
        });
    }

    public void report(final String message, final Level level, final LightMarkerRegistry.IMarkerModification additions) {
        int severity = this.log4jToDiagnostics(level);
        LightMarkerRegistry.getInstance().createMarker(this.workspaceRoot, (Diagnostic)new BasicDiagnostic(severity, "", 0, message, Collections.emptyList().toArray()), "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview", new LightMarkerRegistry.IMarkerModification(){

            @Override
            public void modify(IMarker marker) {
                try {
                    marker.setAttribute("message", (Object)message);
                    marker.setAttribute("severity", (Object)level);
                    marker.setAttribute("priority", 2);
                }
                catch (CoreException e) {
                    MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
                }
                if (additions != null) {
                    additions.modify(marker);
                }
            }
        });
    }

    public void report(String message, Level level) {
        this.report(message, level, null);
    }

    private int log4jToDiagnostics(Level level) {
        int severity = 1;
        if (level == Level.WARN) {
            severity = 2;
        } else if (level == Level.ERROR || level == Level.FATAL) {
            severity = 4;
        }
        return severity;
    }
}

