/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;

public class DisableConstraintHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IHandlerService service = (IHandlerService)window.getService(IHandlerService.class);
        try {
            service.executeCommand("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.deleteconstraintmarkers", null);
        }
        catch (NotDefinedException exception) {
            MarkerViewPlugin.getDefault().log(4, exception.getMessage(), exception);
        }
        catch (NotEnabledException exception) {
            MarkerViewPlugin.getDefault().log(4, exception.getMessage(), exception);
        }
        catch (NotHandledException exception) {
            MarkerViewPlugin.getDefault().log(4, exception.getMessage(), exception);
        }
        IConstraintDescriptor descriptor = this.getConstraintDescriptor(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (descriptor != null) {
            EMFModelValidationPreferences.setConstraintDisabled((String)descriptor.getId(), (boolean)true);
            EMFModelValidationPreferences.save();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page;
        IWorkbenchWindow windows;
        boolean result = false;
        ISelection selection = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (windows = workbench.getActiveWorkbenchWindow()) != null && (page = windows.getActivePage()) != null) {
            selection = page.getSelection();
        }
        if (this.getConstraintDescriptor(selection) != null) {
            result = true;
        }
        return result;
    }

    private IConstraintDescriptor getConstraintDescriptor(ISelection selection) {
        IStructuredSelection ssel;
        Object first;
        IConstraintDescriptor descriptor = null;
        if (selection instanceof IStructuredSelection && (first = (ssel = (IStructuredSelection)selection).getFirstElement()) != null && first instanceof IMarker) {
            IMarker marker = (IMarker)first;
            descriptor = MarkerViewHelper.getConstraintDescriptor(marker);
        }
        return descriptor;
    }
}

