/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.persistence;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigurationInstance {
    protected List<OutputConfiguration> outputConfiguration;
    protected String componentName;

    public ConfigurationInstance() {
    }

    public ConfigurationInstance(ConfigurationInstance source) {
        this.componentName = source.getComponentName();
        for (OutputConfiguration config : source.getOutputConfiguration()) {
            this.getOutputConfiguration().add(new OutputConfiguration(config));
        }
    }

    public ConfigurationInstance(Element element) {
        this.setComponentName(element.getAttribute("ComponentName"));
        NodeList outputConfigList = element.getElementsByTagName("OutputConfiguration");
        this.outputConfiguration = new ArrayList<OutputConfiguration>();
        int i = 0;
        while (i < outputConfigList.getLength()) {
            this.outputConfiguration.add(new OutputConfiguration((Element)outputConfigList.item(i)));
            ++i;
        }
    }

    public List<OutputConfiguration> getOutputConfiguration() {
        if (this.outputConfiguration == null) {
            this.outputConfiguration = new ArrayList<OutputConfiguration>(1);
        }
        return this.outputConfiguration;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String value) {
        this.componentName = value;
    }

    public Element convertToElement(Document document) {
        Element element = document.createElement("ConfigurationInstance");
        Attr componentNameAttr = document.createAttribute("ComponentName");
        componentNameAttr.setValue(this.getComponentName());
        element.setAttributeNode(componentNameAttr);
        this.getOutputConfiguration().forEach(config -> {
            Element outputConfigElement = config.convertToElement(document);
            element.appendChild(outputConfigElement);
        });
        return element;
    }

    public void merge(ConfigurationInstance source) {
        block0: for (OutputConfiguration srcOutputConf : source.getOutputConfiguration()) {
            for (OutputConfiguration tgtOutputConf : this.getOutputConfiguration()) {
                if (srcOutputConf.getOutputName() == null || !srcOutputConf.getOutputName().equals(tgtOutputConf.getOutputName())) continue;
                this.merge(srcOutputConf, tgtOutputConf);
                continue block0;
            }
        }
    }

    protected void merge(OutputConfiguration srcOutputConf, OutputConfiguration tgtOutputConf) {
        block0: for (LogLevel srcLogLevel : srcOutputConf.getLogLevel()) {
            for (LogLevel tgtLogLevel : tgtOutputConf.getLogLevel()) {
                if (!srcLogLevel.getName().equals(tgtLogLevel.getName())) continue;
                tgtLogLevel.setValue(srcLogLevel.isValue());
                continue block0;
            }
        }
    }
}

