/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.interaction.validation.interactionUse.MDCHK_InteractionUse_ReferencedScenario;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.AbstractTransitionCommand;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.ScenarioTransform;
import org.polarsys.capella.core.projection.scenario.es2is.ES2ISTransform;

public class ESToISCommand
extends AbstractTransitionCommand {
    public ESToISCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public ESToISCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    public String getName() {
        return Messages.transitionES2IS_label;
    }

    protected Collection<EObject> retrieveModelElements(EObject modelElement_p) {
        return this.searchScenarios(modelElement_p);
    }

    protected AbstractTransform getTransformation(EObject element_p) {
        return new ES2ISTransform();
    }

    protected Collection<EObject> searchScenarios(EObject selectedElement_p) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (selectedElement_p instanceof Scenario) {
            this.addAllScenarios((Scenario)selectedElement_p, result);
            return result;
        }
        TreeIterator it = selectedElement_p.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof Scenario)) continue;
            Scenario scenario = (Scenario)eObject;
            if (this.isScenarioValid(scenario)) {
                this.addAllScenarios(scenario, result);
            }
            it.prune();
        }
        return result;
    }

    protected void addAllScenarios(Scenario scenario, Collection<EObject> result) {
        HashSet<EObject> referencedScenarios = new HashSet<EObject>();
        this.searchReferencedScenarios(scenario, referencedScenarios, result);
        result.addAll(referencedScenarios);
        result.add((EObject)scenario);
    }

    protected void searchReferencedScenarios(Scenario scenario, Set<EObject> references, Collection<EObject> result) {
        if (result.contains(scenario)) {
            return;
        }
        MDCHK_InteractionUse_ReferencedScenario checkRule = new MDCHK_InteractionUse_ReferencedScenario();
        for (TimeLapse timelapse : scenario.getOwnedTimeLapses()) {
            InteractionUse interaction;
            Scenario refScenario;
            if (!(timelapse instanceof InteractionUse) || (refScenario = (interaction = (InteractionUse)timelapse).getReferencedScenario()) == null || !checkRule.isValidReference(interaction, scenario, refScenario) || references.contains(refScenario) || !this.isScenarioValid(refScenario)) continue;
            references.add((EObject)refScenario);
            this.searchReferencedScenarios(refScenario, references, result);
        }
    }

    protected boolean isScenarioValid(Scenario scenario_p) {
        return TransitionHelper.getService().isES2ISTransitionAvailable((EObject)scenario_p);
    }

    public void run() {
        super.run();
        this.setReferencedScenarios(this.elements);
    }

    protected void setReferencedScenarios(Collection<EObject> elements) {
        MDCHK_InteractionUse_ReferencedScenario checkRule = new MDCHK_InteractionUse_ReferencedScenario();
        for (EObject element : elements) {
            if (!(element instanceof Scenario)) continue;
            for (Scenario scenario : ((Scenario)element).getRealizingScenarios()) {
                EList timelapses = scenario.getOwnedTimeLapses();
                for (TimeLapse timelapse : timelapses) {
                    AbstractTransform transform;
                    InteractionUse interaction;
                    Scenario refScenario;
                    if (!(timelapse instanceof InteractionUse) || (refScenario = (interaction = (InteractionUse)timelapse).getReferencedScenario()) == null || !((transform = this.getTransformation((EObject)refScenario)) instanceof ScenarioTransform)) continue;
                    ScenarioTransform scenarioTransform = (ScenarioTransform)transform;
                    Scenario transitionedScenario = scenarioTransform.getTransitionedScenario(refScenario, scenarioTransform.getTransfo());
                    if (transitionedScenario != null) {
                        interaction.setReferencedScenario(transitionedScenario);
                    }
                    if (checkRule.isValidReference(interaction, scenario, interaction.getReferencedScenario())) continue;
                    interaction.setReferencedScenario(null);
                }
            }
        }
    }
}

