/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ui.actions.ModelAdaptation;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.projection.scenario.fc2fs.FC2FSExt;
import org.polarsys.capella.core.projection.scenario.fc2fs.FC2FSInitialization;

public class FC2FSHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger((String)FC2FSHandler.class.getName());

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final Collection<FunctionalChain> funcChains = this.getFunctionalChainFromSelection();
        if (!funcChains.isEmpty()) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.setTaskName(event.getCommand().getName());
                    }
                    catch (NotDefinedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    FC2FSInitialization initialization = new FC2FSInitialization();
                    initialization.execute(funcChains);
                }
            };
            try {
                new ProgressMonitorDialog(FC2FSExt.getActiveShell()).run(false, false, runnable);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }

    private Collection<FunctionalChain> getFunctionalChainFromSelection() {
        ArrayList<FunctionalChain> result = new ArrayList<FunctionalChain>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        List capellaElements = ModelAdaptation.adaptToCapellaElements((Object)selection);
        for (ModelElement modelElement : capellaElements) {
            if (!(modelElement instanceof FunctionalChain)) continue;
            result.add((FunctionalChain)modelElement);
        }
        return result;
    }
}

