/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.ui.toolkit.dialogs.MdeElementListSelectionDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.FieldsViewer;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionGeneralViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionLabelProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeCellModifier;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeNodeContentProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionVisitor;
import org.polarsys.capella.core.ui.toolkit.decomposition.IDecompositionDataConstants;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;
import org.polarsys.capella.core.ui.toolkit.decomposition.RenameDecompositionDialog;
import org.polarsys.capella.core.ui.toolkit.viewers.NamedElementFullLabelProvider;
import org.polarsys.capella.core.ui.toolkit.viewers.NamedElementLabelProvider;

public class DecompositionTargetViewer
extends FieldsViewer
implements IDecompositionDataConstants {
    private SelectionListener buttonClickedListener;
    private Text decompNameText;
    private DecompositionModel decompositionModel;
    private ToolBar decompToolBar;
    private DecompositionGeneralViewer generalViewer;
    private ToolItem newDecompItem;
    private ToolItem newTargetItem;
    private ToolItem removeDecompItem;
    private ToolItem removeTargetItem;
    private Group rightComposite;
    private List<CapellaElement> shortcutItems;
    private CTabFolder tabFolder;
    private Menu targetMenu;
    private ToolBar targetToolBar;
    private TreeViewer targetTreeViewer;

    public DecompositionTargetViewer(Composite parent, DecompositionGeneralViewer viewer) {
        super(parent);
        this.generalViewer = viewer;
        this.decompositionModel = this.generalViewer.getDecompositionModel();
        this.initializeListeners();
        this.createViewer(parent);
    }

    public void addShortcutInput(CapellaElement element) {
        if (this.shortcutItems != null) {
            this.shortcutItems.add(element);
        }
    }

    private void addTargetComponentValidationListener(final Text text, final Decomposition decomposition) {
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                String newName = text.getText();
                if (newName != null) {
                    if (newName.trim().length() == 0) {
                        DecompositionTargetViewer.this.generalViewer.showErrorMessage(Messages.getString("LCDecompGeneralViewer.rename.empty.errormsg"));
                        return;
                    }
                    if (newName.trim().length() > 0) {
                        if (!DecompositionUtil.isValidName(newName.trim(), decomposition)) {
                            DecompositionTargetViewer.this.generalViewer.showErrorMessage(Messages.getString("LCDecompGeneralViewer.targetcomp.rename.errormsg"));
                        } else {
                            DecompositionTargetViewer.this.generalViewer.showErrorMessage(null);
                        }
                    }
                }
            }
        });
    }

    protected Button createButton(Composite parent, String text, String tooltip, Object data) {
        Button button = new Button(parent, 8);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 0;
        gdData.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)gdData);
        button.setText(text);
        button.setToolTipText(tooltip);
        button.setData(data);
        button.addSelectionListener(this.buttonClickedListener);
        return button;
    }

    public void createDecompositionTab(Decomposition decomposition) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            this.tabFolder = new CTabFolder((Composite)this.rightComposite, 0x1000000);
            this.tabFolder.addSelectionListener(this.buttonClickedListener);
            this.tabFolder.setMinimumCharacters(16);
            this.tabFolder.setBorderVisible(true);
            this.tabFolder.setSimple(false);
            this.setTabEditor();
        }
        Group comp = new Group((Composite)this.tabFolder, 0x1000020);
        comp.setText(Messages.getString("LCDecompGeneralViewer.current.decomp"));
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        Composite buttonComposite = new Composite((Composite)comp, 0x1000000);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.marginLeft = -5;
        layout.marginRight = -5;
        buttonComposite.setLayout((Layout)layout);
        this.createTargetToolItems(buttonComposite);
        GridData gdData = new GridData(768);
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)gdData);
        gdData = new GridData(1808);
        gdData.horizontalSpan = 6;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        Composite second = new Composite((Composite)comp, 0);
        second.setLayoutData((Object)gdData);
        second.setLayout((Layout)new FillLayout());
        this.tabFolder.setLayoutData((Object)gdData);
        this.createTargetContent(second);
        CTabItem item = new CTabItem(this.tabFolder, 0x1000000);
        item.setControl((Control)comp);
        item.setText(decomposition.getName());
        item.setData((Object)decomposition);
        this.targetTreeViewer.setInput((Object)decomposition);
        item.setData("TARGET_TREEVIEWER", (Object)this.targetTreeViewer);
        item.setData("REMOVE_TARGET_COMPONENT", (Object)this.removeTargetItem);
        CellEditor editor = this.targetTreeViewer.getCellEditors()[0];
        Text text = (Text)editor.getControl();
        this.addTargetComponentValidationListener(text, decomposition);
        this.setTreeCellEditor(item);
        this.rightComposite.layout();
        this.tabFolder.setSelection(item);
        this.generalViewer.getDecompositionModel().refreshStatus(decomposition);
        this.generalViewer.refreshItems(this.targetTreeViewer);
    }

    void createDND() {
        this.generalViewer.createDragDropSourceTargets(this.targetTreeViewer);
    }

    public Composite createInternalComposite(Composite parent) {
        return parent;
    }

    protected void createTargetContent(Composite composite) {
        this.targetTreeViewer = new TreeViewer(composite, 2818);
        this.targetTreeViewer.setColumnProperties(new String[]{"Component"});
        Tree tree = this.targetTreeViewer.getTree();
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)tree, 2048)};
        this.targetTreeViewer.setCellEditors(cellEditors);
        this.targetTreeViewer.setCellModifier((ICellModifier)new DecompositionTreeCellModifier(this.targetTreeViewer));
        this.targetTreeViewer.setLabelProvider((IBaseLabelProvider)new DecompositionLabelProvider(false));
        this.targetTreeViewer.setContentProvider((IContentProvider)new DecompositionTreeNodeContentProvider(this.decompositionModel));
        this.generalViewer.addSelectionListenerToViewer(this.targetTreeViewer);
    }

    private void createTargetToolItems(Composite customPart_p) {
        this.targetToolBar = new ToolBar(customPart_p, 256);
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        this.newTargetItem = this.createToolItem(this.targetToolBar, Messages.getString("LCDecompGeneralViewer.addtarget.tooltip"), "NEW_TARGET_COMPONENT", imgRegistry.get("toolitem.add"), 4);
        this.removeTargetItem = this.createToolItem(this.targetToolBar, Messages.getString("LCDecompGeneralViewer.removetarget.tooltip"), "REMOVE_TARGET_COMPONENT", imgRegistry.get("toolitem.remove"), 8);
        this.removeTargetItem.setEnabled(false);
    }

    private ToolItem createToolItem(ToolBar toolbar_p, String tooltip_p, Object data_p, Image image_p, int style) {
        ToolItem item = new ToolItem(toolbar_p, style);
        item.setData(data_p);
        item.setToolTipText(tooltip_p);
        item.setImage(image_p);
        item.addSelectionListener(this.buttonClickedListener);
        return item;
    }

    private void createViewer(Composite parent_p) {
        parent_p.setLayout((Layout)new FillLayout());
        this.rightComposite = new Group(parent_p, 0x1000020);
        this.rightComposite.setText(Messages.getString("LCDecompGeneralViewer.alterantive.decomp"));
        GridLayout rightLayout = new GridLayout();
        rightLayout.numColumns = 1;
        rightLayout.verticalSpacing = 5;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.rightComposite.setLayout((Layout)rightLayout);
        Composite decompActionsComposite = new Composite((Composite)this.rightComposite, 0x1000000);
        GridLayout layout = new GridLayout();
        decompActionsComposite.setLayout((Layout)layout);
        layout.numColumns = 5;
        layout.marginLeft = -5;
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        decompActionsComposite.setLayoutData((Object)gdData);
        this.decompToolBar = new ToolBar(decompActionsComposite, 256);
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        this.newDecompItem = this.createToolItem(this.decompToolBar, Messages.getString("LCDecompGeneralViewer.adddecomp.tooltip"), "NEW_DECOMPOSITION", imgRegistry.get("toolitem.add"), 8);
        this.removeDecompItem = this.createToolItem(this.decompToolBar, Messages.getString("LCDecompGeneralViewer.removedecomp.tooltip"), "REMOVE_DECOMPOSITION", imgRegistry.get("toolitem.remove"), 8);
        this.newDecompItem.setEnabled(false);
        this.removeDecompItem.setEnabled(false);
        this.initMenus();
    }

    public Text getDecompNameText() {
        return this.decompNameText;
    }

    public DecompositionModel getDecompositionModel() {
        return this.decompositionModel;
    }

    public Object getInput() {
        return null;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public TreeViewer getTargetTreeViewer() {
        return this.targetTreeViewer;
    }

    protected void handleButtonClicked(Widget button) {
        if (button.getData().equals("NEW_DECOMPOSITION")) {
            DecompositionVisitor.addNewDecomposition(this);
        } else if (button.getData().equals("REMOVE_DECOMPOSITION")) {
            DecompositionVisitor.removeSelectedDecomposition(this);
        } else if (button.getData().equals("REMOVE_ALL_DECOMPOSITION")) {
            DecompositionVisitor.removeAllDecomposition(this);
        } else if (button.getData().equals("RENAME_DECOMPOSITION")) {
            DecompositionVisitor.renameSelectedDecomposition(this);
        } else if (button.getData().equals("NEW_TARGET_COMPONENT")) {
            DecompositionVisitor.addNewTargetComponent(this);
        } else if (button.getData().equals("RENAME_TARGET_COMPONENT")) {
            DecompositionVisitor.renameTargetComponent(this);
        } else if (button.getData().equals("REMOVE_TARGET_COMPONENT")) {
            DecompositionVisitor.removeSelectedTargetComponent(this);
        } else if (button.getData().equals("REMOVE_ALL_TARGET_COMPONENTS")) {
            DecompositionVisitor.removeAllTargetComponent(this);
        } else if (button.getData().equals("DETACH_INTERFACE")) {
            DecompositionVisitor.detachInterface(this);
        } else if (button.getData().equals("REUSE_TARGET_COMPONENT")) {
            DecompositionVisitor.reuseComponent(this);
        }
    }

    protected void handleMenuSelected(Widget widget) {
        MenuItem item = (MenuItem)widget;
        if (item.getData().equals("NEW_TARGET_COMPONENT")) {
            DecompositionVisitor.addNewTargetComponent(this);
        } else if (item.getData().equals("REUSE_TARGET_COMPONENT")) {
            NamedElementLabelProvider _labelProvider = new NamedElementLabelProvider();
            NamedElementFullLabelProvider _statusLabelProvider = new NamedElementFullLabelProvider();
            MdeElementListSelectionDialog selectionDialog = new MdeElementListSelectionDialog(this.targetTreeViewer.getControl().getShell(), (ILabelProvider)_labelProvider, (ILabelProvider)_statusLabelProvider);
            selectionDialog.setTitle(Messages.getString("LCDecomp.title.label"));
            selectionDialog.setMultipleSelection(false);
            selectionDialog.setMatchEmptyString(true);
            selectionDialog.setIgnoreCase(true);
            selectionDialog.setHelpAvailable(true);
            DecompositionComponent sourceComponent = this.decompositionModel.getSourceComponent();
            Object value = sourceComponent.getValue();
            if (value instanceof LogicalComponent) {
                LogicalComponent lc = (LogicalComponent)value;
                Collection allAncestors = ComponentExt.getComponentAncestors((Component)lc);
                Collection allDescendants = ComponentExt.getAllSubUsedComponents((Component)lc);
                Collection allLCS = BlockArchitectureExt.getAllComponents((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)lc));
                allLCS.removeAll(allAncestors);
                allLCS.removeAll(allDescendants);
                allLCS.remove(lc);
                ArrayList<LogicalComponent> lclist = new ArrayList<LogicalComponent>();
                for (Component component : allLCS) {
                    if (!(component instanceof LogicalComponent)) continue;
                    lclist.add((LogicalComponent)component);
                }
                selectionDialog.setElements(lclist.toArray());
            }
            if (selectionDialog.open() == 0) {
                this.tabFolder.getSelection().setData("REUSE_TARGET_COMPONENT", selectionDialog.getFirstResult());
                DecompositionVisitor.reuseComponent(this);
            }
        }
    }

    protected void handleTabItemChanged(Widget widget) {
        this.generalViewer.createDNDForTargetViewer((CTabFolder)widget);
    }

    private void initializeListeners() {
        this.buttonClickedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget instanceof Button || widget instanceof ToolItem) {
                    if (event.detail == 4 && widget.getData().equals("NEW_TARGET_COMPONENT")) {
                        Point point = new Point(event.x, event.y);
                        point = Display.getCurrent().map((Control)DecompositionTargetViewer.this.targetToolBar, null, point);
                        DecompositionTargetViewer.this.targetMenu.setLocation(point);
                        DecompositionTargetViewer.this.targetMenu.setVisible(true);
                    } else {
                        DecompositionTargetViewer.this.handleButtonClicked(widget);
                    }
                } else if (widget instanceof CTabFolder) {
                    DecompositionTargetViewer.this.handleTabItemChanged(widget);
                } else if (widget instanceof MenuItem) {
                    DecompositionTargetViewer.this.handleMenuSelected(widget);
                }
            }
        };
    }

    private void initMenus() {
        this.targetMenu = new Menu((Control)this.rightComposite.getShell());
        MenuItem lcMenuItem = new MenuItem(this.targetMenu, 8);
        lcMenuItem.setText(Messages.getString("LCDecomp.lc.menu.label"));
        lcMenuItem.addSelectionListener(this.buttonClickedListener);
        lcMenuItem.setData((Object)"NEW_TARGET_COMPONENT");
        MenuItem lcShortcutMenuItem = new MenuItem(this.targetMenu, 8);
        lcShortcutMenuItem.setText(Messages.getString("LCDecomp.lcreuse.menu.label"));
        lcShortcutMenuItem.addSelectionListener(this.buttonClickedListener);
        lcShortcutMenuItem.setData((Object)"REUSE_TARGET_COMPONENT");
    }

    void refreshItems(TreeViewer viewer) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            this.generalViewer.refreshItems(null);
            return;
        }
        this.generalViewer.refreshItems(viewer);
    }

    public void removeShortcutInput(Object element) {
        if (this.shortcutItems != null) {
            this.shortcutItems.remove(element);
        }
    }

    public void setDecompNameText(Text decompNameText_p) {
        this.decompNameText = decompNameText_p;
    }

    public void setDecompositionFieldsEnabled(int size) {
        this.removeDecompItem.setEnabled(size > 1);
    }

    public void setDecompositionModel(DecompositionModel decompositionModel_p) {
        this.decompositionModel = decompositionModel_p;
    }

    void setDecompositionName(boolean flag) {
        List<Decomposition> list = this.decompositionModel.getDecompositions();
        int size = list.size();
        Decomposition firstDecomp = (Decomposition)this.tabFolder.getItem(0).getData();
        String name = Messages.getString("LCDecompGeneralViewer.decomposition.name");
        firstDecomp.setName((String)(size > 1 ? (flag ? name + "0" : name + "1") : ""));
        this.tabFolder.getItem(0).setText(firstDecomp.getName());
    }

    void setDefaultSelectedTabIndex() {
        this.tabFolder.setSelection(0);
        this.generalViewer.createDNDForTargetViewer(this.tabFolder);
    }

    public void setDetachInterfaceButtonEnabled(boolean isEnabled) {
    }

    public void setInput(Object input) {
    }

    void setRemoveTCButtonEnabled(boolean isEnabled) {
        ToolItem removeItem = (ToolItem)this.tabFolder.getSelection().getData("REMOVE_TARGET_COMPONENT");
        if (removeItem != null) {
            removeItem.setEnabled(isEnabled);
        }
    }

    private void setTabEditor() {
        if (this.tabFolder != null) {
            this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent me_p) {
                    if (DecompositionTargetViewer.this.tabFolder.getItemCount() > 1) {
                        CTabItem item = DecompositionTargetViewer.this.tabFolder.getSelection();
                        Point pt = new Point(me_p.x, me_p.y);
                        RenameDecompositionDialog popup = new RenameDecompositionDialog(DecompositionTargetViewer.this.tabFolder.getShell(), 540676, true, false, false, false, null, Messages.getString("LCDecompGeneralViewer.renamedecomp.popupinfo"), item, pt, DecompositionTargetViewer.this);
                        popup.open();
                        item.addListener(8, DecompositionUtil.getRenameDecompListener(item));
                    }
                }
            });
        }
    }

    public void setTabFolder(CTabFolder tabFolder_p) {
        this.tabFolder = tabFolder_p;
    }

    public void setTargetTreeViewer(TreeViewer targetTreeViewer_p) {
        this.targetTreeViewer = targetTreeViewer_p;
    }

    private void setTreeCellEditor(CTabItem item_p) {
        final TreeViewer viewer = (TreeViewer)item_p.getData("TARGET_TREEVIEWER");
        Tree tree = viewer.getTree();
        tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Object data;
                ((DecompositionTreeCellModifier)viewer.getCellModifier()).setEnabled(false);
                DecompositionTargetViewer.this.generalViewer.showErrorMessage(null);
                if (event != null && (data = event.data) != null && data.equals("rename")) {
                    DecompositionComponent comp = (DecompositionComponent)event.item.getData();
                    DecompositionTargetViewer.this.decompositionModel.setPathForNewTargetComponent(comp);
                    DecompositionTargetViewer.this.generalViewer.updateStatusBar(comp);
                }
            }
        });
        viewer.addDoubleClickListener(e -> DecompositionVisitor.renameTargetComponent(this));
    }

    void showErrorMessage(String msg) {
        this.generalViewer.showErrorMessage(msg);
    }
}

