/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTargetViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeCellModifier;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;

public class DecompositionVisitor {
    public static void addNewDecomposition(DecompositionTargetViewer viewer) {
        String name = "";
        DecompositionModel model = viewer.getDecompositionModel();
        if (model.addDecomposition(name)) {
            String nameText;
            List<Decomposition> list = model.getDecompositions();
            int size = list.size();
            if (size == 2) {
                viewer.setDecompositionName(false);
            }
            Decomposition decomp = list.get(size - 1);
            name = DecompositionUtil.getDecompositionName(list);
            Text text = viewer.getDecompNameText();
            if (text != null && (nameText = text.getText()).trim().length() > 0) {
                name = nameText;
                if (name.equals(Messages.getString("LCDecompGeneralViewer.decomposition.name") + "1") && size == 2) {
                    viewer.setDecompositionName(true);
                }
                text.setText("");
            }
            decomp.setName(name);
            viewer.createDecompositionTab(decomp);
            viewer.createDND();
            viewer.setDecompositionFieldsEnabled(model.getDecompositions().size());
        }
    }

    public static void addNewTargetComponent(DecompositionTargetViewer viewer) {
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        DecompositionComponent comp = new DecompositionComponent();
        Decomposition decomposition = (Decomposition)item.getData();
        String name = DecompositionUtil.getTargetComponentName(decomposition.getTargetComponents());
        comp.setName(name);
        if (model.addNewTargetComponent(decomposition, comp)) {
            viewer.refreshItems(treeViewer);
        }
    }

    public static void detachInterface(DecompositionTargetViewer viewer) {
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        ITreeSelection selection = (ITreeSelection)treeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List list = selection.toList();
        for (Object element : list) {
            DecompositionItem pair;
            DecompositionComponent comp;
            if (!model.isDetachAllowed(element) || (comp = (pair = (DecompositionItem)element).getParentComponent()).isReusedComponent() || !model.detachInterface(comp, pair)) continue;
            viewer.refreshItems(treeViewer);
        }
    }

    public static List<DecompositionComponent> getReusedComponents(Decomposition decomposition_p) {
        ArrayList<DecompositionComponent> list = new ArrayList<DecompositionComponent>(1);
        for (DecompositionComponent comp : decomposition_p.getTargetComponents()) {
            if (!comp.isReusedComponent()) continue;
            list.add(comp);
        }
        return list;
    }

    public static void removeAllDecomposition(DecompositionTargetViewer viewer) {
        DecompositionModel model = viewer.getDecompositionModel();
        CTabFolder tabFolder = viewer.getTabFolder();
        if (tabFolder == null || tabFolder.isDisposed()) {
            return;
        }
        if (model.removeAllDecomposition()) {
            CTabItem[] cTabItemArray = tabFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                item.dispose();
                ++n2;
            }
            tabFolder.dispose();
            tabFolder = null;
            viewer.refreshItems(null);
        }
        DecompositionVisitor.addNewDecomposition(viewer);
        viewer.setDecompositionFieldsEnabled(model.getDecompositions().size());
    }

    public static void removeAllTargetComponent(DecompositionTargetViewer viewer) {
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        Decomposition decomposition = (Decomposition)item.getData();
        if (model.removeAllTargetComponents(decomposition)) {
            viewer.refreshItems(treeViewer);
        }
    }

    public static void removeSelectedDecomposition(DecompositionTargetViewer viewer) {
        DecompositionModel model = viewer.getDecompositionModel();
        CTabFolder tabFolder = viewer.getTabFolder();
        if (tabFolder == null || tabFolder.isDisposed()) {
            return;
        }
        Decomposition decomposition = (Decomposition)tabFolder.getSelection().getData();
        if (model.removeDecomposition(decomposition)) {
            tabFolder.getSelection().dispose();
            viewer.refreshItems(null);
            if (model.getDecompositions().size() == 1) {
                viewer.setDecompositionName(false);
            }
        }
        if (tabFolder.getItemCount() == 0) {
            tabFolder.dispose();
            tabFolder = null;
            viewer.refreshItems(null);
            DecompositionVisitor.addNewDecomposition(viewer);
        }
        viewer.setDecompositionFieldsEnabled(model.getDecompositions().size());
    }

    public static void removeSelectedTargetComponent(DecompositionTargetViewer viewer) {
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        ITreeSelection selection = (ITreeSelection)treeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List list = selection.toList();
        for (Object data : list) {
            Decomposition decomposition = (Decomposition)item.getData();
            if (model.isRemoveAllowed(data)) {
                if (data instanceof DecompositionComponent) {
                    DecompositionComponent comp = (DecompositionComponent)data;
                    if (model.removeTargetComponent(decomposition, comp)) {
                        if (comp.isReusedComponent()) {
                            viewer.addShortcutInput((CapellaElement)comp.getReusedTarget());
                        }
                        viewer.refreshItems(treeViewer);
                    }
                } else if (data instanceof DecompositionItem) {
                    DecompositionItem itemItf = (DecompositionItem)data;
                    model.addDecompositionItemRemoved(itemItf);
                    model.detachInterface(itemItf.getParentComponent(), itemItf);
                    viewer.refreshItems(treeViewer);
                }
            }
            viewer.setRemoveTCButtonEnabled(!decomposition.getTargetComponents().isEmpty());
        }
    }

    public static void renameSelectedDecomposition(DecompositionTargetViewer viewer) {
        DecompositionModel model = viewer.getDecompositionModel();
        Text text = viewer.getDecompNameText();
        CTabFolder tabFolder = viewer.getTabFolder();
        String txt = text.getText();
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        if (tabFolder == null || tabFolder.isDisposed()) {
            return;
        }
        Decomposition decomposition = (Decomposition)tabFolder.getSelection().getData();
        if (model.renameDecomposition(decomposition, txt)) {
            tabFolder.getSelection().setText(txt);
            text.setText("");
        }
    }

    public static void renameTargetComponent(DecompositionTargetViewer viewer) {
        Object value;
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        DecompositionComponent dc = null;
        LogicalComponent lc = null;
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        ITreeSelection selection = (ITreeSelection)treeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object data = selection.getFirstElement();
        Object part = null;
        if (data instanceof DecompositionComponent && (value = (dc = (DecompositionComponent)data).getValue()) != null && value instanceof LogicalComponent) {
            lc = (LogicalComponent)value;
            if (lc.getAbstractTypedElements() != null && !lc.getAbstractTypedElements().isEmpty()) {
                part = lc.getAbstractTypedElements().get(0);
                dc.setName(((AbstractTypedElement)part).getName());
                dc.setTrigger(true);
            } else {
                dc.setName(lc.getName());
                dc.setTrigger(true);
            }
        }
        if (model.isRenameAllowed(data)) {
            ((DecompositionTreeCellModifier)treeViewer.getCellModifier()).setEnabled(true);
            treeViewer.editElement(data, 0);
        }
    }

    public static void reuseComponent(DecompositionTargetViewer viewer) {
        Decomposition decomposition;
        CTabFolder folder = viewer.getTabFolder();
        DecompositionModel model = viewer.getDecompositionModel();
        CTabItem item = folder.getSelection();
        TreeViewer treeViewer = (TreeViewer)item.getData("TARGET_TREEVIEWER");
        Object obj = item.getData("REUSE_TARGET_COMPONENT");
        if (obj != null && model.reuseTargetComponent(decomposition = (Decomposition)item.getData(), obj)) {
            viewer.removeShortcutInput(obj);
            viewer.refreshItems(treeViewer);
        }
    }
}

