/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.internal.quickfix;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ui.IMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.internal.quickfix.CapellaQuickFixExtPointUtil;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public final class MarkerResolutionCache {
    public static MarkerResolutionCache INSTANCE = new MarkerResolutionCache();
    public static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];
    Map<String, Set<AbstractCapellaMarkerResolution>> map;
    Map<AbstractCapellaMarkerResolution, Set<String>> resolverRuleMap;

    private MarkerResolutionCache() {
        this.initCache();
    }

    public IMarkerResolution[] getResolutionsFor(String constraintId) {
        Set<AbstractCapellaMarkerResolution> set;
        IMarkerResolution[] result = NO_RESOLUTIONS;
        if (constraintId != null && constraintId.length() > 0 && (set = this.map.get(constraintId)) != null) {
            result = (IMarkerResolution[])set.toArray(new AbstractCapellaMarkerResolution[0]);
        }
        return result;
    }

    public Map<AbstractCapellaMarkerResolution, Set<String>> getResolverRuleMap() {
        return this.resolverRuleMap;
    }

    protected void initCache() {
        this.map = new HashMap<String, Set<AbstractCapellaMarkerResolution>>();
        Map<AbstractCapellaMarkerResolution, Set<String>> map = CapellaQuickFixExtPointUtil.gettAllAvailableMarkerResolution();
        this.resolverRuleMap = map;
        HashSet<String> allConstraintsIds = new HashSet<String>();
        for (IConstraintDescriptor icd : ValidationHelper.getAllConstraintDescriptors()) {
            if (icd == null || icd.getId() == null || icd.getId().length() <= 0) continue;
            allConstraintsIds.add(icd.getId());
        }
        allConstraintsIds.add("org.eclipse.emf.ecore.1");
        allConstraintsIds.add("org.eclipse.emf.ecore.4");
        allConstraintsIds.add("org.eclipse.emf.ecore.16");
        Set<String> ids = null;
        for (AbstractCapellaMarkerResolution key : map.keySet()) {
            ids = map.get((Object)key);
            block2: for (String id : ids) {
                if (allConstraintsIds.contains(id)) {
                    this.addToCache(id, key);
                    continue;
                }
                for (String current : allConstraintsIds) {
                    if (!current.endsWith("." + id)) continue;
                    this.addToCache(current, key);
                    continue block2;
                }
            }
        }
    }

    private void addToCache(String constraintID, AbstractCapellaMarkerResolution markerResolution) {
        String key = constraintID;
        if (this.map == null) {
            this.map = new HashMap<String, Set<AbstractCapellaMarkerResolution>>();
        }
        if (this.map.containsKey(key)) {
            this.map.get(key).add(markerResolution);
        } else {
            HashSet<AbstractCapellaMarkerResolution> value = new HashSet<AbstractCapellaMarkerResolution>();
            value.add(markerResolution);
            this.map.put(key, value);
        }
    }

    protected void cleanCache() {
        for (Set<AbstractCapellaMarkerResolution> set : this.map.values()) {
            set.clear();
        }
        this.map.clear();
    }
}

