/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.listener;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.domain.AbstractEditingDomainResourceSetListenerImpl;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.IUserEnforcedHelper2;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.helper.IUserEnforcedHelper;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.AbortedTransactionException;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.pre.condition.IFileModificationPreconditionChecker;
import org.polarsys.capella.core.platform.sirius.ui.session.CapellaSessionHelper;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;

public class FileModificationPreCommitListener
extends AbstractEditingDomainResourceSetListenerImpl
implements SessionManagerListener {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private volatile boolean _disableValidateEdit;
    private static IFileModificationPreconditionChecker __fileModificationPrecondtionChecker;
    private static boolean __alreadyLookup;

    public FileModificationPreCommitListener() {
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
    }

    public void disposedEditingDomain(EditingDomain editingDomain) {
        super.disposedEditingDomain(editingDomain);
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (event.getTransaction().isReadOnly()) {
            return null;
        }
        if (this._disableValidateEdit) {
            return null;
        }
        List notifications = event.getNotifications();
        HashSet<IFile> filesToMakeWritable = new HashSet<IFile>(0);
        HashSet<Resource> resourcesToMakeWritable = new HashSet<Resource>(0);
        HashMap<ResourceSetSync, Set<Resource>> additionalResourcesToChangeStatus = new HashMap<ResourceSetSync, Set<Resource>>(0);
        HashMap<EObject, Resource> removedElementFromResource = new HashMap<EObject, Resource>(0);
        for (Object currentNotification : notifications) {
            Resource resource;
            Object notification;
            Object notifier;
            if (!(currentNotification instanceof Notification) || !((notifier = (notification = (Notification)currentNotification).getNotifier()) instanceof EObject)) continue;
            if (CapellaResourceHelper.isSemanticElement((Object)notifier)) {
                this.markDirtyDependentResources(resourcesToMakeWritable, additionalResourcesToChangeStatus, (Notification)notification, (EObject)notifier, removedElementFromResource);
            }
            if ((resource = ((EObject)notifier).eResource()) == null || new NotificationQuery((Notification)currentNotification).isTransientNotification()) continue;
            this.handleMakeResourceWritable(resourcesToMakeWritable, currentNotification, resource);
        }
        HashSet<Resource> writableResources = new HashSet<Resource>();
        if (!resourcesToMakeWritable.isEmpty()) {
            for (Resource resource : resourcesToMakeWritable) {
                IFile file = EcoreUtil2.getFile((Resource)resource);
                boolean fileAdded = this.handleMakeFileWritable(filesToMakeWritable, file);
                if (fileAdded) continue;
                writableResources.add(resource);
            }
        }
        if (!filesToMakeWritable.isEmpty()) {
            try {
                FileModificationPreCommitListener.makeFilesWritable(event.getEditingDomain(), filesToMakeWritable);
            }
            catch (RollbackException re) {
                this.doCheckUserWritePermission(resourcesToMakeWritable);
            }
        }
        if (!writableResources.isEmpty()) {
            this.doCheckPrecondition(writableResources);
        }
        if (!resourcesToMakeWritable.isEmpty()) {
            this.doCheckUserWritePermission(resourcesToMakeWritable);
        }
        for (Map.Entry entry : additionalResourcesToChangeStatus.entrySet()) {
            ResourceSetSync resourceSetSync = (ResourceSetSync)entry.getKey();
            Set dependentResources = (Set)entry.getValue();
            for (Resource resource : dependentResources) {
                resourceSetSync.statusChanged(resource, ResourceSetSync.ResourceStatus.SYNC, ResourceSetSync.ResourceStatus.CHANGED);
            }
        }
        return null;
    }

    public void doCheckPrecondition(Set<Resource> resourcesToMakeWritable) throws AbortedTransactionException {
        ArrayList<IFile> lstFile = new ArrayList<IFile>();
        for (Resource res : resourcesToMakeWritable) {
            lstFile.add(EcoreUtil2.getFile((Resource)res));
        }
        boolean result = true;
        IFileModificationPreconditionChecker preConditionChecker = FileModificationPreCommitListener.getFileModificationPreconditionChecker();
        if (preConditionChecker != null) {
            result = preConditionChecker.fulfillConditions(lstFile);
        }
        if (!result) {
            throw new AbortedTransactionException(Status.CANCEL_STATUS, "Pre-conditions are not satisfactory");
        }
    }

    private void doCheckUserWritePermission(Set<Resource> resourcesToMakeWritable) throws AbortedTransactionException {
        ArrayList<IFile> filesToCheck = new ArrayList<IFile>();
        for (Resource resource : resourcesToMakeWritable) {
            IFile file = EcoreUtil2.getFile((Resource)resource);
            if (file == null) continue;
            filesToCheck.add(file);
        }
        IStatus userWritePermissionStatus = FileModificationPreCommitListener.checkUserWritePermission(new ArrayList<IFile>(filesToCheck));
        if (!userWritePermissionStatus.isOK()) {
            throw new AbortedTransactionException(Status.CANCEL_STATUS, "End-user canceled to make the file writable or it failed to make it writable.");
        }
    }

    protected void markDirtyDependentResources(Set<Resource> resourcesToMakeWritable, Map<ResourceSetSync, Set<Resource>> additionalResourcesToChangeStatus, Notification notification, EObject notifier, Map<EObject, Resource> removedElementFromResource) {
        EReference reference;
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment() && !notification.isTouch()) {
            ArrayList<EObject> objectsToUpdate = new ArrayList<EObject>(1);
            Resource notifierResource = notifier.eResource();
            switch (notification.getEventType()) {
                case 2: 
                case 4: {
                    Object oldValue = notification.getOldValue();
                    if (CapellaResourceHelper.isSemanticElement((Object)oldValue)) {
                        EObject removedElement = (EObject)oldValue;
                        removedElementFromResource.put(removedElement, notifierResource);
                    }
                    return;
                }
                case 6: {
                    break;
                }
                case 1: 
                case 3: {
                    objectsToUpdate.add((EObject)notification.getNewValue());
                    break;
                }
                case 5: {
                    objectsToUpdate.addAll((Collection)notification.getNewValue());
                }
            }
            for (EObject objectToUpdate : objectsToUpdate) {
                Resource objectToUpdateResource = removedElementFromResource.get(objectToUpdate);
                if (objectToUpdateResource == null || notifierResource.equals(objectToUpdateResource)) continue;
                Collection dependentResources = RepresentationHelper.collectDependentResources((EObject)objectToUpdate);
                for (Resource dependentResource : dependentResources) {
                    this.handleMakeResourceWritable(resourcesToMakeWritable, objectToUpdate, dependentResource);
                    ResourceSetSync resourceSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)objectToUpdate)));
                    if (!ResourceSetSync.ResourceStatus.SYNC.equals((Object)ResourceSetSync.getStatus((Resource)dependentResource))) continue;
                    Set<Resource> resources = additionalResourcesToChangeStatus.get(resourceSetSync);
                    if (resources == null) {
                        resources = new HashSet<Resource>(0);
                        additionalResourcesToChangeStatus.put(resourceSetSync, resources);
                    }
                    resources.add(dependentResource);
                }
            }
        }
    }

    public void handleMakeResourceWritable(Set<Resource> resourcesToMakeWritable, Object notificationObject, Resource resource) {
        if (resource != null) {
            if (__logger.isDebugEnabled() && !resourcesToMakeWritable.contains(resource)) {
                __logger.debug((Object)new EmbeddedMessage(StringHelper.formatMessage((String)"Make Resource ''{0}'' Writable (if required) due to notification:{1}", (Object[])new String[]{resource.getURI().toString(), notificationObject.toString()}), "User Interface"));
            }
            resourcesToMakeWritable.add(resource);
        }
    }

    public boolean handleMakeFileWritable(Set<IFile> filesToMakeWritable, IFile file) {
        if (file != null && file.isReadOnly()) {
            if (__logger.isDebugEnabled() && !filesToMakeWritable.contains(file)) {
                __logger.debug((Object)new EmbeddedMessage(StringHelper.formatMessage((String)"Make File ''{0}'' Writable", (Object[])new String[]{file.getFullPath().toString()}), "User Interface"));
            }
            filesToMakeWritable.add(file);
            return true;
        }
        return false;
    }

    private static IFileModificationPreconditionChecker getFileModificationPreconditionChecker() {
        if (!__alreadyLookup && __fileModificationPrecondtionChecker == null) {
            IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.model.handler", (String)"fileModificationPreconditionChecker");
            if (configurationElements.length > 0) {
                __fileModificationPrecondtionChecker = (IFileModificationPreconditionChecker)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class");
            }
            __alreadyLookup = true;
        }
        return __fileModificationPrecondtionChecker;
    }

    public static void makeFilesWritable(TransactionalEditingDomain editingDomain, final Collection<IFile> filesToMakeWritable) throws AbortedTransactionException {
        final boolean[] result = new boolean[]{true};
        final IFileModificationPreconditionChecker preConditionChecker = FileModificationPreCommitListener.getFileModificationPreconditionChecker();
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec((Runnable)editingDomain.createPrivilegedRunnable(new Runnable(){

            @Override
            public void run() {
                IStatus status;
                IUserEnforcedHelper userEnforcedHelper;
                if (preConditionChecker != null) {
                    result[0] = preConditionChecker.fulfillConditions(filesToMakeWritable);
                }
                if (result[0] && (userEnforcedHelper = SolFaCommonActivator.getDefault().getUserEnforcedHelper()) instanceof IUserEnforcedHelper2 && !(status = ((IUserEnforcedHelper2)userEnforcedHelper).makeFilesWritable(filesToMakeWritable.toArray(new IFile[filesToMakeWritable.size()]))).isOK()) {
                    result[0] = false;
                }
            }
        }));
        if (!result[0]) {
            throw new AbortedTransactionException(Status.CANCEL_STATUS, "End-user canceled to make the file writable or it failed to make it writable.");
        }
    }

    protected static IStatus checkUserWritePermission(List<IFile> filesToMakeWritable) {
        HashSet<File> filesWithNoWritePermission = new HashSet<File>();
        for (IFile file : filesToMakeWritable) {
            IPath rawLocation = file.getRawLocation();
            if (rawLocation == null) continue;
            File fileSysFile = new File(rawLocation.toOSString());
            FileOutputStream fo = null;
            try {
                try {
                    fo = new FileOutputStream(fileSysFile, true);
                }
                catch (FileNotFoundException e) {
                    filesWithNoWritePermission.add(fileSysFile);
                    if (fo == null) continue;
                    try {
                        fo.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (fo != null) {
                    try {
                        fo.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fo == null) continue;
            try {
                fo.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (filesWithNoWritePermission.isEmpty()) {
            return Status.OK_STATUS;
        }
        StringBuilder sb = new StringBuilder("Following files are not accessible (may result from a write access denied)\n");
        for (File f : filesWithNoWritePermission) {
            sb.append(f.getAbsolutePath() + "\n");
        }
        CapellaSessionHelper.reportError((IStatus)new Status(4, SiriusUIPlugin.getDefault().getPluginId(), sb.toString()));
        return Status.CANCEL_STATUS;
    }

    public void setDisableValidateEdit(boolean disableValidateEdit) {
        this._disableValidateEdit = disableValidateEdit;
    }

    public void notify(Session updated, int notification) {
        switch (notification) {
            case 4: {
                if (this.getTarget() == null || !this.getTarget().equals(updated.getTransactionalEditingDomain())) break;
                this.setDisableValidateEdit(true);
                break;
            }
            case 5: {
                if (this.getTarget() == null || !this.getTarget().equals(updated.getTransactionalEditingDomain())) break;
                this.setDisableValidateEdit(false);
            }
        }
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }
}

