/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewer;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.LinkManager;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public class EIAllocationLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IBaseLabelProvider,
IColorProvider,
IFontProvider {
    protected final boolean isSourceViewer;
    private final EIAllocationTreeViewer treeViewer;
    private LinkManager linkManager;
    private Font startedLinkElementFont;
    private IConstraintFilter _filter = new IConstraintFilter(){

        public boolean accept(IConstraintDescriptor constraint, EObject target) {
            return EIAllocationLabelProvider.this.isSourceViewer ? EIAllocationLabelProvider.this._srcDesc.contains(constraint) : EIAllocationLabelProvider.this._tgtDesc.contains(constraint);
        }
    };
    private static final String prefix = "org.polarsys.capella.core.data.fa.validation.";
    protected List<IConstraintDescriptor> _srcDesc = EIAllocationLabelProvider.getConstraintDescriptors(Arrays.asList("org.polarsys.capella.core.data.fa.validation.TC_DF_10", "org.polarsys.capella.core.data.fa.validation.TC_DF_11", "org.polarsys.capella.core.data.fa.validation.TC_DF_12", "org.polarsys.capella.core.data.fa.validation.TC_DF_13", "org.polarsys.capella.core.data.fa.validation.TC_DF_14"));
    protected List<IConstraintDescriptor> _tgtDesc = EIAllocationLabelProvider.getConstraintDescriptors(Arrays.asList("org.polarsys.capella.core.data.fa.validation.TC_DF_11", "org.polarsys.capella.core.data.fa.validation.TC_DF_12", "org.polarsys.capella.core.data.fa.validation.TC_DF_13", "org.polarsys.capella.core.data.fa.validation.TC_DF_14"));
    public static final String VALIDATION_KEY = "Validation";

    public EIAllocationLabelProvider(LinkManager linkManager, EIAllocationTreeViewer treeViewer, boolean isSourceViewer) {
        this.isSourceViewer = isSourceViewer;
        this.treeViewer = treeViewer;
        this.linkManager = linkManager;
    }

    public void dispose() {
        if (this.startedLinkElementFont != null && !this.startedLinkElementFont.isDisposed()) {
            this.startedLinkElementFont.dispose();
            this.startedLinkElementFont = null;
        }
        super.dispose();
    }

    public String getText(Object element) {
        Object text = super.getText(element);
        if (this.linkManager.isStartedElement(element)) {
            text = (String)text + " [start link]";
        }
        return text;
    }

    public Font getFont(Object element) {
        if (this.linkManager.isStartedElement(element)) {
            return this.getStartedLinkElementFont();
        }
        return super.getFont(element);
    }

    private boolean isValid(EObject element) {
        CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().addConstraintFilter(this._filter);
        IStatus status = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().validate(element);
        CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().removeConstraintFilter(this._filter);
        Widget w = this.treeViewer.findItem(element);
        if (w instanceof TreeItem) {
            if (!status.isOK()) {
                w.setData(VALIDATION_KEY, (Object)status);
            } else {
                w.setData(VALIDATION_KEY, null);
            }
        }
        return status.isOK();
    }

    public Color getForeground(Object element) {
        if (!this.isValid((EObject)element)) {
            return Display.getCurrent().getSystemColor(3);
        }
        return super.getForeground(element);
    }

    public static List<IConstraintDescriptor> getConstraintDescriptors(List<String> ids) {
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>();
        ValidationHelper.ensureEMFValidationActivation();
        for (IConstraintDescriptor icd : ValidationHelper.getAllCapellaConstraintDescriptors()) {
            String id = icd.getId();
            if (!ids.contains(id)) continue;
            result.add(icd);
        }
        return result;
    }

    protected Font getStartedLinkElementFont() {
        if (this.startedLinkElementFont == null) {
            this.startedLinkElementFont = new Font((Device)Display.getDefault(), "Arial", 9, 3);
        }
        return this.startedLinkElementFont;
    }
}

