/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class NormalizeCharMap {
    final FST<CharsRef> map;
    final Map<Character, FST.Arc<CharsRef>> cachedRootArcs = new HashMap<Character, FST.Arc<CharsRef>>();

    private NormalizeCharMap(FST<CharsRef> map) {
        this.map = map;
        if (map != null) {
            try {
                FST.Arc scratchArc = new FST.Arc();
                FST.BytesReader fstReader = map.getBytesReader();
                map.getFirstArc(scratchArc);
                if (FST.targetHasArcs((FST.Arc)scratchArc)) {
                    map.readFirstRealTargetArc(scratchArc.target(), scratchArc, fstReader);
                    while (true) {
                        assert (scratchArc.label() != -1);
                        this.cachedRootArcs.put(Character.valueOf((char)scratchArc.label()), (FST.Arc<CharsRef>)new FST.Arc().copyFrom(scratchArc));
                        if (!scratchArc.isLast()) {
                            map.readNextRealArc(scratchArc, fstReader);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class Builder {
        private final Map<String, String> pendingPairs = new TreeMap<String, String>();

        public void add(String match, String replacement) {
            if (match.length() == 0) {
                throw new IllegalArgumentException("cannot match the empty string");
            }
            if (this.pendingPairs.putIfAbsent(match, replacement) != null) {
                throw new IllegalArgumentException("match \"" + match + "\" was already added");
            }
        }

        public NormalizeCharMap build() {
            FST map;
            try {
                CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
                FSTCompiler fstCompiler = new FSTCompiler(FST.INPUT_TYPE.BYTE2, (Outputs)outputs);
                IntsRefBuilder scratch = new IntsRefBuilder();
                for (Map.Entry<String, String> ent : this.pendingPairs.entrySet()) {
                    fstCompiler.add(Util.toUTF16((CharSequence)ent.getKey(), (IntsRefBuilder)scratch), (Object)new CharsRef(ent.getValue()));
                }
                map = fstCompiler.compile();
                this.pendingPairs.clear();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return new NormalizeCharMap((FST<CharsRef>)map);
        }
    }
}

