/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.StructureHelper;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;

public class BlockArchitectureHelper {
    private static BlockArchitectureHelper instance;

    private BlockArchitectureHelper() {
    }

    public static BlockArchitectureHelper getInstance() {
        if (instance == null) {
            instance = new BlockArchitectureHelper();
        }
        return instance;
    }

    public Object doSwitch(BlockArchitecture element, EStructuralFeature feature) {
        Component ret = null;
        if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__ALLOCATED_ARCHITECTURES)) {
            ret = this.getAllocatedArchitectures(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__ALLOCATING_ARCHITECTURES)) {
            ret = this.getAllocatingArchitectures(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__PROVISIONED_ARCHITECTURE_ALLOCATIONS)) {
            ret = this.getProvisionedArchitectureAllocations(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__PROVISIONING_ARCHITECTURE_ALLOCATIONS)) {
            ret = this.getProvisioningArchitectureAllocations(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__SYSTEM)) {
            ret = this.getSystem(element);
        }
        if (ret == null) {
            ret = StructureHelper.getInstance().doSwitch((Structure)element, feature);
        }
        return ret;
    }

    protected List<ArchitectureAllocation> getProvisionedArchitectureAllocations(BlockArchitecture element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<ArchitectureAllocation> ret = new ArrayList<ArchitectureAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof ArchitectureAllocation)) continue;
            ret.add((ArchitectureAllocation)trace);
        }
        return ret;
    }

    protected List<ArchitectureAllocation> getProvisioningArchitectureAllocations(BlockArchitecture element) {
        EList traces = element.getIncomingTraces();
        ArrayList<ArchitectureAllocation> ret = new ArrayList<ArchitectureAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof ArchitectureAllocation)) continue;
            ret.add((ArchitectureAllocation)trace);
        }
        return ret;
    }

    protected List<BlockArchitecture> getAllocatedArchitectures(BlockArchitecture element) {
        EList allocs = element.getProvisionedArchitectureAllocations();
        ArrayList<BlockArchitecture> ret = new ArrayList<BlockArchitecture>();
        for (ArchitectureAllocation architectureAllocation : allocs) {
            BlockArchitecture allocatedArchitecture = architectureAllocation.getAllocatedArchitecture();
            if (allocatedArchitecture == null) continue;
            ret.add(allocatedArchitecture);
        }
        return ret;
    }

    protected List<BlockArchitecture> getAllocatingArchitectures(BlockArchitecture element) {
        EList allocs = element.getProvisioningArchitectureAllocations();
        ArrayList<BlockArchitecture> ret = new ArrayList<BlockArchitecture>();
        for (ArchitectureAllocation architectureAllocation : allocs) {
            BlockArchitecture allocatingArchitecture = architectureAllocation.getAllocatingArchitecture();
            if (allocatingArchitecture == null) continue;
            ret.add(allocatingArchitecture);
        }
        return ret;
    }

    protected Component getSystem(BlockArchitecture architecture) {
        ConfigurationItemPkg ownedConfigurationItemPkg;
        if (architecture instanceof SystemAnalysis) {
            SystemComponentPkg ownedSystemComponentPkg = ((SystemAnalysis)architecture).getOwnedSystemComponentPkg();
            if (ownedSystemComponentPkg != null && !ownedSystemComponentPkg.getOwnedSystemComponents().isEmpty()) {
                return ownedSystemComponentPkg.getOwnedSystemComponents().stream().filter(x -> !x.isActor()).findFirst().orElse(null);
            }
        } else if (architecture instanceof LogicalArchitecture) {
            LogicalComponentPkg ownedLogicalComponentPkg = ((LogicalArchitecture)architecture).getOwnedLogicalComponentPkg();
            if (ownedLogicalComponentPkg != null && !ownedLogicalComponentPkg.getOwnedLogicalComponents().isEmpty()) {
                return ownedLogicalComponentPkg.getOwnedLogicalComponents().stream().filter(x -> !x.isActor()).findFirst().orElse(null);
            }
        } else if (architecture instanceof PhysicalArchitecture) {
            PhysicalComponentPkg ownedPhysicalComponentPkg = ((PhysicalArchitecture)architecture).getOwnedPhysicalComponentPkg();
            if (ownedPhysicalComponentPkg != null && !ownedPhysicalComponentPkg.getOwnedPhysicalComponents().isEmpty()) {
                return ownedPhysicalComponentPkg.getOwnedPhysicalComponents().stream().filter(x -> !x.isActor()).findFirst().orElse(null);
            }
        } else if (architecture instanceof EPBSArchitecture && (ownedConfigurationItemPkg = ((EPBSArchitecture)architecture).getOwnedConfigurationItemPkg()) != null && !ownedConfigurationItemPkg.getOwnedConfigurationItems().isEmpty()) {
            return ownedConfigurationItemPkg.getOwnedConfigurationItems().stream().filter(x -> !x.isActor()).findFirst().orElse(null);
        }
        return null;
    }
}

