/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.activity.ActivityExchange;
import org.polarsys.capella.common.data.helpers.activity.delegates.ActivityExchangeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.ExchangeContainment;
import org.polarsys.capella.core.data.fa.ExchangeLink;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.ExchangeSpecificationRealization;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;

public class ExchangeSpecificationHelper {
    private static ExchangeSpecificationHelper instance;

    private ExchangeSpecificationHelper() {
    }

    public static ExchangeSpecificationHelper getInstance() {
        if (instance == null) {
            instance = new ExchangeSpecificationHelper();
        }
        return instance;
    }

    public Object doSwitch(ExchangeSpecification element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.EXCHANGE_SPECIFICATION__CONTAINING_LINK)) {
            ret = this.getContainingLink(element);
        } else if (feature.equals(FaPackage.Literals.EXCHANGE_SPECIFICATION__INCOMING_EXCHANGE_SPECIFICATION_REALIZATIONS)) {
            ret = this.getIncomingExchangeSpecificationRealizations(element);
        } else if (feature.equals(FaPackage.Literals.EXCHANGE_SPECIFICATION__OUTGOING_EXCHANGE_SPECIFICATION_REALIZATIONS)) {
            ret = this.getOutgoingExchangeSpecificationRealizations(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = ActivityExchangeHelper.getInstance().doSwitch((ActivityExchange)element, feature);
        }
        return ret;
    }

    protected List<ExchangeSpecificationRealization> getIncomingExchangeSpecificationRealizations(ExchangeSpecification element) {
        ArrayList<ExchangeSpecificationRealization> ret = new ArrayList<ExchangeSpecificationRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof ExchangeSpecificationRealization)) continue;
            ret.add((ExchangeSpecificationRealization)trace);
        }
        return ret;
    }

    protected List<ExchangeSpecificationRealization> getOutgoingExchangeSpecificationRealizations(ExchangeSpecification element) {
        ArrayList<ExchangeSpecificationRealization> ret = new ArrayList<ExchangeSpecificationRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof ExchangeSpecificationRealization)) continue;
            ret.add((ExchangeSpecificationRealization)trace);
        }
        return ret;
    }

    protected ExchangeLink getContainingLink(ExchangeSpecification element) {
        ExchangeContainment cont = element.getLink();
        if (cont != null) {
            return cont.getLink();
        }
        return null;
    }
}

