/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.MessageKind;

public class LinkCompatibilityDefinition {
    private static final CommunicationLinkProtocol UNSET = CommunicationLinkProtocol.UNSET;
    private static final CommunicationLinkProtocol SYNCHRONOUS = CommunicationLinkProtocol.SYNCHRONOUS;
    private static final CommunicationLinkProtocol ASYNCHRONOUS = CommunicationLinkProtocol.ASYNCHRONOUS;
    private static final CommunicationLinkProtocol UNICAST = CommunicationLinkProtocol.UNICAST;
    private static final CommunicationLinkProtocol MULTICAST = CommunicationLinkProtocol.MULTICAST;
    private static final CommunicationLinkProtocol BROADCAST = CommunicationLinkProtocol.BROADCAST;
    private static final CommunicationLinkProtocol ACCEPT = CommunicationLinkProtocol.ACCEPT;
    private static final CommunicationLinkProtocol READ = CommunicationLinkProtocol.READ;
    public static final int SENDER_ID = 0;
    public static final int RECEIVER_ID = 1;
    private static final String SENDER = Integer.toString(0);
    private static final String RECEIVER = Integer.toString(1);
    private static final boolean WITH_RETURN = true;
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_UNSET_____SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_UNSET_____SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_UNSET_____ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_UNSET_____ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_UNSET_____ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_UNSET_____ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_EVENT_____SYNCHRONOUS__WITH____RETURN = Arrays.asList(new CommunicationLinkProtocol[0]);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_EVENT_____SYNCHRONOUS__WITH____RETURN = Arrays.asList(new CommunicationLinkProtocol[0]);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_EVENT_____ASYNCHRONOUS_WITH____RETURN = Arrays.asList(new CommunicationLinkProtocol[0]);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_EVENT_____ASYNCHRONOUS_WITH____RETURN = Arrays.asList(new CommunicationLinkProtocol[0]);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_EVENT_____ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNICAST, MULTICAST, BROADCAST, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_EVENT_____ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_FLOW______SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_FLOW______SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_FLOW______ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_FLOW______ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_FLOW______ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_FLOW______ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_OPERATION_SYNCHRONOUS__WITH____RETURN = Arrays.asList(SYNCHRONOUS, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_OPERATION_SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_OPERATION_ASYNCHRONOUS_WITH____RETURN = Arrays.asList(ASYNCHRONOUS, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_OPERATION_ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_OPERATION_ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(ASYNCHRONOUS, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_OPERATION_ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_DATA______SYNCHRONOUS__WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_DATA______SYNCHRONOUS__WITH____RETURN = Arrays.asList(READ, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_DATA______ASYNCHRONOUS_WITH____RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_DATA______ASYNCHRONOUS_WITH____RETURN = Arrays.asList(ACCEPT, UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_SENDER___FOR_DATA______ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(UNSET);
    private static final List<CommunicationLinkProtocol> COMPATIBLE_RECEIVER_FOR_DATA______ASYNCHRONOUS_WITHOUT_RETURN = Arrays.asList(ACCEPT, UNSET);
    private static final List<ExchangeMechanism> COMPATIBLE_EXCHANGE_MECHANISM_FOR_WITH_RETURN = Arrays.asList(ExchangeMechanism.OPERATION, ExchangeMechanism.UNSET, ExchangeMechanism.FLOW, ExchangeMechanism.SHARED_DATA);
    private static final List<ExchangeMechanism> COMPATIBLE_EXCHANGE_MECHANISM_FOR_WITHOUT_RETURN = Arrays.asList(ExchangeMechanism.OPERATION, ExchangeMechanism.UNSET, ExchangeMechanism.EVENT, ExchangeMechanism.FLOW, ExchangeMechanism.SHARED_DATA);
    protected Hashtable<ExchangeMechanism, List<CommunicationLinkKind>> mechanismKind = new Hashtable();
    protected Hashtable<CommunicationLinkKind, List<CommunicationLinkProtocol>> kindProtocol;
    protected Hashtable<String, List<CommunicationLinkProtocol>> compatibilityTable;
    public static final LinkCompatibilityDefinition INSTANCE = new LinkCompatibilityDefinition();

    public List<CommunicationLinkKind> getKinds(ExchangeMechanism mechanism) {
        return new ArrayList<CommunicationLinkKind>((Collection)this.mechanismKind.get(mechanism));
    }

    public CommunicationLinkKind getKind(ExchangeMechanism mechanism, boolean isSender) {
        if (mechanism != null) {
            if (isSender) {
                return this.mechanismKind.get(mechanism).get(0);
            }
            return this.mechanismKind.get(mechanism).get(1);
        }
        return CommunicationLinkKind.UNSET;
    }

    public ExchangeMechanism getMechanism(CommunicationLinkKind kind) {
        for (Map.Entry<ExchangeMechanism, List<CommunicationLinkKind>> entry : this.mechanismKind.entrySet()) {
            if (!entry.getValue().contains(kind)) continue;
            return entry.getKey();
        }
        return ExchangeMechanism.UNSET;
    }

    public Collection<CommunicationLinkProtocol> getCompatibleReceiveProtocols(ExchangeItemAllocation allocation) {
        return this.getCompatibleProtocols(allocation, false);
    }

    public Collection<CommunicationLinkProtocol> getCompatibleSendProtocols(ExchangeItemAllocation allocation) {
        return this.getCompatibleProtocols(allocation, true);
    }

    private Collection<CommunicationLinkProtocol> getCompatibleProtocols(ExchangeItemAllocation allocation, boolean isSender) {
        ExchangeMechanism mechanism = allocation.getAllocatedItem().getExchangeMechanism();
        CommunicationLinkKind expectedKind = INSTANCE.getKind(mechanism, isSender);
        return INSTANCE.getCompatibleProtocols(expectedKind);
    }

    public Collection<CommunicationLinkProtocol> getCompatibleProtocols(CommunicationLinkKind kind) {
        return this.kindProtocol.get(kind);
    }

    public CommunicationLinkKind getKind(CommunicationLinkProtocol protocol) {
        for (Map.Entry<CommunicationLinkKind, List<CommunicationLinkProtocol>> entry : this.kindProtocol.entrySet()) {
            if (!entry.getValue().contains(protocol)) continue;
            return entry.getKey();
        }
        return CommunicationLinkKind.UNSET;
    }

    public LinkCompatibilityDefinition() {
        this.mechanismKind.put(ExchangeMechanism.FLOW, Arrays.asList(CommunicationLinkKind.PRODUCE, CommunicationLinkKind.CONSUME));
        this.mechanismKind.put(ExchangeMechanism.EVENT, Arrays.asList(CommunicationLinkKind.SEND, CommunicationLinkKind.RECEIVE));
        this.mechanismKind.put(ExchangeMechanism.OPERATION, Arrays.asList(CommunicationLinkKind.CALL, CommunicationLinkKind.EXECUTE));
        this.mechanismKind.put(ExchangeMechanism.SHARED_DATA, Arrays.asList(CommunicationLinkKind.WRITE, CommunicationLinkKind.ACCESS));
        this.mechanismKind.put(ExchangeMechanism.UNSET, Arrays.asList(CommunicationLinkKind.TRANSMIT, CommunicationLinkKind.ACQUIRE));
        this.kindProtocol = new Hashtable();
        this.kindProtocol.put(CommunicationLinkKind.SEND, Arrays.asList(CommunicationLinkProtocol.UNICAST, CommunicationLinkProtocol.BROADCAST, CommunicationLinkProtocol.MULTICAST, CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.CALL, Arrays.asList(CommunicationLinkProtocol.ASYNCHRONOUS, CommunicationLinkProtocol.SYNCHRONOUS, CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.ACCESS, Arrays.asList(CommunicationLinkProtocol.READ, CommunicationLinkProtocol.ACCEPT, CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.ACQUIRE, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.CONSUME, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.EXECUTE, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.PRODUCE, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.RECEIVE, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.TRANSMIT, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.WRITE, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.kindProtocol.put(CommunicationLinkKind.UNSET, Arrays.asList(CommunicationLinkProtocol.UNSET));
        this.compatibilityTable = new Hashtable();
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_UNSET_____SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_UNSET_____SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_UNSET_____ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_UNSET_____ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_SENDER___FOR_UNSET_____ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.UNSET) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_RECEIVER_FOR_UNSET_____ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_EVENT_____SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_EVENT_____SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_EVENT_____ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_EVENT_____ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_SENDER___FOR_EVENT_____ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.EVENT) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_RECEIVER_FOR_EVENT_____ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_FLOW______SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_FLOW______SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_FLOW______ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_FLOW______ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_SENDER___FOR_FLOW______ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.FLOW) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_RECEIVER_FOR_FLOW______ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_OPERATION_SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_OPERATION_SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_OPERATION_ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_OPERATION_ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_SENDER___FOR_OPERATION_ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.OPERATION) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_RECEIVER_FOR_OPERATION_ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_DATA______SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.SYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_DATA______SYNCHRONOUS__WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_SENDER___FOR_DATA______ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "true", COMPATIBLE_RECEIVER_FOR_DATA______ASYNCHRONOUS_WITH____RETURN);
        this.compatibilityTable.put(SENDER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_SENDER___FOR_DATA______ASYNCHRONOUS_WITHOUT_RETURN);
        this.compatibilityTable.put(RECEIVER + String.valueOf(ExchangeMechanism.SHARED_DATA) + String.valueOf(MessageKind.ASYNCHRONOUS_CALL) + "false", COMPATIBLE_RECEIVER_FOR_DATA______ASYNCHRONOUS_WITHOUT_RETURN);
    }

    public boolean isCompatible(ExchangeMechanism mechanism, CommunicationLinkProtocol senderProtocol, CommunicationLinkProtocol receiverProtocol, MessageKind messageKind, boolean withReturn) {
        String tableKey = mechanism.toString() + String.valueOf(messageKind) + withReturn;
        boolean compatible = true;
        if (senderProtocol != null) {
            List<CommunicationLinkProtocol> possibleSenderProtocols = this.compatibilityTable.get(SENDER + tableKey);
            boolean bl = compatible = possibleSenderProtocols != null ? possibleSenderProtocols.contains(senderProtocol) : false;
        }
        if (compatible && receiverProtocol != null) {
            List<CommunicationLinkProtocol> possibleReceiverProtocols = this.compatibilityTable.get(RECEIVER + tableKey);
            compatible = possibleReceiverProtocols != null ? possibleReceiverProtocols.contains(receiverProtocol) : false;
        }
        return compatible;
    }

    public boolean isCompatible(ExchangeItem item, MessageKind messageProtocol, boolean withReturn) {
        ExchangeMechanism mechanism = item.getExchangeMechanism();
        if (mechanism == ExchangeMechanism.UNSET) {
            return false;
        }
        if (mechanism == ExchangeMechanism.EVENT && messageProtocol == MessageKind.ASYNCHRONOUS_CALL && !withReturn) {
            return true;
        }
        if (mechanism == ExchangeMechanism.FLOW) {
            return true;
        }
        if (mechanism == ExchangeMechanism.OPERATION) {
            return true;
        }
        return mechanism == ExchangeMechanism.SHARED_DATA;
    }

    public List<CommunicationLinkProtocol> getCompatibleProtocols(boolean protocolIsSender, ExchangeMechanism mechanism, MessageKind messageKind, boolean withReturn) {
        String tableKey;
        List<CommunicationLinkProtocol> possibleProtocols;
        String protocolDirection = RECEIVER;
        if (protocolIsSender) {
            protocolDirection = SENDER;
        }
        if ((possibleProtocols = this.compatibilityTable.get(protocolDirection + (tableKey = mechanism.toString() + String.valueOf(messageKind) + withReturn))) == null) {
            possibleProtocols = new ArrayList<CommunicationLinkProtocol>();
        }
        return possibleProtocols;
    }

    public CommunicationLinkProtocol getCompatibleProtocol(boolean protocolIsSender, ExchangeMechanism mechanism, MessageKind messageKind, boolean withReturn) {
        String protocolDirection = RECEIVER;
        if (protocolIsSender) {
            protocolDirection = SENDER;
        }
        String tableKey = mechanism.toString() + String.valueOf(messageKind) + withReturn;
        List<CommunicationLinkProtocol> possibleProtocols = this.compatibilityTable.get(protocolDirection + tableKey);
        CommunicationLinkProtocol protocol = null;
        if (possibleProtocols != null) {
            int i = 0;
            while (i < possibleProtocols.size()) {
                protocol = possibleProtocols.get(i);
                if (protocol != UNSET) {
                    return protocol;
                }
                ++i;
            }
        }
        return protocol;
    }

    public List<ExchangeMechanism> getCompatibleExchangeMechanismFor(boolean withReturn) {
        if (withReturn) {
            return COMPATIBLE_EXCHANGE_MECHANISM_FOR_WITH_RETURN;
        }
        return COMPATIBLE_EXCHANGE_MECHANISM_FOR_WITHOUT_RETURN;
    }

    public boolean isDefaultKind(CommunicationLinkKind kind) {
        return kind == CommunicationLinkKind.TRANSMIT || kind == CommunicationLinkKind.ACQUIRE;
    }
}

