/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.interaction.services;

import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class MessageEndExt {
    public static COMPONENT_TYPE getMessageEndType(MessageEnd msg) {
        COMPONENT_TYPE type = COMPONENT_TYPE.UNDEFINED;
        SequenceMessage seqMsg = msg.getMessage();
        if (seqMsg != null) {
            if (seqMsg.getReceivingEnd() == msg) {
                type = COMPONENT_TYPE.RECEIVER;
            } else if (seqMsg.getSendingEnd() == msg) {
                type = COMPONENT_TYPE.SENDER;
            }
        }
        return type;
    }

    public static MessageEnd getOppositeMessageEnd(MessageEnd msg) {
        MessageEnd msgEnd = null;
        SequenceMessage seqMsg = msg.getMessage();
        if (seqMsg != null) {
            if (seqMsg.getReceivingEnd() == msg) {
                msgEnd = seqMsg.getSendingEnd();
            } else if (seqMsg.getSendingEnd() == msg) {
                msgEnd = seqMsg.getReceivingEnd();
            }
        }
        return msgEnd;
    }

    public static AbstractEventOperation getOperation(MessageEnd msg) {
        AbstractEventOperation op = null;
        COMPONENT_TYPE type = MessageEndExt.getMessageEndType(msg);
        Event evt = msg.getEvent();
        if (evt != null) {
            switch (type) {
                case RECEIVER: {
                    Event event = msg.getEvent();
                    if (!(event instanceof EventReceiptOperation)) break;
                    EventReceiptOperation evtOp = (EventReceiptOperation)evt;
                    op = evtOp.getOperation();
                    break;
                }
                case SENDER: {
                    Event event = msg.getEvent();
                    if (!(event instanceof EventSentOperation)) break;
                    EventSentOperation evtOp = (EventSentOperation)evt;
                    op = evtOp.getOperation();
                }
            }
        }
        return op;
    }

    public static enum COMPONENT_TYPE {
        UNDEFINED,
        SENDER,
        RECEIVER;

    }
}

