/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.delegates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacommon.delegates.CapabilityRealizationInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPhysicalArtifactHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.DeployableElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.DeploymentTargetHelper;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class PhysicalComponentHelper {
    private static PhysicalComponentHelper instance;

    private PhysicalComponentHelper() {
    }

    public static PhysicalComponentHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalComponent element, EStructuralFeature feature) {
        List<PhysicalComponent> ret = null;
        if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__SUB_PHYSICAL_COMPONENTS)) {
            ret = this.getSubPhysicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__LOGICAL_INTERFACE_REALIZATIONS)) {
            ret = this.getLogicalInterfaceRealizations(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__REALIZED_LOGICAL_COMPONENTS)) {
            ret = this.getRealizedLogicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__ALLOCATED_PHYSICAL_FUNCTIONS)) {
            ret = this.getAllocatedPhysicalFunctions(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__DEPLOYED_PHYSICAL_COMPONENTS)) {
            ret = this.getDeployedPhysicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_COMPONENT__DEPLOYING_PHYSICAL_COMPONENTS)) {
            ret = this.getDeployingPhysicalComponents(element);
        }
        if (ret == null) {
            ret = AbstractPhysicalArtifactHelper.getInstance().doSwitch((AbstractPhysicalArtifact)element, feature);
        }
        if (ret == null) {
            ret = ComponentHelper.getInstance().doSwitch((Component)element, feature);
        }
        if (ret == null) {
            ret = CapabilityRealizationInvolvedElementHelper.getInstance().doSwitch((CapabilityRealizationInvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = DeployableElementHelper.getInstance().doSwitch((DeployableElement)element, feature);
        }
        if (ret == null) {
            ret = DeploymentTargetHelper.getInstance().doSwitch((DeploymentTarget)element, feature);
        }
        return ret;
    }

    protected List<LogicalInterfaceRealization> getLogicalInterfaceRealizations(PhysicalComponent element) {
        ArrayList<LogicalInterfaceRealization> ret = new ArrayList<LogicalInterfaceRealization>();
        for (InterfaceAllocation componentAllocation : element.getProvisionedInterfaceAllocations()) {
            if (!(componentAllocation instanceof LogicalInterfaceRealization)) continue;
            ret.add((LogicalInterfaceRealization)componentAllocation);
        }
        return ret;
    }

    protected List<PhysicalComponent> getSubPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (Feature feature : element.getOwnedFeatures()) {
            Type type;
            if (!(feature instanceof Part) || (type = ((Part)feature).getType()) == null || !type.eClass().equals(PaPackage.Literals.PHYSICAL_COMPONENT)) continue;
            ret.add((PhysicalComponent)type);
        }
        return ret;
    }

    protected List<LogicalComponent> getRealizedLogicalComponents(PhysicalComponent element) {
        return element.getRealizedComponents().stream().filter(LogicalComponent.class::isInstance).map(LogicalComponent.class::cast).collect(Collectors.toList());
    }

    protected List<PhysicalFunction> getAllocatedPhysicalFunctions(PhysicalComponent element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalComponent> getDeployedPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deploymentLink : ((Part)obj).getDeploymentLinks()) {
                AbstractType type;
                DeployableElement deployableElement = deploymentLink.getDeployedElement();
                if (deployableElement instanceof PhysicalComponent) {
                    ret.add((PhysicalComponent)deployableElement);
                    continue;
                }
                if (!(deployableElement instanceof Part) || !((type = ((Part)deployableElement).getAbstractType()) instanceof PhysicalComponent)) continue;
                ret.add((PhysicalComponent)type);
            }
        }
        return ret;
    }

    protected List<PhysicalComponent> getDeployingPhysicalComponents(PhysicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(obj instanceof Part)) continue;
            for (AbstractDeploymentLink deployingLink : ((Part)obj).getDeployingLinks()) {
                AbstractType type;
                DeploymentTarget deploymentTarget = deployingLink.getLocation();
                if (deploymentTarget instanceof PhysicalComponent) {
                    ret.add((PhysicalComponent)deploymentTarget);
                    continue;
                }
                if (!(deploymentTarget instanceof Part) || !((type = ((Part)deploymentTarget).getAbstractType()) instanceof PhysicalComponent)) continue;
                ret.add((PhysicalComponent)type);
            }
        }
        return ret;
    }
}

