/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;
import org.polarsys.capella.core.ui.toolkit.AbstractCommandActionHandler;
import org.polarsys.kitalpha.emde.model.Element;

public class CapellaDeleteAction
extends AbstractCommandActionHandler
implements IPropertyChangeListener {
    public CapellaDeleteAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
        CapellaActionsActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Command createCommand(Collection<Object> selection) {
        CapellaDeleteCommand command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((Collection)this.filterSelection(selection)), selection);
        command.setPreventProtectedElementsDeletion(true);
        return command;
    }

    public void dispose() {
        CapellaActionsActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("Delete_Protected_Elements") || property.equals("Confirm_Delete")) {
            this.setEnabled(this.updateSelection(this.getStructuredSelection()));
        }
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.CapellaDeleteCommand_Label, -1);
                CapellaDeleteAction.this.getCommand().execute();
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, runnable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean canDelete(Collection<?> selectedElements) {
        if (selectedElements.isEmpty()) {
            return false;
        }
        return selectedElements.stream().filter(Element.class::isInstance).map(Element.class::cast).noneMatch(CapellaDeleteAction::isElementProtected);
    }

    public static boolean isElementProtected(Element element) {
        boolean specialElementProtectionAllowed = CapellaModelPreferencesPlugin.getDefault().isSpecialElementProtectionAllowed();
        if (specialElementProtectionAllowed) {
            AbstractType type;
            if (element instanceof Component) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
                return architecture != null && element.equals(architecture.getSystem());
            }
            if (element instanceof FunctionPkg || element instanceof AbstractCapabilityPkg || element instanceof ComponentPkg || element instanceof InterfacePkg || element instanceof DataPkg || element instanceof RolePkg || element instanceof MissionPkg) {
                return element.eContainer() instanceof BlockArchitecture;
            }
            if (element instanceof AbstractFunction) {
                return EcoreUtil2.isContainedBy((EObject)element, (EClass)OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG) && !EcoreUtil2.isContainedBy((EObject)element, (EClass)OaPackage.Literals.OPERATIONAL_ACTIVITY) || EcoreUtil2.isContainedBy((EObject)element, (EClass)CtxPackage.Literals.SYSTEM_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)element, (EClass)CtxPackage.Literals.SYSTEM_FUNCTION) || EcoreUtil2.isContainedBy((EObject)element, (EClass)LaPackage.Literals.LOGICAL_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)element, (EClass)LaPackage.Literals.LOGICAL_FUNCTION) || EcoreUtil2.isContainedBy((EObject)element, (EClass)PaPackage.Literals.PHYSICAL_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)element, (EClass)PaPackage.Literals.PHYSICAL_FUNCTION);
            }
            if (element instanceof Part && (type = ((Part)element).getAbstractType()) != null) {
                return CapellaDeleteAction.isElementProtected((Element)type);
            }
            return element instanceof Project || element instanceof SystemEngineering || element instanceof BlockArchitecture || element instanceof ModelInformation;
        }
        return false;
    }
}

