/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public abstract class AbstractFixCommand
extends AbstractReadWriteCommand {
    protected static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
    protected Collection<ModelElement> selection = null;
    private IProgressMonitor progressMonitor = null;

    public AbstractFixCommand(Collection<ModelElement> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractFixCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor) {
        this.selection = selection;
        this.progressMonitor = progressMonitor;
    }

    protected Collection<ModelElement> retrieveModelElements(ModelElement modelElement) {
        return Collections.singleton(modelElement);
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            for (ModelElement selectedElement : this.selection) {
                Collection<ModelElement> elements = this.retrieveModelElements(selectedElement);
                this.progressMonitor.beginTask(this.getName(), elements.size());
                boolean elementProcessed = false;
                for (ModelElement element : elements) {
                    elementProcessed |= this.process(element);
                    this.progressMonitor.worked(1);
                }
                if (elementProcessed) continue;
                String message = this.getName() + " command has faild to process the elements " + (elements.isEmpty() ? "" : elements.toString());
                EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), (Object)elements.toString());
                logger.info((Object)eMessage);
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }

    protected abstract boolean process(ModelElement var1);
}

