/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class CapellaCloneDiagramCommand
extends AbstractCommand {
    private Collection<DRepresentationDescriptor> _descriptors = new ArrayList<DRepresentationDescriptor>();
    private Collection<DRepresentationDescriptor> _clones;
    private Collection<ICloneListener> _listeners;

    public CapellaCloneDiagramCommand(Collection<DRepresentationDescriptor> descriptors) {
        super(Messages.CapellaCloneDiagramCommand_CommandLabel);
        this._descriptors.addAll(descriptors);
    }

    public void dispose() {
        super.dispose();
        if (this._clones != null) {
            this._clones.clear();
            this._clones = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
        if (this._descriptors != null) {
            this._descriptors = null;
        }
    }

    public void addCloneListener(ICloneListener listener) {
        if (listener == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new HashSet<ICloneListener>(1);
        }
        this._listeners.add(listener);
    }

    public void removeCloneListener(ICloneListener listener) {
        if (this._listeners == null || listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    protected void notifyListeners(EventType type, DRepresentation clone, Session session) {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ArrayList<ICloneListener> listeners = new ArrayList<ICloneListener>(this._listeners);
        for (ICloneListener listener : listeners) {
            try {
                if (EventType.ADD.equals((Object)type)) {
                    listener.cloneCreated(clone, session);
                    continue;
                }
                if (!EventType.REMOVE.equals((Object)type)) continue;
                listener.cloneAboutToBeRemoved(clone, session);
            }
            catch (Exception exception) {
                CapellaActionsActivator activator = CapellaActionsActivator.getDefault();
                activator.getLog().log((IStatus)new Status(4, activator.getPluginId(), "Unable to notify listeners !", (Throwable)exception));
            }
        }
    }

    public boolean canUndo() {
        return this._clones != null && this._clones.size() > 0;
    }

    public void execute() {
        if (this._clones == null) {
            this._clones = new ArrayList<DRepresentationDescriptor>(0);
        } else if (this._clones.size() > 0) {
            this._clones.clear();
        }
        for (DRepresentationDescriptor descriptor : this._descriptors) {
            DRepresentation copyRepresentation;
            Collection results = SiriusCopierHelper.copyAllWithNoUidDuplication((Collection)descriptor.getEAnnotations());
            EObject target = descriptor.getTarget();
            Session session = SessionManager.INSTANCE.getSession(target);
            DRepresentationDescriptor copyRepresentationDescriptor = RepresentationHelper.getRepresentationDescriptor((Session)session, (DRepresentation)(copyRepresentation = DialectManager.INSTANCE.copyRepresentation(descriptor, this.getCloneName(descriptor, session), session, null)));
            if (copyRepresentationDescriptor == null) continue;
            copyRepresentationDescriptor.getEAnnotations().addAll(results);
            this._clones.add(copyRepresentationDescriptor);
        }
    }

    protected String getCloneName(DRepresentationDescriptor representation, Session session) {
        String message = Messages.CapellaCloneDiagramCommand_CloneName_Prefix;
        String cloneName = StringHelper.formatMessage((String)message, (Object[])new Object[]{"", representation.getName()});
        boolean cloneNameFound = false;
        Collection allDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        int i = 1;
        while (!cloneNameFound) {
            boolean collision = false;
            for (DRepresentationDescriptor rep : allDescriptors) {
                if (!cloneName.equals(rep.getName())) continue;
                collision = true;
                break;
            }
            if (collision) {
                cloneName = StringHelper.formatMessage((String)message, (Object[])new Object[]{++i + " ", representation.getName()});
            }
            boolean bl = cloneNameFound = !collision;
        }
        return cloneName;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (DRepresentationDescriptor descriptor : this._clones) {
            Session session = SessionManager.INSTANCE.getSession(descriptor.getTarget());
            DialectManager.INSTANCE.deleteRepresentation(descriptor, session);
        }
        this._clones.clear();
    }

    public Collection<DRepresentationDescriptor> getResult() {
        return this._clones;
    }

    protected static enum EventType {
        ADD,
        REMOVE;

    }

    public static interface ICloneListener {
        public void cloneCreated(DRepresentation var1, Session var2);

        public void cloneAboutToBeRemoved(DRepresentation var1, Session var2);
    }
}

