/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.handlers;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.shared.id.handler.IdManager;

public class CopyUniqueIdentifierHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String allUniqueIds = this.getSelectionAsText(event);
        if (!allUniqueIds.isBlank()) {
            Clipboard c = new Clipboard(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell().getDisplay());
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{allUniqueIds};
            c.setContents(data, transfers);
            c.dispose();
        }
        return null;
    }

    public String getSelectionAsText(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            String allUniqueIds = Arrays.stream(structuredSelection.toArray()).map(this::getUniqueId).collect(Collectors.joining(ICommonConstants.LINE_SEPARATOR));
            return allUniqueIds;
        }
        return "";
    }

    private String getUniqueId(Object element) {
        String uniqueId = "";
        EObject object = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)element);
        if (object != null) {
            return IdManager.getInstance().getId(object);
        }
        return uniqueId;
    }
}

