/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.ReloadingPolicyImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.ui.session.GitConflictHelper;
import org.polarsys.capella.core.platform.sirius.ui.session.Messages;

public class GitReloadingPolicy
extends ReloadingPolicyImpl {
    public GitReloadingPolicy(UICallBack callBack) {
        super(callBack);
    }

    public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        if (newStatus == ResourceSetSync.ResourceStatus.EXTERNAL_CHANGED) {
            ArrayList<ReloadingPolicy.Action> result = new ArrayList<ReloadingPolicy.Action>();
            Set<IFile> filesInConflict = GitConflictHelper.getFilesInConflict(session);
            if (!filesInConflict.isEmpty()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(() -> {
                    if (MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)Messages.GitConflictSessionListener_DialogTitle, (String)NLS.bind((String)Messages.GitConflictSessionListener_ResourcesInConflictState, (Object)filesInConflict.stream().map(IFile::getName).collect(Collectors.joining(", "))))) {
                        result.add(ReloadingPolicy.Action.CLOSE_SESSION);
                    }
                });
                return result;
            }
        }
        return super.getActions(session, resource, newStatus);
    }
}

