/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.properties.controllers.DataFlowHelper;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceHelper;
import org.polarsys.capella.core.data.interaction.properties.dialogs.SelectFunctionalExchangeDialog;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.SelectInvokedOperationModel;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.SelectInvokedOperationModelForSharedDataAndEvent;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationController;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationView;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectOperationDialogForSharedDataAndEvent;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.ui.toolkit.helpers.Messages;

public class DialogProvider {
    public static final String FUNCTIONAL_EXCHANGE_FUNCTION = "FEF";
    public static final String FUNCTIONAL_EXCHANGE_TYPE = "FE";
    public static final String COMPONENT_EXCHANGE_TYPE = "CE";
    private static boolean portStrategie;

    public static boolean getPortStrategie() {
        return portStrategie;
    }

    public static EObject openOperationDialog(SequenceMessage message) {
        InstanceRole source = message.getSendingEnd().getCovered();
        InstanceRole target = message.getReceivingEnd().getCovered();
        return DialogProvider.openOperationDialog(message, source, target, null, message.getKind());
    }

    public static EObject openOperationDialog(SequenceMessage message, InstanceRole sourceIR, InstanceRole targetIR, Object targetOnExchangeItem, MessageKind messageKind) {
        if (sourceIR.getRepresentedInstance() instanceof ExchangeItemInstance || targetIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
            boolean isSynchronous = messageKind == MessageKind.SYNCHRONOUS_CALL;
            List<CapellaElement> available = SelectInvokedOperationModelForSharedDataAndEvent.getAvailableExchangeItems(sourceIR, targetIR, isSynchronous);
            available.addAll(SelectInvokedOperationModelForSharedDataAndEvent.getRestrictedExchangeItems(sourceIR, targetIR, isSynchronous));
            if (InterfaceHelper.isSharedDataAccess(sourceIR, targetIR)) {
                List<CapellaElement> filtered = InterfaceHelper.getInstance().filterExchangeItemAllocations(available, sourceIR, targetIR, messageKind);
                ArrayList<ExchangeItem> exchangeItemsToRemove = new ArrayList<ExchangeItem>();
                for (EObject eObject : filtered) {
                    ExchangeItemAllocation eia;
                    if (!(eObject instanceof ExchangeItemAllocation) || !filtered.contains((eia = (ExchangeItemAllocation)eObject).getAllocatedItem())) continue;
                    exchangeItemsToRemove.add(eia.getAllocatedItem());
                }
                filtered.removeAll(exchangeItemsToRemove);
                available = filtered;
            }
            List<CapellaElement> whole = InterfaceHelper.getInstance().getAllExchangeItems(sourceIR, targetIR, messageKind);
            SelectOperationDialogForSharedDataAndEvent dialog = new SelectOperationDialogForSharedDataAndEvent(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SelectionDialogHelper_MessageCreation_Title, Messages.AffectToMessage_SelectionOperationDialog_Message, whole, available, sourceIR, targetIR, messageKind, SelectOperationDialogForSharedDataAndEvent.ElementSupportedType.OPERATION);
            if (dialog.open() == 0) {
                if (dialog.getResult().isEmpty()) {
                    return null;
                }
                EObject eObject = (EObject)dialog.getResult().get(0);
                portStrategie = dialog.isPortStrategy();
                return eObject;
            }
        } else {
            boolean withReturn = messageKind == MessageKind.SYNCHRONOUS_CALL;
            SelectInvokedOperationModel model = new SelectInvokedOperationModel(sourceIR, targetIR, withReturn);
            String dialogTitleAddition = model.doesTheMessageReturnAValue() ? " with return" : " without return";
            SelectInvokedOperationController controller = new SelectInvokedOperationController(model);
            SelectInvokedOperationView selectInvokedOperationView = new SelectInvokedOperationView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SelectionDialogHelper_MessageCreation_Title + dialogTitleAddition, Messages.AffectToMessage_SelectionOperationDialog_Message, model, controller);
            if (selectInvokedOperationView.open() == 0 && !selectInvokedOperationView.getResult().isEmpty()) {
                portStrategie = model.doesPortsMustBeCreated();
                return (EObject)selectInvokedOperationView.getResult().get(0);
            }
        }
        return null;
    }

    public static EObject openFunctionalExchangeDialog(SequenceMessage message, InstanceRole sourceIR, InstanceRole targetIR, String echangeType) {
        String selectionExchangeMessage = Messages.AffectToMessage_SelectionExchangeDialog_Message;
        if (sourceIR != null && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)sourceIR)) {
            selectionExchangeMessage = Messages.AffectToMessage_SelectionInteractionDialog_Message;
        } else if (targetIR != null && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)targetIR)) {
            selectionExchangeMessage = Messages.AffectToMessage_SelectionInteractionDialog_Message;
        }
        ArrayList<Object> availableExchanges = new ArrayList<Object>();
        SelectFunctionalExchangeDialog dialog = null;
        if (FUNCTIONAL_EXCHANGE_TYPE.equals(echangeType)) {
            availableExchanges.addAll(DataFlowHelper.getAvailableFonctionalExchanges(sourceIR, targetIR));
            dialog = new SelectFunctionalExchangeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SelectionDialogHelper_MessageCreation_Title, selectionExchangeMessage, availableExchanges, message, sourceIR, targetIR, SelectFunctionalExchangeDialog.DataflowDialogCreationType.FUNCTIONAL_EXCHANGE);
        } else if (COMPONENT_EXCHANGE_TYPE.equals(echangeType)) {
            selectionExchangeMessage = Messages.AffectToMessage_SelectionComponentExchangeDialog_Message;
            if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)(sourceIR != null ? sourceIR : targetIR))) {
                selectionExchangeMessage = Messages.AffectToMessage_SelectionCommunicationMeanDialog_Message;
            }
            availableExchanges.addAll(DataFlowHelper.getAvailableComponentExchanges(sourceIR, targetIR));
            dialog = new SelectFunctionalExchangeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SelectionDialogHelper_MessageCreation_Title, selectionExchangeMessage, availableExchanges, message, sourceIR, targetIR, SelectFunctionalExchangeDialog.DataflowDialogCreationType.COMPONENT_EXCHANGE);
        } else if (FUNCTIONAL_EXCHANGE_FUNCTION.equals(echangeType)) {
            availableExchanges.addAll(DataFlowHelper.getAvailableFonctionalExchangesFromFunctions(sourceIR, targetIR));
            dialog = new SelectFunctionalExchangeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SelectionDialogHelper_MessageCreation_Title, selectionExchangeMessage, availableExchanges, message, sourceIR, targetIR, SelectFunctionalExchangeDialog.DataflowDialogCreationType.FUNCTIONAL_EXCHANGE_SCENARIO);
        }
        if (dialog != null && dialog.open() == 0) {
            if (dialog.getResult().isEmpty()) {
                return null;
            }
            return (EObject)dialog.getResult().get(0);
        }
        return null;
    }

    public static EObject openFunctionalExchangeDialog(SequenceMessage message, String componentExchangeType) {
        InstanceRole source = message.getSendingEnd() != null ? message.getSendingEnd().getCovered() : null;
        InstanceRole target = message.getReceivingEnd() != null ? message.getReceivingEnd().getCovered() : null;
        return DialogProvider.openFunctionalExchangeDialog(message, source, target, componentExchangeType);
    }
}

