/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.sections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.UIUtil;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.properties.Messages;
import org.polarsys.capella.core.data.interaction.properties.fields.InteractionOperatorKindGroup;
import org.polarsys.capella.core.model.helpers.AbstractFragmentExt;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public class CombinedFragmentSection
extends NamedElementSection {
    private MultipleSemanticField coveredInstanceRolesWidget;
    private InteractionOperatorKindGroup interactionOperatorKindGroup;

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        this.namedElementGroup.enableNameField(false);
        Group main = this.getWidgetFactory().createGroup(parent, "");
        main.setLayout((Layout)new GridLayout(6, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        main.setLayoutData((Object)gd);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.interactionOperatorKindGroup = new InteractionOperatorKindGroup(parent, this.getWidgetFactory(), true);
        this.interactionOperatorKindGroup.setDisplayedInWizard(displayedInWizard);
        this.coveredInstanceRolesWidget = new MultipleSemanticField((Composite)main, Messages.getString("CombinedFragmentSection_CoveredInstanceRoles_Label"), this.getWidgetFactory(), new IMultipleSemanticFieldController(){

            public List<EObject> writeOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, List<EObject> values) {
                Set minima = AbstractFragmentExt.getMinimalCoveredInstanceRoles((CombinedFragment)((CombinedFragment)semanticElement));
                for (InstanceRole instanceRole : minima) {
                    if (values.contains(instanceRole)) continue;
                    values.add((EObject)instanceRole);
                    Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
                    __logger.info((Object)new EmbeddedMessage("Unable to remove covered instance role : " + instanceRole.getName(), "Validation"));
                }
                for (InteractionOperand operand : ((CombinedFragment)semanticElement).getReferencedOperands()) {
                    operand.getCoveredInstanceRoles().clear();
                    for (EObject value : values) {
                        operand.getCoveredInstanceRoles().add((Object)((InstanceRole)value));
                    }
                }
                InteractionFragment start = ((CombinedFragment)semanticElement).getStart();
                if (start != null) {
                    start.getCoveredInstanceRoles().clear();
                    for (EObject value : values) {
                        start.getCoveredInstanceRoles().add((Object)((InstanceRole)value));
                    }
                }
                InteractionFragment finish = ((CombinedFragment)semanticElement).getFinish();
                if (start != null) {
                    finish.getCoveredInstanceRoles().clear();
                    for (EObject value : values) {
                        finish.getCoveredInstanceRoles().add((Object)((InstanceRole)value));
                    }
                }
                UIUtil.getInstance().refreshActiveDiagram(null);
                return values;
            }

            public List<EObject> readOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, boolean available) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                if (available) {
                    result.addAll((Collection<EObject>)((Scenario)semanticElement.eContainer()).getOwnedInstanceRoles());
                } else {
                    result.addAll(this.loadValues(semanticElement, semanticFeature));
                }
                return result;
            }

            public List<EObject> loadValues(EObject semanticElement, EStructuralFeature semanticFeature) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                result.addAll(AbstractFragmentExt.getCoveredInstanceRoles((FragmentEnd)((FragmentEnd)((CombinedFragment)semanticElement).getStart()), (FragmentEnd)((FragmentEnd)((CombinedFragment)semanticElement).getFinish()), (Scenario)((Scenario)semanticElement.eContainer())));
                return result;
            }
        }){

            protected void doDeleteCommand(EObject element, EStructuralFeature feature) {
                Set covered = AbstractFragmentExt.getMinimalCoveredInstanceRoles((CombinedFragment)((CombinedFragment)element));
                for (InteractionOperand operand : ((CombinedFragment)element).getReferencedOperands()) {
                    operand.getCoveredInstanceRoles().clear();
                    operand.getCoveredInstanceRoles().addAll((Collection)covered);
                }
                InteractionFragment start = ((CombinedFragment)element).getStart();
                if (start != null) {
                    start.getCoveredInstanceRoles().clear();
                    start.getCoveredInstanceRoles().addAll((Collection)covered);
                }
                InteractionFragment finish = ((CombinedFragment)element).getFinish();
                if (start != null) {
                    finish.getCoveredInstanceRoles().clear();
                    finish.getCoveredInstanceRoles().addAll((Collection)covered);
                }
                UIUtil.getInstance().refreshActiveDiagram(null);
                this.setValueTextField(covered);
            }
        };
        this.coveredInstanceRolesWidget.setDisplayedInWizard(displayedInWizard);
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.interactionOperatorKindGroup.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getCombinedFragment_Operator());
        this.coveredInstanceRolesWidget.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getInteractionFragment_CoveredInstanceRoles());
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == InteractionPackage.eINSTANCE.getCombinedFragment();
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.coveredInstanceRolesWidget);
        fields.add((AbstractSemanticField)this.interactionOperatorKindGroup);
        return fields;
    }
}

