/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.net.URL;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DecoratorAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EObjectLabelProviderHelper {
    private static final String FEATURE_GENERATED_KEY_SUFFIX = "_feature";
    private static final String METACLASS_GENERATED_KEY_SUFFIX = "_type";
    private static final String GENERATED_KEY_PREFIX = "_UI_";
    private static final String METACLASS_DISPLAY_PREFIX = "(";
    private static final String METACLASS_DISPLAY_SUFFIX = ") ";
    public static final String FULL_PATH_SEPARATOR = "::";

    protected static IItemLabelProvider getItemLabelProvider(EObject object) {
        if (object == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return null;
        }
        return (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
    }

    private static String getTextEObject(EObject object) {
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object);
        String label = "";
        if (provider != null) {
            label = provider.getText((Object)object);
        }
        return label;
    }

    public static String getMetaclassLabel(EObject object, boolean addParenthesis) {
        Object label = null;
        if (object == null) {
            return label;
        }
        ItemProviderAdapter provider = EObjectLabelProviderHelper.getItemProvider(object);
        if (provider instanceof ItemProviderAdapter) {
            label = EObjectLabelProviderHelper.getMetaclassLabel(object.eClass(), provider);
        }
        if (addParenthesis) {
            label = METACLASS_DISPLAY_PREFIX + label + METACLASS_DISPLAY_SUFFIX;
        }
        return label;
    }

    public static String getMetaclassLabel(EClass eClass, AdapterFactoryEditingDomain editingDomain) {
        ResourceBundle resourceBundle;
        Bundle bundle = EObjectLabelProviderHelper.getGenBundle(eClass, editingDomain);
        String label = "";
        if (bundle != null && (resourceBundle = Platform.getResourceBundle((Bundle)bundle)) != null) {
            label = resourceBundle.getString(GENERATED_KEY_PREFIX + eClass.getName() + METACLASS_GENERATED_KEY_SUFFIX);
        }
        return label;
    }

    public static ImageDescriptor getImage(EClass eClass, AdapterFactoryEditingDomain editingDomain) {
        ResourceBundle resourceBundle;
        Bundle bundle = EObjectLabelProviderHelper.getGenBundle(eClass, editingDomain);
        ImageDescriptor imageDescriptor = null;
        if (bundle != null && (resourceBundle = Platform.getResourceBundle((Bundle)bundle)) != null) {
            URL imageURL = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/" + eClass.getName() + ".gif"), null);
            imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)imageURL);
        }
        return imageDescriptor;
    }

    private static Bundle getGenBundle(EClass eClass, AdapterFactoryEditingDomain editingDomain) {
        EPackage selectedEPackage = eClass.getEPackage();
        AdapterFactory adapterFactory = editingDomain.getAdapterFactory();
        Bundle bundle = null;
        if (adapterFactory instanceof ComposedAdapterFactory) {
            AdapterFactory selectedAdapterFactory = ((ComposedAdapterFactory)adapterFactory).getFactoryForType((Object)selectedEPackage);
            if (selectedAdapterFactory instanceof DecoratorAdapterFactory) {
                AdapterFactory decoratedAdapterFactory = ((DecoratorAdapterFactory)selectedAdapterFactory).getDecoratedAdapterFactory();
                bundle = FrameworkUtil.getBundle(decoratedAdapterFactory.getClass());
            } else {
                bundle = FrameworkUtil.getBundle(selectedAdapterFactory.getClass());
            }
        }
        return bundle;
    }

    public static ItemProviderAdapter getItemProvider(EObject object) {
        if (object == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return null;
        }
        return EObjectLabelProviderHelper.getItemProvider(object, editingDomain.getAdapterFactory());
    }

    public static ItemProviderAdapter getItemProvider(EObject object, AdapterFactory factory) {
        IChangeNotifier notifier;
        if (object == null) {
            return null;
        }
        Adapter adapter = factory.adapt((Notifier)object, IItemLabelProvider.class);
        if (adapter instanceof ItemProviderDecorator && (notifier = ((ItemProviderDecorator)adapter).getDecoratedItemProvider()) instanceof ItemProviderAdapter) {
            return (ItemProviderAdapter)notifier;
        }
        return (ItemProviderAdapter)adapter;
    }

    public static String getMetaclassLabel(EClass cls, ItemProviderAdapter provider) {
        Object label = null;
        if (cls == null || provider == null) {
            return label;
        }
        try {
            label = provider.getString(GENERATED_KEY_PREFIX + cls.getName() + METACLASS_GENERATED_KEY_SUFFIX);
        }
        catch (MissingResourceException e) {
            label = "<<MissingResourceException>> [" + cls.getName() + "]";
        }
        return label;
    }

    public static String getFeatureLabel(EStructuralFeature feature, ItemProviderAdapter provider) {
        String label = null;
        if (feature == null || provider == null) {
            return label;
        }
        String featureKey = feature.getEContainingClass().getName() + "_" + feature.getName();
        label = provider.getString(GENERATED_KEY_PREFIX + featureKey + FEATURE_GENERATED_KEY_SUFFIX);
        return label;
    }

    protected static void getText(Object affectedObject, StringBuilder value) {
        if (affectedObject != null) {
            if (affectedObject instanceof EObject) {
                value.append(EObjectLabelProviderHelper.getText(affectedObject));
            } else if (affectedObject instanceof Collection) {
                Collection coll = (Collection)affectedObject;
                value.append("{");
                for (Object o : coll) {
                    EObjectLabelProviderHelper.getText(o, value);
                    value.append(';');
                }
                if (coll.size() > 0) {
                    value.deleteCharAt(value.length() - 1);
                }
                value.append("}");
            } else {
                value.append(affectedObject.toString());
            }
        }
    }

    public static String getText(Object object) {
        if (object instanceof EObject) {
            return EObjectLabelProviderHelper.getTextEObject((EObject)object);
        }
        StringBuilder buffer = new StringBuilder();
        EObjectLabelProviderHelper.getText(object, buffer);
        return buffer.toString();
    }

    public static Object getImage(EObject object) {
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object);
        if (provider != null) {
            return provider.getImage((Object)object);
        }
        return null;
    }

    public static String getFullPathText(EObject element) {
        String path = EObjectLabelProviderHelper.getText(element);
        EObject container = element.eContainer();
        while (container != null) {
            path = EObjectLabelProviderHelper.getText(container).concat(FULL_PATH_SEPARATOR).concat(path);
            container = container.eContainer();
        }
        return path;
    }
}

