/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.traceability;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.session.SessionHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler2;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TwoSideTraceabilityHandler
implements ITraceabilityHandler2 {
    private String identifier;
    private String identifierFm;
    private String identifierBm;
    private static final String FORWARD_MAPPINGS = "Fm";
    private static final String BACKWARD_MAPPINGS = "Bm";

    public String getIdentifier() {
        return this.identifier;
    }

    public TwoSideTraceabilityHandler(String identifier) {
        this.identifier = this.getClass().getName() + identifier;
        this.identifierFm = FORWARD_MAPPINGS + this.getIdentifier();
        this.identifierBm = BACKWARD_MAPPINGS + this.getIdentifier();
    }

    protected String getForwardMappingKey() {
        return this.identifierFm;
    }

    protected String getBackwardMappingKey() {
        return this.identifierBm;
    }

    protected MappingTraceability getForwardMappings(EObject source, IContext context) {
        return this.getMappings(source, context, this.getForwardMappingKey());
    }

    protected MappingTraceability getBackwardMappings(EObject source, IContext context) {
        return this.getMappings(source, context, this.getBackwardMappingKey());
    }

    protected MappingTraceability createMappingTraceability(EObject source, IContext context, String key) {
        return new MappingTraceability();
    }

    protected MappingTraceability getMappings(EObject source, IContext context, String key) {
        MappingTraceability map = (MappingTraceability)context.get((Object)key);
        if (map == null) {
            map = this.createMappingTraceability(source, context, key);
            context.put((Object)key, (Object)map);
        }
        return map;
    }

    protected void addMappings(EObject sourceElement, EObject targetElement, IContext context) {
        this.addMapping(this.getForwardMappings(sourceElement, context), sourceElement, targetElement, context);
        this.addMapping(this.getBackwardMappings(sourceElement, context), sourceElement, targetElement, context);
    }

    protected void removeMapping(MappingTraceability map, EObject obj, IContext context) {
        map.remove(obj);
    }

    protected void addMapping(MappingTraceability map, EObject sourceElement, EObject targetElement, IContext context) {
        if (map.equals(context.get((Object)this.getForwardMappingKey()))) {
            if (sourceElement != null && targetElement != null) {
                map.put(sourceElement, targetElement);
            }
        } else if (sourceElement != null && targetElement != null) {
            map.put(targetElement, sourceElement);
        }
    }

    @Override
    public void attachTraceability(EObject sourceElement, EObject targetElement, IContext context) {
    }

    protected Collection<EObject> retrieveRelatedElements(EObject source, IContext context, MappingTraceability maps) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (maps.contains(source)) {
            Collection mapped = maps.get(source);
            result.addAll(mapped);
        }
        return result;
    }

    @Override
    public Collection<EObject> retrieveTracedElements(EObject source, IContext context) {
        return this.retrieveRelatedElements(source, context, this.getForwardMappings(source, context));
    }

    @Override
    public Collection<EObject> retrieveSourceElements(EObject source, IContext context) {
        return this.retrieveRelatedElements(source, context, this.getBackwardMappings(source, context));
    }

    @Override
    @Deprecated
    public boolean isTraced(EObject element, IContext context) {
        return this.retrieveTracedElements(element, context).size() > 0;
    }

    @Override
    @Deprecated
    public Collection<EObject> retrieveTracedElements(EObject source, IContext context, EClass clazz) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject obj : this.retrieveTracedElements(source, context)) {
            if (!clazz.isInstance((Object)obj)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    @Deprecated
    public String getId(EObject element, IContext context) {
        return SessionHandlerHelper.getInstance(context).getId(element, context);
    }

    @Override
    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }
}

