/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;

public class SharedWorkflowActivityParameter
extends WorkflowActivityParameter {
    protected ActivityParameters _sharedParameters = new ActivityParameters();

    public void addSharedParameter(GenericParameter<?> parameter) {
        GenericParameter currentParameter = this._sharedParameters.getParameter(parameter.getName());
        if (currentParameter == null) {
            this._sharedParameters.addParameter(parameter);
        } else if (!Objects.equals(currentParameter.getValue(), parameter.getValue()) && Platform.inDevelopmentMode()) {
            System.out.println(NLS.bind((String)"Attempt to override shared parameter {0} by another value.", (Object)parameter.getName()));
        }
    }

    public void removeSharedParameter(String parameterId) {
        this._sharedParameters.removeParameter(parameterId);
    }

    public void merge(SharedWorkflowActivityParameter sharedParameter) {
        for (String idActivity : sharedParameter.getActivitiesID()) {
            this.addParameter(idActivity, sharedParameter.getSpecificActivityParameters(idActivity));
        }
        for (GenericParameter parameter : sharedParameter._sharedParameters.getParameters()) {
            this.addSharedParameter(parameter);
        }
    }

    protected ActivityParameters getSpecificActivityParameters(String idActivity) {
        return super.getActivityParameters(idActivity);
    }

    public ActivityParameters getActivityParameters(String idActivity) {
        ActivityParameters activityParameter = super.getActivityParameters(idActivity);
        if (activityParameter == null) {
            activityParameter = new ActivityParameters();
        }
        for (GenericParameter sharedParameter : this._sharedParameters.getParameters()) {
            activityParameter.addParameter(sharedParameter);
        }
        return activityParameter;
    }
}

