/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram.LinkDescription;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.ILinkModifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptionLinkModifierHandler
extends DefaultHandler {
    private ILinkModifier linkModifierHandler;
    private final EObject element;
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder initialDescription;
    protected StringBuilder updatedDescription;

    public DescriptionLinkModifierHandler(EObject element, ILinkModifier linkModifierHandler) {
        this.element = element;
        this.linkModifierHandler = linkModifierHandler;
    }

    public static void addElementToDescription(String qName, Attributes attributes, StringBuilder description) {
        description.append("<");
        description.append(qName);
        if (attributes.getLength() == 0) {
            description.append(">");
        } else {
            int i = 0;
            while (i < attributes.getLength()) {
                String attValue = attributes.getValue(i);
                String attName = attributes.getQName(i);
                description.append(" ");
                description.append(attName);
                description.append("=");
                description.append("\"");
                description.append(attValue);
                description.append("\"");
                ++i;
            }
            if (qName.equals("img")) {
                description.append("/");
            }
            description.append(">");
        }
    }

    public String process(String description) {
        if (description != null && !description.isEmpty()) {
            this.initialDescription = new StringBuilder();
            this.updatedDescription = new StringBuilder();
            description = SaxParserHelper.escapeSpecialCharacter((String)description);
            this.initialDescription.append("<rootSAX>");
            this.initialDescription.append(description);
            this.initialDescription.append("</rootSAX>");
            SAXParser saxParser = null;
            StringReader reader = null;
            try {
                try {
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setValidating(false);
                    saxParser = saxFactory.newSAXParser();
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    LinkParserHandler handler = new LinkParserHandler();
                    InputSource is = new InputSource();
                    reader = new StringReader(this.initialDescription.toString());
                    is.setCharacterStream(reader);
                    saxParser.parse(is, (DefaultHandler)handler);
                }
                catch (Exception exception) {
                    this.logger.error((Object)("Exception while quick fix : " + exception.toString()));
                    if (reader != null) {
                        reader.close();
                    }
                    if (saxParser != null) {
                        saxParser.reset();
                    }
                    return null;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (saxParser != null) {
                    saxParser.reset();
                }
            }
            String result = this.updatedDescription.toString().replaceAll("<rootSAX>", "");
            result = result.replaceAll("</rootSAX>", "");
            return result;
        }
        return "";
    }

    private class LinkParserHandler
    extends DefaultHandler {
        private EObject currentTargetElement;
        private String currentLinkHref;
        private Attributes currentLinkAttributes;
        private boolean valueToAdd = false;
        private StringBuilder elementValue = new StringBuilder();
        private boolean insideLink = false;

        private LinkParserHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.valueToAdd = true;
            this.elementValue.append(new String(ch, start, length));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.valueToAdd) {
                DescriptionLinkModifierHandler.this.updatedDescription.append(this.elementValue.toString());
                this.valueToAdd = false;
            }
            this.elementValue = new StringBuilder(0);
            if (qName.equals("br")) {
                return;
            }
            if (qName.equalsIgnoreCase("a")) {
                this.insideLink = true;
                AttributesImpl atts = new AttributesImpl();
                atts.setAttributes(attributes);
                this.currentTargetElement = null;
                this.currentLinkAttributes = atts;
                int i = 0;
                while (i < attributes.getLength()) {
                    String attValue = attributes.getValue(i);
                    String attName = attributes.getQName(i);
                    if (attValue != null && !attValue.isEmpty() && qName.equalsIgnoreCase("a") && attName.equalsIgnoreCase("href")) {
                        this.currentLinkHref = attValue;
                        EObject eObject = SaxParserHelper.getEObjectFromHrefAttribute((EObject)DescriptionLinkModifierHandler.this.element, (String)attValue);
                        if (eObject != null) {
                            this.currentTargetElement = eObject;
                            break;
                        }
                    }
                    ++i;
                }
            } else if (!this.insideLink) {
                DescriptionLinkModifierHandler.addElementToDescription(qName, attributes, DescriptionLinkModifierHandler.this.updatedDescription);
            } else {
                return;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("img")) {
                return;
            }
            if (qName.equals("br")) {
                DescriptionLinkModifierHandler.this.updatedDescription.append("<br />");
                return;
            }
            if (qName.equalsIgnoreCase("a")) {
                this.insideLink = false;
                String formattedLinkContent = this.elementValue.toString();
                formattedLinkContent = formattedLinkContent.replaceAll("\\s+", " ");
                LinkDescription parsedLink = new LinkDescription(formattedLinkContent, this.currentLinkHref, this.currentTargetElement, this.currentLinkAttributes);
                DescriptionLinkModifierHandler.this.linkModifierHandler.updateParsedLink(parsedLink, DescriptionLinkModifierHandler.this.updatedDescription);
                this.currentTargetElement = null;
                this.currentLinkHref = "";
            } else if (!this.insideLink) {
                if (this.valueToAdd) {
                    DescriptionLinkModifierHandler.this.updatedDescription.append(this.elementValue.toString());
                }
                DescriptionLinkModifierHandler.this.updatedDescription.append("</");
                DescriptionLinkModifierHandler.this.updatedDescription.append(qName);
                DescriptionLinkModifierHandler.this.updatedDescription.append(">");
            } else {
                return;
            }
            this.valueToAdd = false;
            this.elementValue = new StringBuilder(0);
        }
    }
}

