/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;
import org.polarsys.capella.core.tiger.Activator;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRule;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.impl.TransfoRule;

public class TransfoRuleBase
implements ITransfoRuleBase {
    private List<TransfoRule> _rules = new ArrayList<TransfoRule>();
    private Map<EClass, List<TransfoRule>> _rulesMapping = new HashMap<EClass, List<TransfoRule>>();
    private static String CR = System.getProperty("line.separator");

    @Override
    public Iterator<TransfoRule> iterator() {
        return this._rules.iterator();
    }

    @Override
    public void addRule(TransfoRule rule) {
        EClass sourceType = rule.getSourceType();
        List<TransfoRule> candidates = this._rulesMapping.get(sourceType);
        if (candidates == null) {
            candidates = new ArrayList<TransfoRule>();
        }
        candidates.add(rule);
        this._rulesMapping.put(rule.getSourceType(), candidates);
        this._rules.add(rule);
    }

    @Override
    public ITransfoRule findMatchingRule(EObject element, ITransfo transfo) throws TransfoException {
        EClass sourceType = element.eClass();
        List<TransfoRule> candidates = this._rulesMapping.get(sourceType);
        if (candidates != null) {
            for (ITransfoRule iTransfoRule : candidates) {
                if (!iTransfoRule.isActive() || !iTransfoRule.when(element, transfo)) continue;
                return iTransfoRule;
            }
        }
        candidates = new ArrayList<TransfoRule>();
        for (EClass eClass : this._rulesMapping.keySet()) {
            if (!eClass.isSuperTypeOf(sourceType)) continue;
            candidates.addAll((Collection<TransfoRule>)this._rulesMapping.get(eClass));
        }
        for (ITransfoRule iTransfoRule : candidates) {
            if (!iTransfoRule.isActive() || !iTransfoRule.when(element, transfo)) continue;
            return iTransfoRule;
        }
        return null;
    }

    public static Class[] getClasses(String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        File directory = null;
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            String path = packageName.replace('.', '/');
            URL resource = cld.getResource(path);
            if (resource == null) {
                throw new ClassNotFoundException("No resource for " + path);
            }
            directory = new File(resource.getFile());
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(packageName + " (" + String.valueOf(directory) + ") does not appear to be a valid package");
        }
        if (directory.exists()) {
            String[] files = directory.list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].endsWith(".class")) {
                        classes.add(Class.forName(packageName + "." + files[i].substring(0, files[i].length() - 6)));
                    }
                    ++i;
                }
            }
        } else {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package");
        }
        Class[] foundedClasses = new Class[classes.size()];
        classes.toArray(foundedClasses);
        return foundedClasses;
    }

    @Override
    public void loadRules(String rulePkgName) throws ClassNotFoundException {
        Class[] classes;
        Class[] classArray = classes = TransfoRuleBase.getClasses(rulePkgName);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class class_ = classArray[n2];
            this.loadRule(class_);
            ++n2;
        }
    }

    @Override
    public void loadRule(Class<?> ruleClass) {
        try {
            Object obj = ruleClass.newInstance();
            this.addRule((TransfoRule)obj);
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void loadRules(String rulePkgName, String[] classNames) throws ClassNotFoundException {
        Bundle bundle = Activator.getDefault().getBundle();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            Class class_ = bundle.loadClass(rulePkgName + "." + className);
            this.loadRule(class_);
            ++n2;
        }
    }

    @Override
    public String toHtml(boolean standalone) {
        StringBuilder htmlDoc = new StringBuilder();
        if (standalone) {
            htmlDoc.append("<html>").append(CR);
            htmlDoc.append("<head>").append(CR);
            htmlDoc.append("<title> Rule Base Documentation </title>").append(CR);
            htmlDoc.append("</head>").append(CR);
            htmlDoc.append("<body>").append(CR);
        }
        htmlDoc.append("<table border=2>").append(CR);
        htmlDoc.append("<tr>").append(CR);
        htmlDoc.append("<th> Name").append(CR);
        htmlDoc.append("</th>").append(CR);
        htmlDoc.append("<th> Inherits").append(CR);
        htmlDoc.append("</th>").append(CR);
        htmlDoc.append("<th colspan='4'> Type").append(CR);
        htmlDoc.append("</th>").append(CR);
        htmlDoc.append("<th> Updated Attributes").append(CR);
        htmlDoc.append("</th>").append(CR);
        htmlDoc.append("<th> Description").append(CR);
        htmlDoc.append("</th>").append(CR);
        htmlDoc.append("</tr>").append(CR);
        Collections.sort(this._rules);
        int size = this._rules.size();
        int i = 0;
        while (i < size) {
            htmlDoc.append("<tr>").append(CR);
            htmlDoc.append(this._rules.get(i).toHtml(false));
            htmlDoc.append("</tr>").append(CR);
            ++i;
        }
        htmlDoc.append("</table>").append(CR);
        if (standalone) {
            htmlDoc.append("</body>").append(CR);
            htmlDoc.append("</html>").append(CR);
        }
        return htmlDoc.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TransfoRuleBase: ").append(CR);
        builder.append(" + Applicable rules").append(CR);
        for (ITransfoRule iTransfoRule : this._rules) {
            builder.append("   - Rule " + iTransfoRule.getName() + " [Active=" + iTransfoRule.isActive() + "]");
            builder.append(CR);
        }
        builder.append(" + Rules Mapping").append(CR);
        for (EClass eClass : this._rulesMapping.keySet()) {
            builder.append("   - ").append(eClass.getName());
            builder.append(" : ");
            List<TransfoRule> candidates = this._rulesMapping.get(eClass);
            for (ITransfoRule iTransfoRule : candidates) {
                if (!iTransfoRule.isActive()) {
                    builder.append("[");
                }
                builder.append(iTransfoRule.getShortName());
                if (!iTransfoRule.isActive()) {
                    builder.append("]");
                }
                builder.append(" ");
            }
            builder.append(CR);
        }
        return builder.toString();
    }
}

