/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.exchangeitem;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class InheritanceConstraintForExchangeItemElement
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        ExchangeItem ei2 = null;
        ExchangeItemElement eie2 = null;
        AbstractType t2 = null;
        ExchangeItem ei1 = null;
        ExchangeItemElement eie1 = null;
        Object t1 = null;
        EObject eObj = ctx.getTarget();
        if (eObj instanceof ExchangeItem) {
            EList superItems;
            ei2 = (ExchangeItem)eObj;
            EList elements = ei2.getOwnedElements();
            if (elements.size() == 1 && (eie2 = (ExchangeItemElement)elements.get(0)) != null) {
                t2 = eie2.getAbstractType();
            }
            if ((superItems = ei2.getSuper()).size() == 1 && (elements = (ei1 = (ExchangeItem)superItems.get(0)).getOwnedElements()).size() == 1) {
                eie1 = (ExchangeItemElement)elements.get(0);
                t1 = eie1.getAbstractType();
            }
        }
        if (ei1 != null) {
            if (t2 != null && !(t2 instanceof GeneralizableElement) && eie2.getKind() == ElementKind.TYPE) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)ei2), "Exchange Item Element of " + CapellaElementExt.getCapellaExplorerLabel((EObject)ei2) + " must be a Generalizable Element"});
            }
            if (t2 != null && eie2.getKind() == ElementKind.TYPE && t1 != null && eie1.getKind() == ElementKind.TYPE) {
                GeneralizableElement t2Gen = (GeneralizableElement)t2;
                if (!t1.equals(t2Gen) && !this.isInSuperType((AbstractType)t1, t2Gen)) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)ei2), "Type of Exchange Item Element of " + CapellaElementExt.getCapellaExplorerLabel((EObject)ei2) + " must be a subtype of " + CapellaElementExt.getCapellaExplorerLabel((EObject)t1)});
                }
            } else {
                if (t2 == null && t1 != null && eie2 != null) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)ei2), "Type of Exchange Item Element of " + CapellaElementExt.getCapellaExplorerLabel((EObject)ei2) + " is not defined (must be a subtype of " + CapellaElementExt.getCapellaExplorerLabel((EObject)t1) + ")"});
                }
                if (t1 == null && t2 != null && eie1 != null) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)ei2), "Type of Exchange Item Element of " + CapellaElementExt.getCapellaExplorerLabel((EObject)ei1) + " must be defined"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isInSuperType(AbstractType element, GeneralizableElement typeLeaf) {
        EList genElts = typeLeaf.getSuper();
        boolean res = genElts.contains(element);
        int i = 0;
        while (!res && i < genElts.size()) {
            res = this.isInSuperType(element, (GeneralizableElement)genElts.get(i));
            ++i;
        }
        return res;
    }
}

