/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;

public class GetAvailable_PhysicalPath_AllocatedComponentExchanges
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<Object> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    private List<Object> getAvailableElements(CapellaElement element) {
        if (element instanceof PhysicalPath) {
            return List.copyOf(this.getPhysicalPathAllocatedComponentExchanges((PhysicalPath)element));
        }
        return Collections.emptyList();
    }

    private Set<ComponentExchange> getPhysicalPathAllocatedComponentExchanges(PhysicalPath element) {
        HashSet<ComponentExchange> availableElements = new HashSet<ComponentExchange>();
        ArrayList<Component> terminalPCs = new ArrayList<Component>();
        this.retreiveTerminalPCs(PhysicalPathExt.getFlatFirstPhysicalPathInvolvments((PhysicalPath)element), terminalPCs);
        this.retreiveTerminalPCs(PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)element), terminalPCs);
        int i = 0;
        while (i < terminalPCs.size() - 1) {
            Component sourceComponent = (Component)terminalPCs.get(i);
            int j = i + 1;
            while (j < terminalPCs.size()) {
                Component targetComponent = (Component)terminalPCs.get(j);
                availableElements.addAll(this.getAvailableExchanges(sourceComponent, targetComponent));
                ++j;
            }
            ++i;
        }
        return availableElements;
    }

    private void retreiveTerminalPCs(Collection<PhysicalPathInvolvement> physicalPathInvolvments, List<Component> terminalPCs) {
        for (PhysicalPathInvolvement first : physicalPathInvolvments) {
            AbstractType pc;
            AbstractPathInvolvedElement involvedElt = first.getInvolvedElement();
            if (!(involvedElt instanceof Part) || !((pc = ((Part)involvedElt).getAbstractType()) instanceof Component) || terminalPCs.contains(pc)) continue;
            terminalPCs.add((Component)pc);
        }
    }

    private Set<ComponentExchange> getAvailableExchanges(Component sourceComponent, Component targetComponent) {
        List sourceDeployedElements = PartExt.getComponentsOfParts((Collection)ComponentExt.getAllSubUsedParts((Component)sourceComponent, (boolean)true));
        sourceDeployedElements.add(sourceComponent);
        List targetDeployedElements = PartExt.getComponentsOfParts((Collection)ComponentExt.getAllSubUsedParts((Component)targetComponent, (boolean)true));
        targetDeployedElements.add(targetComponent);
        HashSet<ComponentExchange> availableElements = new HashSet<ComponentExchange>();
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes((List)sourceDeployedElements, (List)targetDeployedElements));
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes((List)targetDeployedElements, (List)sourceDeployedElements));
        return availableElements;
    }
}

