/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.interaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalArchitecture;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.queries.GetAllExchangeItems;
import org.polarsys.capella.core.model.helpers.queries.filters.OnlySharedDataOrEventOrUnsetFilter;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_InstanceRole_RepresentedInstance
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        if (capellaElement instanceof InstanceRole) {
            SystemEngineering sysEng;
            Scenario scenario = (Scenario)capellaElement.eContainer();
            InstanceRole ir = (InstanceRole)capellaElement;
            if (ir.getRepresentedInstance() instanceof ExchangeItemInstance) {
                List exchangeItems = new GetAllExchangeItems().execute((Object)ir, context);
                for (ExchangeItem ei : exchangeItems) {
                    if (!new OnlySharedDataOrEventOrUnsetFilter().keepElement((Object)ei, context)) continue;
                    availableElements.addAll((Collection<Object>)ei.getOwnedExchangeItemInstances());
                }
            }
            if ((sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)capellaElement)) != null) {
                if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
                    availableElements.addAll(this.getAvailableElementsForFunctionalScenario(scenario));
                } else if (scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERFACE) {
                    availableElements.addAll(this.getAvailableElementsForComponents(scenario));
                } else if (scenario.getKind() == ScenarioKind.INTERACTION) {
                    if (ir.getRepresentedInstance() instanceof OperationalActivity) {
                        availableElements.addAll(this.getAvailableElementsForFunctionalScenario(scenario));
                    } else {
                        availableElements.addAll(this.getAvailableElementsForEntities(scenario));
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getAvailableElementsForFunctionalScenario(Scenario scenario) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        AbstractFunctionalArchitecture archi = (AbstractFunctionalArchitecture)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE);
        FunctionPkg fpackage = archi.getOwnedFunctionPkg();
        for (Object obj : EcoreUtil2.getAllContents((Collection)FunctionPkgExt.getOwnedFunctions((FunctionPkg)fpackage))) {
            if (!(obj instanceof AbstractFunction)) continue;
            result.add((CapellaElement)obj);
        }
        return result;
    }

    private List<CapellaElement> getAvailableElementsForComponents(Scenario scenario) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        result.addAll(ScenarioExt.getAllAvailableParts((EObject)scenario, Collections.emptyList()));
        for (Component aa : ScenarioExt.getAllActors((EObject)scenario)) {
            for (AbstractTypedElement ate : aa.getAbstractTypedElements()) {
                if (!(ate instanceof Part)) continue;
                result.add((CapellaElement)((Part)ate));
            }
        }
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
        Component root = ba.getSystem();
        if (root != null) {
            for (Part te : root.getRepresentingParts()) {
                result.add((CapellaElement)te);
            }
        }
        return result;
    }

    private Collection<? extends CapellaElement> getAvailableElementsForEntities(Scenario scenario) {
        return ScenarioExt.getAllComponents((EObject)scenario, Collections.emptyList());
    }
}

